/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.interval29;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.CacheStrategySpec;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerEdge;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.features.interval29.Interval29Tools;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.util.Assert;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StateTransitionsInterval29
extends AbstractFeatureManager<Character>
implements FeatureManagerEdge<Character> {
    private static final long serialVersionUID = -7745853849576425025L;
    private static final Log log = LogFactory.getLog(StateTransitionsInterval29.class);
    private int startIx;
    private double intronProb;
    private double endProb;

    @Override
    public String getFeatureName(int featureIndex) {
        return "State transition log-probabilities for the model Interval29";
    }

    @Override
    public int getNumFeatures() {
        return 1;
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List<? extends TrainingSequence<? extends Character>> data) {
        Interval29Tools.verify(modelInfo);
        this.startIx = startingIndex;
        int intronCount = 0;
        int geneCount = 0;
        for (TrainingSequence<? extends Character> trainingSequence : data) {
            int[] y = trainingSequence.getY();
            int prevState = y[0];
            for (int i = 1; i < y.length; ++i) {
                int state = y[i];
                switch (Interval29Tools.edgeConstraints[prevState * Interval29Tools.numStates + state]) {
                    case PDON: 
                    case MACC: {
                        ++intronCount;
                        break;
                    }
                    case PSTOP: 
                    case MSTART: {
                        ++geneCount;
                        break;
                    }
                }
                prevState = state;
            }
        }
        double avgExonCount = (intronCount + geneCount) / geneCount;
        this.endProb = Math.log(1.0 / avgExonCount);
        this.intronProb = Math.log(1.0 - 1.0 / avgExonCount);
        log.info((Object)String.format("%d genes, %d introns, %.2f exons/gene", geneCount, intronCount, avgExonCount));
    }

    @Override
    public void evaluateEdge(InputSequence<? extends Character> seq, int pos, int prevState, int state, FeatureList result) {
        switch (Interval29Tools.edgeConstraints[prevState * Interval29Tools.numStates + state]) {
            case NONE: 
            case PACC: 
            case MDON: 
            case PCODE: 
            case MCODE: {
                break;
            }
            case PSTART: 
            case MSTOP: {
                result.addFeature(this.startIx, Math.log(0.5));
                break;
            }
            case PDON: 
            case MACC: {
                result.addFeature(this.startIx, this.intronProb);
                break;
            }
            case PSTOP: 
            case MSTART: {
                result.addFeature(this.startIx, this.endProb);
                break;
            }
            case NEVER: 
            case PKEEPE: 
            case PKEEPI: 
            case MKEEPE: 
            case MKEEPI: 
            case PSTOPPED: 
            case MSTARTED: 
            case PWILLSTART: 
            case MWILLSTOP: {
                break;
            }
            default: {
                Assert.a(false);
            }
        }
    }

    @Override
    public CacheStrategySpec getCacheStrategy() {
        return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.CONSTANT);
    }

    public double getEndProb() {
        return this.endProb;
    }

    public double getIntronProb() {
        return this.intronProb;
    }
}

