/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.supporting;

import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.seq.KmerHasher;
import calhoun.util.Assert;
import java.io.Serializable;
import java.util.List;

public class MarkovPredictorLogprob
implements Serializable {
    private static final long serialVersionUID = -3801967331270040642L;
    boolean trainedYet = false;
    List<int[]> history;
    int nStates;
    int[] kmerLengths;
    KmerHasher[] hashers;
    float[][][] logProb;
    int maxLength;
    KmerHasher h;
    int[] currentHash;
    char[] scratch;
    transient InputSequence<? extends Character> lastSeq = null;
    int lastPos = -1;
    char lastChar;
    int singleHash;

    public MarkovPredictorLogprob(List<int[]> history) {
        this.history = history;
        this.nStates = history.size();
        this.kmerLengths = new int[this.nStates];
        this.hashers = new KmerHasher[this.nStates];
        this.logProb = new float[this.nStates][][];
        this.currentHash = new int[this.nStates];
        this.h = new KmerHasher(KmerHasher.ACGTN, 1);
        this.maxLength = 0;
        for (int j = 0; j < this.nStates; ++j) {
            this.kmerLengths[j] = history.get(j).length;
            this.maxLength = Math.max(this.kmerLengths[j], this.maxLength);
            this.hashers[j] = new KmerHasher(KmerHasher.ACGTN, this.kmerLengths[j]);
            int historyRange = this.hashers[j].range();
            int range = this.h.range();
            this.logProb[j] = new float[historyRange][this.h.range()];
            for (int k = 0; k < historyRange; ++k) {
                for (int l = 0; l < range; ++l) {
                    this.logProb[j][k][l] = 1.0f;
                }
            }
        }
        this.scratch = new char[this.maxLength];
    }

    public float logprob(int state, InputSequence<? extends Character> seq, int pos) {
        Assert.a(this.trainedYet);
        if (pos < this.maxLength || pos >= seq.length()) {
            return 0.0f;
        }
        if (seq != this.lastSeq || pos != this.lastPos) {
            if (pos == this.lastPos + 1) {
                this.updateHashes(this.lastChar);
            } else {
                this.initHashes(seq, pos);
            }
            this.lastSeq = seq;
            this.lastPos = pos;
            this.lastChar = seq.getX(pos).charValue();
            this.singleHash = this.h.hash(this.lastChar);
        }
        return this.logProb[state][this.currentHash[state]][this.singleHash];
    }

    /*
     * WARNING - void declaration
     */
    public void train(List<? extends TrainingSequence<? extends Character>> data) {
        if (this.trainedYet) {
            return;
        }
        for (TrainingSequence<? extends Character> trainingSequence : data) {
            int len = trainingSequence.length();
            this.initHashes(trainingSequence, this.maxLength);
            for (int pos = this.maxLength; pos < len; ++pos) {
                int v = trainingSequence.getY(pos);
                boolean okHistory = true;
                for (int i = 0; i < this.kmerLengths[v]; ++i) {
                    if (this.history.get(v)[i] == trainingSequence.getY(pos - this.kmerLengths[v] + i)) continue;
                    okHistory = false;
                    break;
                }
                char c = trainingSequence.getX(pos).charValue();
                if (okHistory) {
                    float[] fArray = this.logProb[v][this.currentHash[v]];
                    int n = this.h.hash(c);
                    fArray[n] = fArray[n] + 1.0f;
                }
                this.updateHashes(c);
            }
        }
        for (int v = 0; v < this.nStates; ++v) {
            void var3_6;
            boolean bl = false;
            while (var3_6 < this.logProb[v].length) {
                float norm = 0.0f;
                for (int k = 0; k < this.logProb[v][var3_6].length; ++k) {
                    norm += this.logProb[v][var3_6][k];
                }
                double logNorm = Math.log(norm);
                for (int k = 0; k < this.h.range(); ++k) {
                    this.logProb[v][var3_6][k] = (float)(Math.log(this.logProb[v][var3_6][k]) - logNorm);
                }
                ++var3_6;
            }
        }
        this.trainedYet = true;
    }

    void initHashes(InputSequence<? extends Character> seq, int start) {
        for (int pos = 0; pos < this.maxLength; ++pos) {
            this.scratch[pos] = seq.getX(pos - this.maxLength + start).charValue();
        }
        for (int i = 0; i < this.currentHash.length; ++i) {
            this.currentHash[i] = this.hashers[i].hash(this.scratch, this.maxLength - this.kmerLengths[i]);
        }
    }

    void updateHashes(char c) {
        for (int i = 0; i < this.currentHash.length; ++i) {
            this.currentHash[i] = this.hashers[i].shiftHash(c, this.currentHash[i]);
        }
    }
}

