/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.supporting;

import calhoun.analysis.crf.io.InputSequence;
import calhoun.seq.KmerHasher;
import calhoun.util.Assert;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PWMLookup
implements Serializable {
    private static final long serialVersionUID = 5353716408013134581L;
    private static final Log log = LogFactory.getLog(PWMLookup.class);
    final KmerHasher.CharacterHash hashForward = KmerHasher.ACGTN;
    final KmerHasher.CharacterHash hashReverse = KmerHasher.ACGTNcomp;
    boolean finalized = false;
    final int mult = 4;
    int left;
    int right;
    int span;
    double[] lookupTable;

    public PWMLookup(int lookLeft, int lookRight, double pseudoCount) {
        this.left = lookLeft;
        this.right = lookRight;
        this.span = this.left + this.right;
        Assert.a(this.left >= 0);
        Assert.a(this.right >= 0);
        Assert.a(this.span < 30);
        int tableSize = 4 * this.span;
        this.lookupTable = new double[tableSize];
        for (int i = 0; i < tableSize; ++i) {
            this.lookupTable[i] = pseudoCount;
        }
    }

    public void increment(InputSequence<? extends Character> seq, int pos, boolean isPlus) {
        Assert.a(!this.finalized);
        if (isPlus) {
            if (pos < this.left) {
                return;
            }
            if (pos + this.right > seq.length()) {
                return;
            }
            for (int j = pos - this.left; j < pos + this.right; ++j) {
                int h = this.hashForward.hash(seq.getX(j).charValue());
                if (h >= 4) continue;
                int n = 4 * (j - pos + this.left) + h;
                this.lookupTable[n] = this.lookupTable[n] + 1.0;
            }
        } else {
            if (pos < this.right) {
                return;
            }
            if (pos + this.left > seq.length()) {
                return;
            }
            for (int j = pos + this.left - 1; j >= pos - this.right; --j) {
                int h = this.hashReverse.hash(seq.getX(j).charValue());
                if (h >= 4) continue;
                int n = 4 * (pos + this.left - 1 - j) + h;
                this.lookupTable[n] = this.lookupTable[n] + 1.0;
            }
        }
    }

    public void completeCounts() {
        Assert.a(!this.finalized);
        log.debug((Object)("finalizing a PWMlookup, span=" + this.span + "    mult=" + 4));
        for (int i = 0; i < this.span; ++i) {
            int j;
            double sum = 0.0;
            for (j = 4 * i; j < 4 * (i + 1); ++j) {
                sum += this.lookupTable[j];
            }
            for (j = 4 * i; j < 4 * (i + 1); ++j) {
                this.lookupTable[j] = Math.log(this.lookupTable[j] / sum);
                Assert.a(this.lookupTable[j] <= 0.0);
            }
        }
        this.finalized = true;
    }

    public double lookup(InputSequence<? extends Character> seq, int pos, boolean isPlus) {
        Assert.a(this.finalized);
        double ret = 0.0;
        if (isPlus) {
            if (pos < this.left) {
                return 0.0;
            }
            if (pos + this.right > seq.length()) {
                return 0.0;
            }
            for (int j = pos - this.left; j < pos + this.right; ++j) {
                int h = this.hashForward.hash(seq.getX(j).charValue());
                if (h >= 4) continue;
                ret += this.lookupTable[4 * (j - pos + this.left) + h];
            }
        } else {
            if (pos < this.right) {
                return 0.0;
            }
            if (pos + this.left > seq.length()) {
                return 0.0;
            }
            for (int j = pos + this.left - 1; j >= pos - this.right; --j) {
                int h = this.hashReverse.hash(seq.getX(j).charValue());
                if (h >= 4) continue;
                ret += this.lookupTable[4 * (pos + this.left - 1 - j) + h];
            }
        }
        Assert.a(ret <= 0.0);
        return ret;
    }
}

