/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.supporting.phylogenetic;

import calhoun.analysis.crf.features.supporting.phylogenetic.NucleotideSubstitutionModel;
import calhoun.util.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Kimura80Model
extends NucleotideSubstitutionModel {
    private static final long serialVersionUID = 4075281397219042249L;
    private static final Log log = LogFactory.getLog(Kimura80Model.class);
    double ts;
    double tv;

    public Kimura80Model(double[] parms) {
        this.setParameters(parms);
    }

    public Kimura80Model() {
        this.ts = 0.6;
        this.tv = 0.2;
    }

    @Override
    public String getEvolutionaryModelName() {
        return "Kimura80_nucleotide_evolution_model";
    }

    @Override
    public double[] getParameters() {
        double[] ret = new double[]{this.ts, this.tv};
        return ret;
    }

    @Override
    public void setParameters(double[] parms) {
        Assert.a(parms.length == 2);
        Assert.a(parms[0] > 0.0);
        Assert.a(parms[1] > 0.0);
        this.ts = parms[0];
        this.tv = parms[1];
        double[][] X = new double[4][4];
        int A = 0;
        int C = 1;
        int G = 2;
        int T = 3;
        X[A][A] = -2.0 * this.tv - this.ts;
        X[A][C] = this.tv;
        X[A][G] = this.ts;
        X[A][T] = this.tv;
        X[C][A] = this.tv;
        X[C][C] = -2.0 * this.tv - this.ts;
        X[C][G] = this.tv;
        X[C][T] = this.ts;
        X[G][A] = this.ts;
        X[G][C] = this.tv;
        X[G][G] = -2.0 * this.tv - this.ts;
        X[G][T] = this.tv;
        X[T][A] = this.tv;
        X[T][C] = this.ts;
        X[T][G] = this.tv;
        X[T][T] = -2.0 * this.tv - this.ts;
        this.R.assign(X);
    }

    @Override
    public void summarize() {
        log.debug((Object)("Kimura80 Nucleotide substitution rate matrix; ts=" + this.ts + "  tv=" + this.tv));
    }
}

