/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.tricycle13;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.CacheStrategySpec;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerEdge;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.features.supporting.MarkovPredictorLogprob;
import calhoun.analysis.crf.features.tricycle13.EmissionMarkovFeature;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.seq.KmerHasher;
import calhoun.util.Assert;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CodingStopFeature
extends AbstractFeatureManager<Character>
implements FeatureManagerEdge<Character> {
    private static final long serialVersionUID = -7659288739348604129L;
    private static final Log log = LogFactory.getLog(CodingStopFeature.class);
    boolean debug = log.isDebugEnabled();
    int startIx;
    ModelManager model;
    KmerHasher h;
    float[][] pluslogprob;
    float[][] minuslogprob;
    int[][] pc;
    int[][] mc;
    int stateIntergenic;
    int stateExon3;
    int stateExon3m;
    MarkovPredictorLogprob predictorlp;

    public CodingStopFeature() {
    }

    public void setHistory(EmissionMarkovFeature.MarkovHistory markovHistory) {
        this.predictorlp = new MarkovPredictorLogprob(markovHistory.convert());
    }

    public CodingStopFeature(List<int[]> markovhistory) {
        this.predictorlp = new MarkovPredictorLogprob(markovhistory);
    }

    @Override
    public int getNumFeatures() {
        return 1;
    }

    @Override
    public String getFeatureName(int featureIndex) {
        Assert.a(featureIndex == this.startIx);
        return "CodingStopFeature";
    }

    @Override
    public void evaluateEdge(InputSequence<? extends Character> seq, int ix, int prevState, int state, FeatureList result) {
        int len = seq.length();
        if (prevState == this.stateExon3 && state == this.stateIntergenic) {
            float pval = 0.0f;
            if (ix >= 3 && ix < len - 5) {
                int i;
                char a = seq.getX(ix - 3).charValue();
                char b = seq.getX(ix - 2).charValue();
                char c = seq.getX(ix - 1).charValue();
                pval = a == 'T' && b == 'A' && c == 'G' ? (float)Math.log(0.33333333) : (a == 'T' && b == 'G' && c == 'A' ? (float)Math.log(0.33333333) : (a == 'T' && b == 'A' && c == 'A' ? (float)Math.log(0.33333333) : -50.0f));
                for (i = 0; i < 6; ++i) {
                    char d = seq.getX(ix + i).charValue();
                    pval += this.pluslogprob[i][this.h.hash(d)];
                }
                for (i = 0; i < 9; ++i) {
                    pval -= this.predictorlp.logprob(this.pc[i][1], seq, ix - this.pc[i][0]);
                }
            }
            result.addFeature(this.startIx, pval);
        } else if (state == this.stateExon3m && prevState == this.stateIntergenic) {
            float mval = 0.0f;
            if (ix >= 6 && ix < len - 2) {
                int i;
                char a = seq.getX(ix + 0).charValue();
                char b = seq.getX(ix + 1).charValue();
                char c = seq.getX(ix + 2).charValue();
                mval = a == 'T' && b == 'T' && c == 'A' ? (float)Math.log(0.33333333) : (a == 'C' && b == 'T' && c == 'A' ? (float)Math.log(0.33333333) : (a == 'T' && b == 'C' && c == 'A' ? (float)Math.log(0.33333333) : -50.0f));
                for (i = 0; i < 6; ++i) {
                    char d = seq.getX(ix + i - 6).charValue();
                    mval += this.minuslogprob[i][this.h.hash(d)];
                }
                for (i = 0; i < 9; ++i) {
                    mval -= this.predictorlp.logprob(this.mc[i][1], seq, ix - this.mc[i][0]);
                }
            }
            result.addFeature(this.startIx, mval);
        }
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List<? extends TrainingSequence<? extends Character>> data) {
        int j;
        int k;
        this.startIx = startingIndex;
        this.model = modelInfo;
        this.stateIntergenic = this.model.getStateIndex("intergenic");
        this.stateExon3 = this.model.getStateIndex("exon3");
        this.stateExon3m = this.model.getStateIndex("exon3m");
        this.predictorlp.train(data);
        this.h = new KmerHasher(KmerHasher.ACGTN, 1);
        this.pc = new int[9][2];
        this.pc[0][0] = -3;
        this.pc[1][0] = -2;
        this.pc[1][1] = this.model.getStateIndex("exon2");
        this.pc[2][0] = -1;
        this.pc[2][1] = this.model.getStateIndex("exon3");
        this.pc[3][0] = 0;
        this.pc[3][1] = this.model.getStateIndex("intergenic");
        this.pc[4][0] = 1;
        this.pc[4][1] = this.model.getStateIndex("intergenic");
        this.pc[5][0] = 2;
        this.pc[5][1] = this.model.getStateIndex("intergenic");
        this.pc[6][0] = 3;
        this.pc[6][1] = this.model.getStateIndex("intergenic");
        this.pc[7][0] = 4;
        this.pc[7][1] = this.model.getStateIndex("intergenic");
        this.pc[8][0] = 5;
        this.pc[8][1] = this.model.getStateIndex("intergenic");
        this.mc = new int[9][2];
        this.mc[0][0] = -6;
        this.mc[0][1] = this.model.getStateIndex("intergenic");
        this.mc[1][0] = -5;
        this.mc[1][1] = this.model.getStateIndex("intergenic");
        this.mc[2][0] = -4;
        this.mc[2][1] = this.model.getStateIndex("intergenic");
        this.mc[3][0] = -3;
        this.mc[3][1] = this.model.getStateIndex("intergenic");
        this.mc[4][0] = -2;
        this.mc[4][1] = this.model.getStateIndex("intergenic");
        this.mc[5][0] = -1;
        this.mc[5][1] = this.model.getStateIndex("intergenic");
        this.mc[6][0] = 0;
        this.mc[6][1] = this.model.getStateIndex("exon3m");
        this.mc[7][0] = 1;
        this.mc[7][1] = this.model.getStateIndex("exon2m");
        this.mc[8][0] = 2;
        this.mc[8][1] = this.model.getStateIndex("exon1m");
        this.pluslogprob = new float[6][this.h.range()];
        this.minuslogprob = new float[6][this.h.range()];
        for (int i = 0; i < 6; ++i) {
            for (int i2 = 0; i2 < this.h.range(); ++i2) {
                this.pluslogprob[i][i2] = 1.0f;
                this.minuslogprob[i][i2] = 1.0f;
            }
        }
        for (TrainingSequence<? extends Character> trainingSequence : data) {
            char c;
            int y;
            int yprev;
            int ix;
            int len = trainingSequence.length();
            for (ix = 3; ix < len - 5; ++ix) {
                yprev = trainingSequence.getY(ix - 1);
                y = trainingSequence.getY(ix);
                if (yprev != this.model.getStateIndex("exon3") || y != this.model.getStateIndex("intergenic")) continue;
                for (int k2 = 0; k2 < 6; ++k2) {
                    c = trainingSequence.getX(ix + k2).charValue();
                    float[] fArray = this.pluslogprob[k2];
                    int n = this.h.hash(c);
                    fArray[n] = (float)((double)fArray[n] + 1.0);
                }
            }
            for (ix = 6; ix < len - 3; ++ix) {
                yprev = trainingSequence.getY(ix - 1);
                y = trainingSequence.getY(ix);
                if (yprev != this.model.getStateIndex("intergenic") || y != this.model.getStateIndex("exon3m")) continue;
                for (int k2 = 0; k2 < 6; ++k2) {
                    c = trainingSequence.getX(ix + k2 - 6).charValue();
                    float[] fArray = this.minuslogprob[k2];
                    int n = this.h.hash(c);
                    fArray[n] = (float)((double)fArray[n] + 1.0);
                }
            }
        }
        for (k = 0; k < 6; ++k) {
            float f = 0.0f;
            for (j = 0; j < this.h.range(); ++j) {
                f += this.pluslogprob[k][j];
            }
            Assert.a(f > 0.0f);
            for (j = 0; j < this.h.range(); ++j) {
                this.pluslogprob[k][j] = (float)(Math.log(this.pluslogprob[k][j]) - Math.log(f));
            }
        }
        for (k = 0; k < 6; ++k) {
            float f = 0.0f;
            for (j = 0; j < this.h.range(); ++j) {
                f += this.minuslogprob[k][j];
            }
            Assert.a(f > 0.0f);
            for (j = 0; j < this.h.range(); ++j) {
                this.minuslogprob[k][j] = (float)(Math.log(this.minuslogprob[k][j]) - Math.log(f));
            }
        }
    }

    @Override
    public CacheStrategySpec getCacheStrategy() {
        return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.UNSPECIFIED);
    }
}

