/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.tricycle13;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.CacheStrategySpec;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerNode;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.CompositeInput;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ESTIntron
extends AbstractFeatureManager<CompositeInput>
implements FeatureManagerNode<CompositeInput> {
    private static final long serialVersionUID = -7659288739348604129L;
    private static final Log log = LogFactory.getLog(ESTIntron.class);
    boolean debug = log.isDebugEnabled();
    int startIx;
    ModelManager model;
    boolean[] plusIntronState;
    boolean[] minusIntronState;

    @Override
    public int getNumFeatures() {
        return 1;
    }

    @Override
    public String getFeatureName(int featureIndex) {
        return "ESTIntron";
    }

    @Override
    public void evaluateNode(InputSequence<? extends CompositeInput> seq, int pos, int state, FeatureList result) {
        boolean minusEstIntron;
        if (pos == seq.length() - 1) {
            return;
        }
        InputSequence<?> pest = seq.getComponent("pest");
        InputSequence<?> mest = seq.getComponent("mest");
        boolean plusEstIntron = (Integer)pest.getX(pos + 1) == 2;
        boolean bl = minusEstIntron = (Integer)mest.getX(pos + 1) == 2;
        if (this.plusIntronState[state] && plusEstIntron) {
            result.addFeature(this.startIx, 1.0);
        }
        if (this.minusIntronState[state] && minusEstIntron) {
            result.addFeature(this.startIx, 1.0);
        }
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List<? extends TrainingSequence<? extends CompositeInput>> data) {
        int j;
        this.startIx = startingIndex;
        this.model = modelInfo;
        int nStates = this.model.getNumStates();
        this.plusIntronState = new boolean[nStates];
        for (j = 0; j < nStates; ++j) {
            this.plusIntronState[j] = false;
        }
        this.plusIntronState[this.model.getStateIndex((String)"intron1")] = true;
        this.plusIntronState[this.model.getStateIndex((String)"intron2")] = true;
        this.plusIntronState[this.model.getStateIndex((String)"intron3")] = true;
        this.minusIntronState = new boolean[nStates];
        for (j = 0; j < nStates; ++j) {
            this.minusIntronState[j] = false;
        }
        this.minusIntronState[this.model.getStateIndex((String)"intron1m")] = true;
        this.minusIntronState[this.model.getStateIndex((String)"intron2m")] = true;
        this.minusIntronState[this.model.getStateIndex((String)"intron3m")] = true;
    }

    @Override
    public CacheStrategySpec getCacheStrategy() {
        return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.UNSPECIFIED);
    }
}

