/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.tricycle13;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.BeanModel;
import calhoun.analysis.crf.CacheStrategySpec;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerNode;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.features.supporting.MarkovPredictorLogprob;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EmissionMarkovFeature
extends AbstractFeatureManager<Character>
implements FeatureManagerNode<Character> {
    private static final long serialVersionUID = -7659288739348604129L;
    private static final Log log = LogFactory.getLog(EmissionMarkovFeature.class);
    boolean debug = log.isDebugEnabled();
    int startIx;
    ModelManager model;
    MarkovPredictorLogprob predictorlp;
    boolean tieFlag = false;

    public EmissionMarkovFeature() {
    }

    public void setHistory(MarkovHistory markovHistory) {
        this.predictorlp = new MarkovPredictorLogprob(markovHistory.convert());
    }

    public EmissionMarkovFeature(List<int[]> history) {
        this.predictorlp = new MarkovPredictorLogprob(history);
    }

    public EmissionMarkovFeature(List<int[]> history, List<int[]> flags) {
        this.predictorlp = new MarkovPredictorLogprob(history);
        this.tieFlag = true;
    }

    @Override
    public int getNumFeatures() {
        return this.tieFlag ? 1 : this.model.getNumStates();
    }

    @Override
    public String getFeatureName(int featureIndex) {
        if (this.tieFlag) {
            return "TiedEmissionMarkovFeature";
        }
        int raw = featureIndex - this.startIx;
        return "EmissionMarkov.span" + this.model.getStateName(raw);
    }

    @Override
    public void evaluateNode(InputSequence<? extends Character> seq, int pos, int state, FeatureList result) {
        int index = this.startIx + (this.tieFlag ? 0 : state);
        result.addFeature(index, this.predictorlp.logprob(state, seq, pos));
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List<? extends TrainingSequence<? extends Character>> data) {
        this.startIx = startingIndex;
        this.model = modelInfo;
        this.predictorlp.train(data);
    }

    @Override
    public CacheStrategySpec getCacheStrategy() {
        return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.DENSE);
    }

    public static class MarkovHistory
    implements Serializable {
        private static final long serialVersionUID = 8731309130784681776L;
        List<List<BeanModel.Node>> states;

        public List<List<BeanModel.Node>> getStates() {
            return this.states;
        }

        public void setStates(List<List<BeanModel.Node>> history) {
            this.states = history;
        }

        public List<int[]> convert() {
            ArrayList<int[]> historyArray = new ArrayList<int[]>();
            for (List<BeanModel.Node> nodeList : this.states) {
                int[] historyEntry = new int[nodeList.size()];
                historyArray.add(historyEntry);
                for (int i = 0; i < historyEntry.length; ++i) {
                    historyEntry[i] = nodeList.get(i).getIndex();
                }
            }
            return historyArray;
        }
    }
}

