/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.tricycle13;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.CacheStrategySpec;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerNode;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.MultipleAlignmentInputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.seq.KmerHasher;
import calhoun.util.Assert;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GapConjunctionFeatures
extends AbstractFeatureManager<MultipleAlignmentInputSequence.MultipleAlignmentColumn>
implements FeatureManagerNode<MultipleAlignmentInputSequence.MultipleAlignmentColumn> {
    private static final long serialVersionUID = -7659288739348604129L;
    private static final Log log = LogFactory.getLog(GapConjunctionFeatures.class);
    boolean debug = log.isDebugEnabled();
    int startIx;
    ModelManager model;
    KmerHasher h = new KmerHasher(KmerHasher.ACGTN, 1);
    int maxSeqLength;
    int nFeatures = 6;
    int nStates;
    Boolean[] gapboundary;
    Boolean[] frameshifter;
    Boolean[] isStateCoding;
    Boolean[] isStateIntronic;
    Boolean[] isStateIntergenic;
    int lastSeqLength = -1;
    int lastpos = -1;
    InputSequence<? extends MultipleAlignmentInputSequence.MultipleAlignmentColumn> lastSeq = null;

    @Override
    public int getNumFeatures() {
        return this.nFeatures;
    }

    @Override
    public String getFeatureName(int featureIndex) {
        int raw = featureIndex - this.startIx;
        Assert.a(raw < this.nFeatures);
        String ret = "GapConjunctionFeature." + raw;
        return ret;
    }

    @Override
    public void evaluateNode(InputSequence<? extends MultipleAlignmentInputSequence.MultipleAlignmentColumn> seq, int pos, int state, FeatureList result) {
        if (seq != this.lastSeq) {
            log.debug(seq);
            log.debug(this.lastSeq);
            log.debug((Object)("Performing precomputations for seq of length " + seq.length() + " at position " + pos));
            this.performPrecomputations(seq.getX(0).getMultipleAlignment());
            this.lastSeqLength = seq.length();
            this.lastpos = pos;
            this.lastSeq = seq;
        }
        if (this.isStateCoding[state].booleanValue() && this.frameshifter[pos].booleanValue()) {
            result.addFeature(this.startIx + 0, 1.0);
        }
        if (this.isStateIntronic[state].booleanValue() && this.frameshifter[pos].booleanValue()) {
            result.addFeature(this.startIx + 1, 1.0);
        }
        if (this.isStateIntergenic[state].booleanValue() && this.frameshifter[pos].booleanValue()) {
            result.addFeature(this.startIx + 2, 1.0);
        }
        if (this.isStateCoding[state].booleanValue() && this.gapboundary[pos].booleanValue()) {
            result.addFeature(this.startIx + 3, 1.0);
        }
        if (this.isStateIntronic[state].booleanValue() && this.gapboundary[pos].booleanValue()) {
            result.addFeature(this.startIx + 4, 1.0);
        }
        if (this.isStateIntergenic[state].booleanValue() && this.gapboundary[pos].booleanValue()) {
            result.addFeature(this.startIx + 5, 1.0);
        }
    }

    private void performPrecomputations(MultipleAlignmentInputSequence seq) {
        if (seq.length() > this.frameshifter.length) {
            this.frameshifter = new Boolean[seq.length()];
            this.gapboundary = new Boolean[seq.length()];
        }
        for (int j = 0; j < seq.length(); ++j) {
            this.frameshifter[j] = false;
            this.gapboundary[j] = false;
        }
        int numSpecies = seq.numSpecies();
        int consensusLength = seq.getConsensusLength();
        for (int spec = 0; spec < numSpecies; ++spec) {
            boolean inGap = false;
            int conGapStart = -1;
            for (int cpos = 1; cpos < consensusLength; ++cpos) {
                if (!inGap && this.h.hashable(seq.characterInPaddedAlignment(cpos - 1, spec)) && !this.h.hashable(seq.characterInPaddedAlignment(cpos, spec))) {
                    inGap = true;
                    conGapStart = cpos;
                }
                if (!inGap || this.h.hashable(seq.characterInPaddedAlignment(cpos - 1, spec)) || !this.h.hashable(seq.characterInPaddedAlignment(cpos, spec))) continue;
                inGap = false;
                int conGapEnd = cpos - 1;
                int gaplen = conGapEnd - conGapStart + 1;
                if (gaplen > 60) continue;
                if (gaplen % 3 == 0) {
                    this.gapboundary[seq.con2refLeft((int)conGapStart)] = true;
                    this.gapboundary[seq.con2refRight((int)conGapEnd)] = true;
                    continue;
                }
                this.frameshifter[seq.con2refLeft((int)conGapStart)] = true;
                this.frameshifter[seq.con2refRight((int)conGapEnd)] = true;
            }
        }
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List<? extends TrainingSequence<? extends MultipleAlignmentInputSequence.MultipleAlignmentColumn>> data) {
        int j;
        this.startIx = startingIndex;
        this.model = modelInfo;
        this.nStates = this.model.getNumStates();
        this.maxSeqLength = 0;
        for (TrainingSequence<? extends MultipleAlignmentInputSequence.MultipleAlignmentColumn> trainingSequence : data) {
            int len = trainingSequence.length();
            if (len <= this.maxSeqLength) continue;
            this.maxSeqLength = len;
        }
        this.frameshifter = new Boolean[this.maxSeqLength];
        this.gapboundary = new Boolean[this.maxSeqLength];
        this.isStateCoding = new Boolean[this.nStates];
        for (j = 0; j < this.nStates; ++j) {
            this.isStateCoding[j] = false;
        }
        this.isStateCoding[this.model.getStateIndex((String)"exon1")] = true;
        this.isStateCoding[this.model.getStateIndex((String)"exon2")] = true;
        this.isStateCoding[this.model.getStateIndex((String)"exon3")] = true;
        this.isStateCoding[this.model.getStateIndex((String)"exon1m")] = true;
        this.isStateCoding[this.model.getStateIndex((String)"exon2m")] = true;
        this.isStateCoding[this.model.getStateIndex((String)"exon3m")] = true;
        this.isStateIntronic = new Boolean[this.nStates];
        for (j = 0; j < this.nStates; ++j) {
            this.isStateIntronic[j] = false;
        }
        this.isStateIntronic[this.model.getStateIndex((String)"intron1")] = true;
        this.isStateIntronic[this.model.getStateIndex((String)"intron2")] = true;
        this.isStateIntronic[this.model.getStateIndex((String)"intron3")] = true;
        this.isStateIntronic[this.model.getStateIndex((String)"intron1m")] = true;
        this.isStateIntronic[this.model.getStateIndex((String)"intron2m")] = true;
        this.isStateIntronic[this.model.getStateIndex((String)"intron3m")] = true;
        this.isStateIntergenic = new Boolean[this.nStates];
        for (j = 0; j < this.nStates; ++j) {
            this.isStateIntergenic[j] = false;
        }
        this.isStateIntergenic[this.model.getStateIndex((String)"intergenic")] = true;
    }

    @Override
    public CacheStrategySpec getCacheStrategy() {
        return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.UNSPECIFIED);
    }
}

