/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.tricycle13;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerEdge;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import java.util.List;

public class GeneConstraints
extends AbstractFeatureManager<Character>
implements FeatureManagerEdge<Character> {
    private static final long serialVersionUID = -3045999729941973608L;
    Constraint[] constraints;
    int numStates;

    @Override
    public String getFeatureName(int featureIndex) {
        return "Gene constraints";
    }

    @Override
    public int getNumFeatures() {
        return 0;
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List<? extends TrainingSequence<? extends Character>> data) {
        this.numStates = modelInfo.getNumStates();
        this.constraints = new Constraint[this.numStates * this.numStates];
        for (int i = 0; i < this.numStates; ++i) {
            for (int j = 0; j < this.numStates; ++j) {
                String lastState = modelInfo.getStateName(i);
                String currentState = modelInfo.getStateName(j);
                Constraint c = Constraint.NONE;
                if (lastState.startsWith("intergenic") && currentState.startsWith("exon")) {
                    c = currentState.endsWith("m") ? Constraint.STOP_MINUS : Constraint.START;
                } else if (lastState.startsWith("exon") && currentState.startsWith("intron")) {
                    c = currentState.endsWith("m") ? Constraint.ACCEPTOR_MINUS : Constraint.DONOR;
                } else if (lastState.startsWith("intron") && currentState.startsWith("exon")) {
                    c = currentState.endsWith("m") ? Constraint.DONOR_MINUS : Constraint.ACCEPTOR;
                } else if (lastState.startsWith("exon") && currentState.startsWith("intergenic")) {
                    c = lastState.endsWith("m") ? Constraint.START_MINUS : Constraint.STOP;
                } else if (lastState.equals("exon3") && currentState.equals("exon1")) {
                    c = Constraint.CODING;
                } else if (lastState.equals("exon1m") && currentState.equals("exon3m")) {
                    c = Constraint.CODING_MINUS;
                }
                this.constraints[i * this.numStates + j] = c;
            }
        }
    }

    @Override
    public void evaluateEdge(InputSequence<? extends Character> seq, int pos, int prevState, int state, FeatureList result) {
        boolean valid = true;
        switch (this.constraints[prevState * this.numStates + state]) {
            case START: {
                valid = this.startConstraintPlus(seq, pos);
                break;
            }
            case DONOR: {
                valid = this.donorConstraintPlus(seq, pos);
                break;
            }
            case ACCEPTOR: {
                valid = this.acceptorConstraintPlus(seq, pos);
                break;
            }
            case STOP: {
                valid = this.stopConstraintPlus(seq, pos);
                break;
            }
            case START_MINUS: {
                valid = this.startConstraintMinus(seq, pos);
                break;
            }
            case DONOR_MINUS: {
                valid = this.donorConstraintMinus(seq, pos);
                break;
            }
            case ACCEPTOR_MINUS: {
                valid = this.acceptorConstraintMinus(seq, pos);
                break;
            }
            case STOP_MINUS: {
                valid = this.stopConstraintMinus(seq, pos);
                break;
            }
            case CODING: {
                valid = !this.stopConstraintPlus(seq, pos);
                break;
            }
            case CODING_MINUS: {
                boolean bl = valid = !this.stopConstraintMinus(seq, pos);
            }
        }
        if (!valid) {
            result.invalidate();
        }
    }

    boolean startConstraintPlus(InputSequence<? extends Character> seq, int pos) {
        return seq.length() > pos + 2 && seq.getX(pos).charValue() == 'A' && seq.getX(pos + 1).charValue() == 'T' && seq.getX(pos + 2).charValue() == 'G';
    }

    boolean startConstraintMinus(InputSequence<? extends Character> seq, int pos) {
        return pos >= 3 && seq.getX(pos - 3).charValue() == 'C' && seq.getX(pos - 2).charValue() == 'A' && seq.getX(pos - 1).charValue() == 'T';
    }

    boolean donorConstraintPlus(InputSequence<? extends Character> seq, int pos) {
        return seq.length() > pos + 1 && seq.getX(pos).charValue() == 'G' && (seq.getX(pos + 1).charValue() == 'T' || seq.getX(pos + 1).charValue() == 'C');
    }

    boolean donorConstraintMinus(InputSequence<? extends Character> seq, int pos) {
        return pos >= 2 && (seq.getX(pos - 2).charValue() == 'A' || seq.getX(pos - 2).charValue() == 'G') && seq.getX(pos - 1).charValue() == 'C';
    }

    boolean acceptorConstraintPlus(InputSequence<? extends Character> seq, int pos) {
        return pos > 1 && seq.getX(pos - 2).charValue() == 'A' && seq.getX(pos - 1).charValue() == 'G';
    }

    boolean acceptorConstraintMinus(InputSequence<? extends Character> seq, int pos) {
        return seq.length() > pos + 1 && seq.getX(pos).charValue() == 'C' && seq.getX(pos + 1).charValue() == 'T';
    }

    boolean stopConstraintPlus(InputSequence<? extends Character> seq, int pos) {
        if (seq.length() > pos + 2 && seq.getX(pos).charValue() == 'T') {
            return seq.getX(pos + 1).charValue() == 'A' && (seq.getX(pos + 2).charValue() == 'G' || seq.getX(pos + 2).charValue() == 'A') || seq.getX(pos + 1).charValue() == 'G' && seq.getX(pos + 2).charValue() == 'A';
        }
        return false;
    }

    boolean stopConstraintMinus(InputSequence<? extends Character> seq, int pos) {
        if (pos >= 3 && seq.getX(pos - 1).charValue() == 'A') {
            return seq.getX(pos - 2).charValue() == 'T' && (seq.getX(pos - 3).charValue() == 'C' || seq.getX(pos - 3).charValue() == 'T') || seq.getX(pos - 2).charValue() == 'C' && seq.getX(pos - 3).charValue() == 'T';
        }
        return false;
    }

    static enum Constraint {
        NONE,
        START,
        DONOR,
        ACCEPTOR,
        STOP,
        START_MINUS,
        DONOR_MINUS,
        ACCEPTOR_MINUS,
        STOP_MINUS,
        CODING,
        CODING_MINUS;

    }
}

