/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.tricycle13;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerNode;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.IntervalInputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IntervalPresenceFeatures
extends AbstractFeatureManager<IntervalInputSequence.IntervalPosition>
implements FeatureManagerNode<IntervalInputSequence.IntervalPosition> {
    private static final long serialVersionUID = -7659288739348604129L;
    private static final Log log = LogFactory.getLog(IntervalPresenceFeatures.class);
    boolean debug = log.isDebugEnabled();
    int startIx;
    ModelManager model;
    boolean[] plusExonState;
    boolean[] minusExonState;
    boolean[] plusIntronState;
    boolean[] minusIntronState;

    @Override
    public int getNumFeatures() {
        return 2;
    }

    @Override
    public String getFeatureName(int featureIndex) {
        return "IntervalPresenceFeatures";
    }

    @Override
    public void evaluateNode(InputSequence<? extends IntervalInputSequence.IntervalPosition> seq, int pos, int state, FeatureList result) {
        if (pos == seq.length() - 1) {
            return;
        }
        boolean plusInt = seq.getX(pos).queryPlus();
        boolean minusInt = seq.getX(pos).queryMinus();
        if (this.plusExonState[state] && plusInt) {
            result.addFeature(this.startIx, 1.0);
        }
        if (this.minusExonState[state] && minusInt) {
            result.addFeature(this.startIx, 1.0);
        }
        if (this.plusIntronState[state] && plusInt) {
            result.addFeature(this.startIx + 1, 1.0);
        }
        if (this.minusIntronState[state] && minusInt) {
            result.addFeature(this.startIx + 1, 1.0);
        }
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List<? extends TrainingSequence<? extends IntervalInputSequence.IntervalPosition>> data) {
        int j;
        this.startIx = startingIndex;
        this.model = modelInfo;
        int nStates = this.model.getNumStates();
        this.plusExonState = new boolean[nStates];
        for (j = 0; j < nStates; ++j) {
            this.plusExonState[j] = false;
        }
        this.plusExonState[this.model.getStateIndex((String)"exon1")] = true;
        this.plusExonState[this.model.getStateIndex((String)"exon2")] = true;
        this.plusExonState[this.model.getStateIndex((String)"exon3")] = true;
        this.minusExonState = new boolean[nStates];
        for (j = 0; j < nStates; ++j) {
            this.minusExonState[j] = false;
        }
        this.minusExonState[this.model.getStateIndex((String)"exon1m")] = true;
        this.minusExonState[this.model.getStateIndex((String)"exon2m")] = true;
        this.minusExonState[this.model.getStateIndex((String)"exon3m")] = true;
        this.plusIntronState = new boolean[nStates];
        for (j = 0; j < nStates; ++j) {
            this.plusIntronState[j] = false;
        }
        this.plusIntronState[this.model.getStateIndex((String)"intron1")] = true;
        this.plusIntronState[this.model.getStateIndex((String)"intron2")] = true;
        this.plusIntronState[this.model.getStateIndex((String)"intron3")] = true;
        this.minusIntronState = new boolean[nStates];
        for (j = 0; j < nStates; ++j) {
            this.minusIntronState[j] = false;
        }
        this.minusIntronState[this.model.getStateIndex((String)"intron1m")] = true;
        this.minusIntronState[this.model.getStateIndex((String)"intron2m")] = true;
        this.minusIntronState[this.model.getStateIndex((String)"intron3m")] = true;
    }
}

