/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.tricycle13;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerNodeExplicitLength;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.analysis.crf.statistics.GammaDistribution;
import calhoun.util.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IntronLengthFeature
extends AbstractFeatureManager
implements FeatureManagerNodeExplicitLength {
    private static final long serialVersionUID = 8477631359065280630L;
    private static final Log log = LogFactory.getLog(IntronLengthFeature.class);
    boolean debug = log.isDebugEnabled();
    int startIx;
    double[] logProbExtend;
    boolean[] explicitLengthFlag;
    private boolean[] isIntron;

    @Override
    public String getFeatureName(int featureIndex) {
        Assert.a(featureIndex == this.startIx, "Invalid feature index");
        return "IntronLengthFeature";
    }

    @Override
    public int getNumFeatures() {
        return 1;
    }

    public void evaluateNodeLength(InputSequence seq, int pos, int length, int state, FeatureList result) {
        if (this.explicitLengthFlag[state]) {
            double pdist1 = 0.86;
            double shape1 = 71.0;
            double lambda1 = 1.27;
            double shape2 = 4.1;
            double lambda2 = 0.041;
            double val = pdist1 * GammaDistribution.gamma(shape1, lambda1, length);
            val += (1.0 - pdist1) * GammaDistribution.gamma(shape2, lambda2, length);
            val = Math.log(val);
            result.addFeature(this.startIx, val -= (double)(length - 1) * this.logProbExtend[state]);
        }
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List data) {
        int j;
        log.debug((Object)"Training the Feature for IntronLengths, explicitly modelled as a Gaussian");
        this.startIx = startingIndex;
        int nStates = modelInfo.getNumStates();
        this.explicitLengthFlag = new boolean[nStates];
        Arrays.fill(this.explicitLengthFlag, false);
        this.explicitLengthFlag[modelInfo.getStateIndex((String)"intron1")] = true;
        this.explicitLengthFlag[modelInfo.getStateIndex((String)"intron2")] = true;
        this.explicitLengthFlag[modelInfo.getStateIndex((String)"intron3")] = true;
        this.explicitLengthFlag[modelInfo.getStateIndex((String)"intron1m")] = true;
        this.explicitLengthFlag[modelInfo.getStateIndex((String)"intron2m")] = true;
        this.explicitLengthFlag[modelInfo.getStateIndex((String)"intron3m")] = true;
        this.isIntron = (boolean[])this.explicitLengthFlag.clone();
        float[][] transitions = new float[nStates][nStates];
        for (int j2 = 0; j2 < nStates; ++j2) {
            for (int k = 0; k < nStates; ++k) {
                transitions[j2][k] = 1.0f;
            }
        }
        for (TrainingSequence seq : data) {
            for (int pos = 1; pos < seq.length(); ++pos) {
                int start = seq.getY(pos - 1);
                int end = seq.getY(pos);
                float[] fArray = transitions[start];
                int n = end;
                fArray[n] = fArray[n] + 1.0f;
            }
        }
        this.logProbExtend = new double[nStates];
        for (j = 0; j < nStates; ++j) {
            float rowtotal = 0.0f;
            for (int k = 0; k < nStates; ++k) {
                rowtotal += transitions[j][k];
            }
            this.logProbExtend[j] = (float)Math.log(transitions[j][j] / rowtotal);
        }
        log.debug((Object)"logprobextend for the variuos states are:");
        for (j = 0; j < modelInfo.getNumStates(); ++j) {
            log.debug((Object)("  " + modelInfo.getStateName(j) + "   " + this.logProbExtend[j]));
        }
        ArrayList<Integer> intronLengths = new ArrayList<Integer>();
        for (TrainingSequence seq : data) {
            int lastIntronStart = -1;
            int y = seq.getY(0);
            for (int pos = 1; pos < seq.length(); ++pos) {
                int yprev = y;
                y = seq.getY(pos);
                if (this.isIntron[yprev] && !this.isIntron[y] && lastIntronStart >= -1) {
                    intronLengths.add(pos - lastIntronStart);
                    lastIntronStart = -1;
                }
                if (this.isIntron[yprev] || !this.isIntron[y]) continue;
                lastIntronStart = pos;
            }
        }
        log.debug((Object)"The intron lengths are:");
        for (int j3 = 0; j3 < intronLengths.size(); ++j3) {
            log.debug((Object)(intronLengths.get(j3) + ","));
        }
    }
}

