/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.tricycle13;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.CacheStrategySpec;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerNode;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.CompositeInput;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PfamGenic
extends AbstractFeatureManager<CompositeInput>
implements FeatureManagerNode<CompositeInput> {
    private static final long serialVersionUID = -7659288739348604129L;
    private static final Log log = LogFactory.getLog(PfamGenic.class);
    boolean debug = log.isDebugEnabled();
    int startIx;
    ModelManager model;
    boolean[] plusGenic;
    boolean[] minusGenic;

    @Override
    public int getNumFeatures() {
        return 1;
    }

    @Override
    public String getFeatureName(int featureIndex) {
        return "PfamGenic";
    }

    @Override
    public void evaluateNode(InputSequence<? extends CompositeInput> seq, int pos, int state, FeatureList result) {
        boolean minusPfam;
        if (pos == seq.length() - 1) {
            return;
        }
        InputSequence<?> ppfam = seq.getComponent("ppfam");
        InputSequence<?> mpfam = seq.getComponent("mpfam");
        boolean plusPfam = (Integer)ppfam.getX(pos) > 0;
        boolean bl = minusPfam = (Integer)mpfam.getX(pos) > 0;
        if (this.plusGenic[state] && plusPfam) {
            result.addFeature(this.startIx, 1.0);
        }
        if (this.minusGenic[state] && minusPfam) {
            result.addFeature(this.startIx, 1.0);
        }
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List<? extends TrainingSequence<? extends CompositeInput>> data) {
        int j;
        this.startIx = startingIndex;
        this.model = modelInfo;
        int nStates = this.model.getNumStates();
        this.plusGenic = new boolean[nStates];
        for (j = 0; j < nStates; ++j) {
            this.plusGenic[j] = false;
        }
        this.plusGenic[this.model.getStateIndex((String)"exon1")] = true;
        this.plusGenic[this.model.getStateIndex((String)"exon2")] = true;
        this.plusGenic[this.model.getStateIndex((String)"exon3")] = true;
        this.plusGenic[this.model.getStateIndex((String)"intron1")] = true;
        this.plusGenic[this.model.getStateIndex((String)"intron2")] = true;
        this.plusGenic[this.model.getStateIndex((String)"intron3")] = true;
        this.minusGenic = new boolean[nStates];
        for (j = 0; j < nStates; ++j) {
            this.minusGenic[j] = false;
        }
        this.minusGenic[this.model.getStateIndex((String)"exon1m")] = true;
        this.minusGenic[this.model.getStateIndex((String)"exon2m")] = true;
        this.minusGenic[this.model.getStateIndex((String)"exon3m")] = true;
        this.minusGenic[this.model.getStateIndex((String)"intron1m")] = true;
        this.minusGenic[this.model.getStateIndex((String)"intron2m")] = true;
        this.minusGenic[this.model.getStateIndex((String)"intron3m")] = true;
    }

    @Override
    public CacheStrategySpec getCacheStrategy() {
        return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.UNSPECIFIED);
    }
}

