/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.io;

import calhoun.analysis.crf.features.supporting.phylogenetic.RootedBinaryPhylogeneticTree;
import calhoun.analysis.crf.io.InputComponentIO;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.MultipleAlignmentInputSequence;
import calhoun.util.Assert;
import calhoun.util.FileUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AlignmentTree
implements InputComponentIO {
    private static final long serialVersionUID = 760405914814389112L;
    String component;

    @Override
    public List<String> getComponentNames() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(this.component);
        return ret;
    }

    @Override
    public void readInputSequences(String location, List<Map<String, InputSequence<?>>> inputs) throws IOException {
        Assert.a(inputs.size() > 0, "AlignmentTree can't be the first input.");
        String[] contents = FileUtil.readFile(location).split("\n");
        RootedBinaryPhylogeneticTree tree = new RootedBinaryPhylogeneticTree(contents[0]);
        for (Map<String, InputSequence<?>> input : inputs) {
            input.put(this.component, new MultipleAlignmentInputSequence(contents[1].trim(), tree));
        }
    }

    @Override
    public void writeInputSequences(String location, List<? extends Map<String, ? extends InputSequence<?>>> inputComponents) throws IOException {
        MultipleAlignmentInputSequence alignment = (MultipleAlignmentInputSequence)inputComponents.get(0).get(this.component);
        String tree = alignment.getTree().newick();
        FileUtil.writeFile(location, tree);
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String header) {
        this.component = header;
    }
}

