/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.io;

import calhoun.analysis.crf.io.InputComponentIO;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.InputSequenceCharacter;
import calhoun.analysis.crf.io.NameInputSequence;
import calhoun.seq.FastaIterator;
import calhoun.seq.FastaSequence;
import calhoun.seq.FastaWriter;
import calhoun.util.Assert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FastaInput
implements InputComponentIO {
    private static final long serialVersionUID = 760405914814389112L;
    String header;
    String sequence;
    Integer numSeqCap = Integer.MAX_VALUE;

    @Override
    public List<String> getComponentNames() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(this.header);
        ret.add(this.sequence);
        return ret;
    }

    @Override
    public void readInputSequences(String location, List<Map<String, InputSequence<?>>> inputs) throws IOException {
        FastaIterator it = new FastaIterator(location);
        Assert.a(inputs.size() == 0, "Fasta input always has to go first in the list.");
        int i = 0;
        if (this.numSeqCap == null) {
            this.numSeqCap = Integer.MAX_VALUE;
        }
        while (it.hasNext() && i < this.numSeqCap) {
            FastaSequence seq = it.next();
            HashMap<String, InputSequence<String>> input = new HashMap<String, InputSequence<String>>();
            input.put(this.header, new NameInputSequence(seq.getHeader()));
            input.put(this.sequence, new InputSequenceCharacter(seq.getSequence().toUpperCase()));
            inputs.add(input);
            ++i;
        }
    }

    @Override
    public void writeInputSequences(String location, List<? extends Map<String, ? extends InputSequence<?>>> inputComponents) throws IOException {
        FastaWriter w = new FastaWriter(location, false);
        for (Map<String, InputSequence<?>> input : inputComponents) {
            NameInputSequence nameSeq = (NameInputSequence)input.get(this.header);
            InputSequenceCharacter seqSeq = (InputSequenceCharacter)input.get(this.sequence);
            w.writeSeq(nameSeq.getName(), seqSeq.getString());
        }
        w.close();
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public Integer getNumSeqCap() {
        return this.numSeqCap;
    }

    public void setNumSeqCap(Integer numSeqCap) {
        this.numSeqCap = numSeqCap;
    }
}

