/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.io;

import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.io.InputSequenceCharacter;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.analysis.crf.io.TrainingSequenceIO;
import calhoun.analysis.crf.solver.CacheProcessor;
import calhoun.util.Assert;
import calhoun.util.FileUtil;
import fmph.features.mitochondrion1.GeneConstraintsMitochondrion1;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GTFInputInterval13
implements TrainingSequenceIO {
    private static final long serialVersionUID = 4413724139445660883L;
    private static final Log log = LogFactory.getLog(GTFInputInterval13.class);
    String nameComponent = "name";

    @Override
    public void readTrainingSequences(Object location, List<TrainingSequence<Map<String, Object>>> seqs) throws IOException {
        String[][] gtf = FileUtil.readFlatFile((String)location);
        HashMap exonLists = new HashMap();
        for (TrainingSequence<Map<String, Object>> seq : seqs) {
            exonLists.put((String)seq.getInputSequence().getComponent("name").getX(0), new ArrayList());
        }
        int threwout = 0;
        int kept = 0;
        for (String[] row : gtf) {
            if (!row[2].equalsIgnoreCase("cds")) continue;
            CDS cds = new CDS();
            cds.seq = row[0];
            cds.start = Integer.parseInt(row[3]);
            cds.stop = Integer.parseInt(row[4]);
            cds.strand = row[6].charAt(0);
            String attributes = row[8];
            for (String pair : attributes.split(";")) {
                String[] keyValue = pair.trim().split(" ");
                if (keyValue[1].charAt(0) == '\"') {
                    keyValue[1] = keyValue[1].substring(1, keyValue[1].length() - 1);
                }
                if (!keyValue[0].equals("gene_id") && !keyValue[0].equals("Parent")) continue;
                cds.gene = keyValue[1];
            }
            Assert.a(cds.gene != null);
            if (exonLists.containsKey(cds.seq)) {
                ((List)exonLists.get(cds.seq)).add(cds);
                ++kept;
                continue;
            }
            ++threwout;
        }
        if (threwout > 0) {
            log.warn((Object)("Threw out " + threwout + " of " + (threwout + kept) + " exons"));
        }
        for (TrainingSequence<Map<String, Object>> seq : seqs) {
            String name = (String)seq.getInputSequence().getComponent("name").getX(0);
            List exons = (List)exonLists.get(name);
            Collections.sort(exons);
            int[] states = new int[seq.length()];
            this.mapExonsToStates(exons, states);
            seq.setY(states);
        }
    }

    void mapExonsToStates(List<CDS> exons, int[] states) {
        if (exons.size() == 0) {
            return;
        }
        int currentPosition = Integer.MIN_VALUE;
        int exonState = Integer.MIN_VALUE;
        int intronState = Integer.MIN_VALUE;
        String currentGene = null;
        for (CDS exon : exons) {
            log.warn((Object)(exon.gene + ": " + exon.start + "-" + exon.stop));
            boolean sameGene = exon.gene.equals(currentGene);
            if (sameGene) {
                intronState = exon.strand == '+' ? (3 - (currentPosition - (exonState - 1)) % 3) % 3 + 4 : (currentPosition - (exonState - 7)) % 3 + 10;
                Arrays.fill(states, currentPosition, exon.start - 1, intronState);
            }
            exonState = sameGene ? (exon.strand == '+' ? (exon.start - 1 + intronState - 4) % 3 + 1 : (exon.start - 1 - (intronState - 10)) % 3 + 7) : (exon.start - 1) % 3 + 1 + (exon.strand == '-' ? 6 : 0);
            Arrays.fill(states, exon.start - 1, exon.stop, exonState);
            currentGene = exon.gene;
            currentPosition = exon.stop;
        }
    }

    @Override
    public void writeTrainingSequences(Object location, Iterator<int[]> data) throws IOException {
    }

    public String getNameComponent() {
        return this.nameComponent;
    }

    public void setNameComponent(String nameComponent) {
        this.nameComponent = nameComponent;
    }

    void confirmSeq(TrainingSequence<?> seq) {
        int[] states = seq.y;
        DirectFeatureList f = new DirectFeatureList();
        GeneConstraintsMitochondrion1 g = new GeneConstraintsMitochondrion1();
        InputSequenceCharacter a = (InputSequenceCharacter)seq.getInputSequence().getComponent("ref");
        for (int i = 1; i < seq.length(); ++i) {
            g.evaluateEdge(a, i, states[i - 1], states[i], (FeatureList)f);
            Assert.a(f.valid, String.format("Invalid at %d: %d-%d", i, states[i - 1], states[i]));
        }
    }

    class DirectFeatureList
    implements FeatureList {
        CacheProcessor.FeatureEvaluation evals1;
        public int position;
        boolean valid = true;

        @Override
        public void addFeature(int index, double val) {
            this.evals1.index[this.position] = (short)index;
            this.evals1.value[this.position++] = (float)val;
        }

        @Override
        public boolean isValid() {
            return this.valid;
        }

        @Override
        public void invalidate() {
            this.valid = false;
        }
    }

    static class CDS
    implements Comparable<CDS> {
        String seq;
        String gene;
        int start;
        int stop;
        char strand;

        CDS() {
        }

        @Override
        public int compareTo(CDS other) {
            return new CompareToBuilder().append((Object)this.seq, (Object)other.seq).append((Object)this.gene, (Object)other.gene).append(this.start, other.start).toComparison();
        }

        public boolean equals(CDS other) {
            return new EqualsBuilder().append((Object)this.seq, (Object)other.seq).append((Object)this.gene, (Object)other.gene).append(this.start, other.start).isEquals();
        }

        public long hashcode() {
            return new HashCodeBuilder().append((Object)this.seq).append((Object)this.gene).append(this.start).hashCode();
        }
    }
}

