/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.io;

import calhoun.analysis.crf.io.InputComponentIO;
import calhoun.analysis.crf.io.InputHandlerBase;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.IteratorAdapterInputComponent;
import calhoun.analysis.crf.io.IteratorAdapterTrainingSequenceInput;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.analysis.crf.io.TrainingSequenceIO;
import calhoun.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class InputHandlerDirectory
extends InputHandlerBase {
    private static final long serialVersionUID = -2969140424776995686L;
    Map<String, InputComponentIO> inputReaders;
    TrainingSequenceIO hiddenStateReader;
    String hiddenSequenceFile = "hidden.dat";

    @Override
    public Iterator<? extends InputSequence<?>> readInputData(String location) throws IOException {
        ArrayList inputs = new ArrayList();
        for (Map.Entry<String, InputComponentIO> entry : this.inputReaders.entrySet()) {
            entry.getValue().readInputSequences(new File(location, entry.getKey()).getPath(), inputs);
        }
        return this.createCompositeInput(inputs);
    }

    @Override
    public List<? extends TrainingSequence<?>> readTrainingData(String location) throws IOException {
        return this.readTrainingData(location, false);
    }

    @Override
    public List<? extends TrainingSequence<?>> readTrainingData(String location, boolean predict) throws IOException {
        String trainingLocation = new File(location, this.hiddenSequenceFile).getPath();
        return this.readTrainingData(location, trainingLocation, this.hiddenStateReader, predict);
    }

    @Override
    public void writeInputData(String location, Iterator<? extends InputSequence<?>> data) throws IOException {
        ArrayList compList = new ArrayList();
        Util.addAll(compList, new IteratorAdapterInputComponent(data));
        for (Map.Entry<String, InputComponentIO> entry : this.inputReaders.entrySet()) {
            entry.getValue().writeInputSequences(new File(location, entry.getKey()).getPath(), compList);
        }
    }

    @Override
    public void writeTrainingData(String location, List<? extends TrainingSequence<?>> data) throws IOException {
        this.writeInputData(location, new IteratorAdapterTrainingSequenceInput(data.iterator()));
        ArrayList<int[]> trainingSeqs = new ArrayList<int[]>();
        for (TrainingSequence<?> t : data) {
            trainingSeqs.add(t.getY());
        }
        this.hiddenStateReader.writeTrainingSequences(new File(location, this.hiddenSequenceFile).getPath(), trainingSeqs.iterator());
    }

    public TrainingSequenceIO getHiddenStateReader() {
        return this.hiddenStateReader;
    }

    public void setHiddenStateReader(TrainingSequenceIO hiddenStateReader) {
        this.hiddenStateReader = hiddenStateReader;
    }

    public Map<String, InputComponentIO> getInputReaders() {
        return this.inputReaders;
    }

    public void setInputReaders(Map<String, InputComponentIO> inputReader) {
        this.inputReaders = inputReader;
    }

    public String getHiddenSequenceFile() {
        return this.hiddenSequenceFile;
    }

    public void setHiddenSequenceFile(String hiddenSequenceFile) {
        this.hiddenSequenceFile = hiddenSequenceFile;
    }
}

