/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.io;

import calhoun.analysis.crf.io.InputSequence;
import calhoun.util.Assert;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class InputSequenceComposite
implements InputSequence<Map<String, Object>> {
    Map<String, InputSequence<?>> components = new HashMap();
    int length = -1;

    public InputSequenceComposite() {
    }

    public InputSequenceComposite(Map<String, InputSequence<?>> data) {
        this.addComponents(data);
    }

    public void addComponent(String name, InputSequence<?> seq) {
        Assert.a(!this.components.containsKey(name), "Component already exists in composite input: ", name);
        if (this.length == -1) {
            this.length = seq.length();
        }
        Assert.a(seq.length() == -1 || this.length == seq.length(), "Composite sequence has length ", this.length, " but attempted to add component named ", name, " of length ", seq.length());
        this.components.put(name, seq);
    }

    public void addComponents(Map<String, InputSequence<?>> data) {
        for (Map.Entry<String, InputSequence<?>> entry : data.entrySet()) {
            this.addComponent(entry.getKey(), entry.getValue());
        }
    }

    public Map<String, InputSequence<?>> getComponents() {
        return this.components;
    }

    @Override
    public Map<String, Object> getX(int ix) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (Map.Entry<String, InputSequence<?>> entry : this.components.entrySet()) {
            ret.put(entry.getKey(), entry.getValue().getX(ix));
        }
        return ret;
    }

    @Override
    public int length() {
        Assert.a(this.components.size() > 0, "Length of composite sequence was called before any components were added.");
        return this.length;
    }

    @Override
    public InputSequence<?> getComponent(String name) {
        return this.components.get(name);
    }

    @Override
    public Collection<String> listComponents() {
        return this.components.keySet();
    }

    public InputSequenceComposite subSequence(int start, int end) {
        Assert.a(start >= 1);
        Assert.a(end <= this.length());
        Assert.a(start <= end);
        InputSequenceComposite ret = new InputSequenceComposite();
        for (Map.Entry<String, InputSequence<?>> entry : this.components.entrySet()) {
            ret.addComponent(entry.getKey(), entry.getValue().subSequence(start, end));
        }
        return ret;
    }
}

