/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.io;

import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.InterleavedInputComponentBase;
import calhoun.analysis.crf.io.IntervalInputSequence;
import calhoun.util.Assert;
import calhoun.util.RangeMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IntervalInput
extends InterleavedInputComponentBase {
    private static final long serialVersionUID = 8110670530135286052L;
    private static final Log log = LogFactory.getLog(IntervalInput.class);

    @Override
    public boolean read(BufferedReader r, Map<String, InputSequence<?>> output) throws IOException {
        int inputLength;
        String temp;
        String inputName = temp = r.readLine();
        temp = r.readLine();
        try {
            inputLength = Integer.parseInt(temp);
        }
        catch (Exception e) {
            throw new RuntimeException("Offending line was : " + temp);
        }
        log.debug((Object)("Length of " + inputName + "   is  " + inputLength));
        RangeMap rmplus = new RangeMap();
        RangeMap rmminus = new RangeMap();
        String bigLine = r.readLine();
        String[] fields = bigLine.split("[(]");
        for (int k = 1; k < fields.length; ++k) {
            String[] rings = fields[k].split("[,)]");
            int start = Integer.parseInt(rings[0]);
            int stop = Integer.parseInt(rings[1]);
            char strand = rings[2].charAt(0);
            double val = Double.parseDouble(rings[3]);
            IntervalInputSequence.IntervalRangeMapValue irmv = new IntervalInputSequence.IntervalRangeMapValue(start, stop, val);
            if (strand == '+') {
                irmv.insertIntoRangeMap(rmplus);
                continue;
            }
            if (strand == '-') {
                irmv.insertIntoRangeMap(rmminus);
                continue;
            }
            Assert.a(false);
        }
        IntervalInputSequence inputSeq = new IntervalInputSequence(rmplus, rmminus, inputName, inputLength);
        output.put(this.name, inputSeq);
        return true;
    }

    @Override
    public void write(Writer w, Map<String, ? extends InputSequence<?>> data) throws IOException {
        IntervalInputSequence seq = (IntervalInputSequence)((Object)data);
        w.write(seq.inputName + "\n");
        w.write("" + seq.inputLength + "\n");
        Object[] rmplusList = seq.rmplus.getObjectList().values().toArray();
        for (int i = 0; i < rmplusList.length; ++i) {
            w.write(((IntervalInputSequence.IntervalRangeMapValue)rmplusList[i]).toStringStrand("+"));
        }
        Object[] rmminusList = seq.rmminus.getObjectList().values().toArray();
        for (int i = 0; i < rmminusList.length; ++i) {
            w.write(((IntervalInputSequence.IntervalRangeMapValue)rmminusList[i]).toStringStrand("+"));
        }
        w.write("\n");
    }
}

