/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.io;

import calhoun.analysis.crf.features.supporting.phylogenetic.RootedBinaryPhylogeneticTree;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.InterleavedInputComponentBase;
import calhoun.analysis.crf.io.MultipleAlignmentInputSequence;
import calhoun.util.Assert;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultipleAlignmentInput
extends InterleavedInputComponentBase {
    private static final long serialVersionUID = 1796622784861590659L;
    private static final Log log = LogFactory.getLog(MultipleAlignmentInput.class);

    @Override
    public boolean read(BufferedReader r, Map<String, InputSequence<?>> output) throws IOException {
        int nSpecies;
        ArrayList<String> speciesNames = new ArrayList<String>();
        ArrayList<String> consensuses = new ArrayList<String>();
        String temp = r.readLine();
        if (temp == null) {
            return false;
        }
        try {
            nSpecies = Integer.parseInt(temp);
        }
        catch (Exception e) {
            log.error((Object)("Offending line was : " + temp));
            throw new IOException();
        }
        temp = r.readLine();
        RootedBinaryPhylogeneticTree tree = new RootedBinaryPhylogeneticTree(temp);
        log.debug((Object)("Number of species : " + nSpecies));
        for (int spec = 0; spec < nSpecies; ++spec) {
            String str1 = r.readLine();
            Assert.a(str1 != null);
            log.debug((Object)("One of the species: " + str1));
            speciesNames.add(str1.substring(1));
            String str2 = r.readLine();
            Assert.a(str2 != null);
            consensuses.add(str2);
        }
        MultipleAlignmentInputSequence inputSeq = new MultipleAlignmentInputSequence(speciesNames, consensuses, (String)speciesNames.get(0), tree);
        output.put(this.name, inputSeq);
        return true;
    }

    @Override
    public void write(Writer w, Map<String, ? extends InputSequence<?>> data) throws IOException {
        MultipleAlignmentInputSequence inputSeq = (MultipleAlignmentInputSequence)data.get(this.name);
        w.write("" + inputSeq.nSpecies + "\n");
        w.write("" + inputSeq.tree.newick() + "\n");
        for (int spec = 0; spec < inputSeq.nSpecies; ++spec) {
            w.write(">" + inputSeq.speciesNames.get(spec));
            w.write(10);
            w.write(inputSeq.consensuses.get(spec));
            w.write(10);
        }
    }
}

