/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.io;

import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.InputHandler;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.InputSequenceComposite;
import calhoun.analysis.crf.io.IntervalInputSequence;
import calhoun.analysis.crf.io.NameInputSequence;
import calhoun.analysis.crf.io.OutputHandler;
import calhoun.analysis.crf.io.SequenceConverter;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.analysis.crf.statistics.PredictedActualBinaryContingencyTable;
import calhoun.util.Assert;
import calhoun.util.DenseBooleanMatrix2D;
import calhoun.util.FileUtil;
import calhoun.util.RangeMap;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutputHandlerGeneCallStats
implements OutputHandler {
    private static final long serialVersionUID = -1506791895658464225L;
    private static final Log log = LogFactory.getLog(OutputHandlerGeneCallStats.class);
    private ModelManager manager;
    private InputHandler inputHandler;
    String location;
    boolean writeTrainingData = false;
    private List<TrainingSequence<?>> labeled = new ArrayList();
    private int correct = 0;
    private int incorrect = 0;
    private int perfect = 0;
    private int imperfect = 0;
    private transient double[] viterbiScores;
    private double lla = 0.0;
    private double llv = 0.0;
    private int nStates;
    private int nTransitions;
    private List<Integer> fromInd;
    private List<Integer> toInd;
    private PredictedActualBinaryContingencyTable ctCodingNucleotide;
    private PredictedActualBinaryContingencyTable ctExons;
    private List<PredictedActualBinaryContingencyTable> ctStates;
    private List<PredictedActualBinaryContingencyTable> ctTransitions;
    String seqName;
    String genePrefix;
    long offset;

    public OutputHandlerGeneCallStats() {
    }

    public OutputHandlerGeneCallStats(ModelManager manager, InputHandler inputHandler) {
        this.inputHandler = inputHandler;
        this.setManager(manager);
    }

    @Override
    public void setOutputLocation(String location) {
        this.location = location;
    }

    @Override
    public void writeOutput(InputSequence<?> sequence, int[] hiddenStates) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTestOutput(InputSequence<?> sequence, int[] truePath, int[] hiddenStates) throws IOException {
        this.calcResultIncrement(new TrainingSequence(sequence, truePath), hiddenStates);
    }

    @Override
    public void outputComplete() throws IOException {
        if (this.location != null) {
            if (this.writeTrainingData) {
                try {
                    this.inputHandler.writeTrainingData(this.location, this.labeled);
                }
                catch (Exception ex) {
                    log.warn((Object)"Unable to write training data", (Throwable)ex);
                }
            }
            this.writeGTF(this.labeled, this.location + ".gtf");
            System.out.print(this);
            this.writeResults(this.location + ".dat");
        }
    }

    public InputHandler getInputHandler() {
        return this.inputHandler;
    }

    public void setInputHandler(InputHandler inputHandler) {
        this.inputHandler = inputHandler;
    }

    public ModelManager getManager() {
        return this.manager;
    }

    public void setManager(ModelManager manager) {
        this.manager = manager;
        this.ctCodingNucleotide = new PredictedActualBinaryContingencyTable();
        this.ctExons = new PredictedActualBinaryContingencyTable();
        this.ctExons.forgetTN();
        this.nStates = manager.getNumStates();
        this.ctStates = new ArrayList<PredictedActualBinaryContingencyTable>();
        for (int i = 0; i < this.nStates; ++i) {
            this.ctStates.add(new PredictedActualBinaryContingencyTable());
        }
        DenseBooleanMatrix2D LT = manager.getLegalTransitions();
        this.fromInd = new ArrayList<Integer>();
        this.toInd = new ArrayList<Integer>();
        for (int from = 0; from < this.nStates; ++from) {
            for (int to = 0; to < this.nStates; ++to) {
                if (!LT.getQuick(from, to)) continue;
                this.fromInd.add(from);
                this.toInd.add(to);
            }
        }
        this.nTransitions = this.fromInd.size();
        this.ctTransitions = new ArrayList<PredictedActualBinaryContingencyTable>();
        for (int i = 0; i < this.nTransitions; ++i) {
            this.ctTransitions.add(new PredictedActualBinaryContingencyTable());
        }
    }

    public float getAccuracy() {
        return (float)this.correct / (float)(this.correct + this.incorrect);
    }

    void writeResults(String loc) throws IOException {
        Results results = new Results();
        results.ctCodingNucleotide = this.ctCodingNucleotide;
        results.ctExons = this.ctExons;
        results.ctStates = this.ctStates;
        results.ctTransitions = this.ctTransitions;
        results.correct = this.correct;
        results.incorrect = this.incorrect;
        results.perfect = this.perfect;
        results.imperfect = this.imperfect;
        FileUtil.writeObject(loc, results);
    }

    public String toString() {
        String ret = "NOTE: If you're using the CRF for prediction and pass in a dummy (e.g. all zeros) hidden\n";
        ret = ret + "  sequence, then many of the following statistics will not be meaningful\n";
        for (int s = 0; s < this.nStates; ++s) {
            ret = ret + "[State=" + this.manager.getStateName(s) + "] ";
            this.ctStates.get(s).freeze();
            ret = ret + this.ctStates.get(s).summarize();
            ret = ret + "\n";
        }
        for (int t = 0; t < this.nTransitions; ++t) {
            ret = ret + "[Transition " + this.manager.getStateName(this.fromInd.get(t)) + " --> " + this.manager.getStateName(this.toInd.get(t)) + " ] ";
            this.ctTransitions.get(t).freeze();
            ret = ret + this.ctTransitions.get(t).summarize();
            ret = ret + "\n";
        }
        this.ctCodingNucleotide.freeze();
        ret = ret + "[Coding nucleotides] " + this.ctCodingNucleotide.summarize() + "\n";
        this.ctExons.freeze();
        ret = ret + "[Coding exons] " + this.ctExons.summarize() + "\n";
        if (this.lla > 0.0) {
            ret = ret + "LLA:" + this.lla + "  LLV:" + this.llv + "  " + "\n";
        }
        ret = ret + String.format("Perfectly predicted hidden sequences: %d/%d %.2f %%", this.perfect, this.perfect + this.imperfect, (double)this.perfect * 100.0 / (double)(this.perfect + this.imperfect)) + "\n";
        ret = ret + String.format("Nucleotide Hidden State Agreement: %d/%d %.2f %%", this.correct, this.correct + this.incorrect, (double)this.correct * 100.0 / (double)(this.correct + this.incorrect)) + "\n";
        return ret;
    }

    public void calcResultIncrement(TrainingSequence training, int[] predictedHiddenSequence) {
        int predY;
        int realY;
        int i;
        this.labeled.add(new TrainingSequence(training.getInputSequence(), predictedHiddenSequence));
        Assert.a(training.length() == predictedHiddenSequence.length);
        int[] actualHiddenSequence = new int[training.length()];
        for (int i2 = 0; i2 < training.length(); ++i2) {
            actualHiddenSequence[i2] = training.getY(i2);
        }
        boolean thisperfect = true;
        for (i = 0; i < predictedHiddenSequence.length; ++i) {
            realY = actualHiddenSequence[i];
            predY = predictedHiddenSequence[i];
            if (realY == predY) {
                ++this.correct;
            } else {
                ++this.incorrect;
                thisperfect = false;
            }
            this.ctCodingNucleotide.increment(this.isCodingPlus(predY), this.isCodingPlus(realY));
            this.ctCodingNucleotide.increment(this.isCodingMinus(predY), this.isCodingMinus(realY));
            for (int s = 0; s < this.nStates; ++s) {
                this.ctStates.get(s).increment(predY == s, realY == s);
            }
        }
        if (thisperfect) {
            ++this.perfect;
        } else {
            ++this.imperfect;
        }
        for (i = 1; i < predictedHiddenSequence.length; ++i) {
            predY = predictedHiddenSequence[i];
            realY = actualHiddenSequence[i];
            int predYp = predictedHiddenSequence[i - 1];
            int realYp = actualHiddenSequence[i - 1];
            for (int t = 0; t < this.nTransitions; ++t) {
                boolean bPred = predYp == this.fromInd.get(t) && predY == this.toInd.get(t);
                boolean bReal = realYp == this.fromInd.get(t) && realY == this.toInd.get(t);
                this.ctTransitions.get(t).increment(bPred, bReal);
            }
        }
        RangeMap predExonsPlus = new RangeMap();
        RangeMap predExonsMinus = new RangeMap();
        RangeMap realExonsPlus = new RangeMap();
        RangeMap realExonsMinus = new RangeMap();
        this.makeExonRangeMapFrom13SV(predictedHiddenSequence, predExonsPlus, predExonsMinus);
        this.makeExonRangeMapFrom13SV(actualHiddenSequence, realExonsPlus, realExonsMinus);
        this.incrementCTFromRangeMaps(this.ctExons, predExonsPlus, realExonsPlus);
        this.incrementCTFromRangeMaps(this.ctExons, predExonsMinus, realExonsMinus);
    }

    private void incrementCTFromRangeMaps(PredictedActualBinaryContingencyTable ct, RangeMap pred, RangeMap real) {
        Set pv = pred.values();
        for (IntervalInputSequence.IntervalRangeMapValue irmv : pv) {
            Set vals = real.find(irmv.start, irmv.end);
            if (vals.size() == 0) {
                ct.incrementFP();
                continue;
            }
            IntervalInputSequence.IntervalRangeMapValue val = (IntervalInputSequence.IntervalRangeMapValue)vals.iterator().next();
            if (val.start == irmv.start && val.end == irmv.end) {
                ct.incrementTP();
                continue;
            }
            ct.incrementFP();
        }
        Set rv = real.values();
        for (IntervalInputSequence.IntervalRangeMapValue irmv : rv) {
            Set vals;
            if (!pred.hasEntry(irmv.start, irmv.end)) {
                ct.incrementFN();
            }
            if ((vals = pred.find(irmv.start, irmv.end)).size() == 0) {
                ct.incrementFN();
                continue;
            }
            IntervalInputSequence.IntervalRangeMapValue val = (IntervalInputSequence.IntervalRangeMapValue)vals.iterator().next();
            if (val.start == irmv.start && val.end == irmv.end) continue;
            ct.incrementFN();
        }
    }

    private void makeExonRangeMapFrom13SV(int[] hidden, RangeMap exonsPlus, RangeMap exonsMinus) {
        int len = hidden.length;
        for (int i = 1; i < len; ++i) {
            int j;
            if (!this.isCodingPlus(hidden[i - 1]) && this.isCodingPlus(hidden[i])) {
                for (j = i; this.isCodingPlus(hidden[j]) && j < len - 1; ++j) {
                }
                exonsPlus.add(i, j, new IntervalInputSequence.IntervalRangeMapValue(i, j, 1.0));
            }
            if (this.isCodingMinus(hidden[i - 1]) || !this.isCodingMinus(hidden[i])) continue;
            for (j = i; this.isCodingMinus(hidden[j]) && j < len - 1; ++j) {
            }
            exonsMinus.add(i, j, new IntervalInputSequence.IntervalRangeMapValue(i, j, 1.0));
        }
    }

    private boolean isCodingPlus(int y) {
        Assert.a(y >= 0 && y < 13);
        return y == 1 || y == 2 || y == 3;
    }

    private boolean isCodingMinus(int y) {
        Assert.a(y >= 0 && y < 13);
        return y == 7 || y == 8 || y == 9;
    }

    public void loglikelihoodIncrement(double logLikelihoodActual, double logLikelihoodViterbi) {
        this.lla += logLikelihoodActual;
        this.llv += logLikelihoodViterbi;
    }

    public TrainingSequence getLabeled(int i) {
        return this.labeled.get(i);
    }

    public void writeGTF(List<? extends TrainingSequence<?>> refStates, String filename) throws IOException {
        long i;
        int frame = -1;
        BufferedWriter fout = new BufferedWriter(new FileWriter(filename));
        long exonEnd = 0L;
        long exonStart = 0L;
        int geneNum = 1;
        int seqCount = 0;
        boolean interval13 = false;
        for (TrainingSequence<?> trainingSequence : refStates) {
            if (trainingSequence.length() == 0) continue;
            int prevState = trainingSequence.getY(0);
            for (i = 1L; i < (long)trainingSequence.length(); ++i) {
                int state = trainingSequence.getY((int)i);
                if (prevState == 0 && (state == 2 || state == 3 || state == 7 || state == 8)) {
                    interval13 = true;
                    break;
                }
                prevState = state;
            }
            if (!interval13) continue;
            break;
        }
        for (TrainingSequence<Character> trainingSequence : refStates) {
            if (interval13) {
                SequenceConverter.convertSeqFromInterval13ToTricycle13(trainingSequence);
            }
            boolean inPlusExon = false;
            boolean inMinusExon = false;
            boolean firstExon = true;
            boolean startCodonSplit = false;
            this.parseSeqName(trainingSequence, seqCount);
            for (i = 0L; i < (long)trainingSequence.length(); ++i) {
                String strand;
                int ref = trainingSequence.getY((int)i);
                if (ref == 1 || ref == 2 || ref == 3) {
                    if (inPlusExon) continue;
                    exonStart = i + 1L;
                    inPlusExon = true;
                    frame = OutputHandlerGeneCallStats.setFrame(ref);
                    continue;
                }
                if (ref == 7 || ref == 8 || ref == 9) {
                    if (inMinusExon) continue;
                    exonStart = i + 1L;
                    inMinusExon = true;
                    frame = OutputHandlerGeneCallStats.setFrame(ref);
                    if (!firstExon) continue;
                    if (i < 3L) {
                        System.err.println("Minus strand gene start is within 3 nucleotides of sequence start.  No stop codon writen to GTF for gene starting at position " + (exonStart + this.offset));
                        continue;
                    }
                    OutputHandlerGeneCallStats.writeGFTLine(fout, this.seqName, "stop_codon", exonStart + this.offset - 3L, exonStart + this.offset - 1L, "-", frame, this.genePrefix, geneNum);
                    continue;
                }
                if (inPlusExon && (ref == 4 || ref == 5 || ref == 6)) {
                    strand = "+";
                    inPlusExon = false;
                    exonEnd = i;
                    if (firstExon) {
                        long end;
                        if (exonEnd - exonStart + 1L < 3L) {
                            end = exonEnd + this.offset;
                            startCodonSplit = true;
                        } else {
                            end = exonStart + this.offset + 2L;
                        }
                        OutputHandlerGeneCallStats.writeGFTLine(fout, this.seqName, "start_codon", exonStart + this.offset, end, strand, frame, this.genePrefix, geneNum);
                        firstExon = false;
                    } else if (startCodonSplit) {
                        Assert.a(frame == 1 || frame == 2);
                        OutputHandlerGeneCallStats.writeGFTLine(fout, this.seqName, "start_codon", exonStart + this.offset, exonStart + this.offset + (long)frame - 1L, strand, frame, this.genePrefix, geneNum);
                        startCodonSplit = false;
                    }
                    OutputHandlerGeneCallStats.writeGFTLine(fout, this.seqName, "CDS", exonStart + this.offset, exonEnd + this.offset, strand, frame, this.genePrefix, geneNum);
                    continue;
                }
                if (inMinusExon && (ref == 10 || ref == 11 || ref == 12)) {
                    strand = "-";
                    inMinusExon = false;
                    firstExon = false;
                    exonEnd = i;
                    OutputHandlerGeneCallStats.writeGFTLine(fout, this.seqName, "CDS", exonStart + this.offset, exonEnd + this.offset, strand, frame, this.genePrefix, geneNum);
                    continue;
                }
                boolean write = true;
                if (inPlusExon) {
                    strand = "+";
                    exonEnd = i;
                    if (firstExon) {
                        if (exonEnd - exonStart + 1L < 3L) {
                            System.err.println("Single '" + strand + "' strand exon is < 3 bases for sequence '" + this.seqName + "'.  exonStart=" + exonStart + "  exonEnd=" + exonEnd);
                            write = false;
                        } else {
                            OutputHandlerGeneCallStats.writeGFTLine(fout, this.seqName, "start_codon", exonStart + this.offset, exonStart + this.offset + 2L, strand, frame, this.genePrefix, geneNum);
                        }
                    } else if (startCodonSplit) {
                        Assert.a(frame == 1 || frame == 2);
                        OutputHandlerGeneCallStats.writeGFTLine(fout, this.seqName, "start_codon", exonStart + this.offset, exonStart + this.offset + (long)frame - 1L, strand, frame, this.genePrefix, geneNum);
                    }
                    if (write) {
                        OutputHandlerGeneCallStats.writeGFTLine(fout, this.seqName, "CDS", exonStart + this.offset, exonEnd + this.offset, strand, frame, this.genePrefix, geneNum);
                        OutputHandlerGeneCallStats.writeGFTLine(fout, this.seqName, "stop_codon", exonEnd + this.offset + 1L, exonEnd + this.offset + 3L, strand, 0, this.genePrefix, geneNum);
                    }
                    inPlusExon = false;
                    firstExon = true;
                    startCodonSplit = false;
                    ++geneNum;
                    continue;
                }
                if (!inMinusExon) continue;
                strand = "-";
                long prevExonEnd = exonEnd;
                exonEnd = i;
                if (firstExon && exonEnd - exonStart + 1L < 3L) {
                    System.err.println("Single '" + strand + "' strand exon is < 3 bases for sequence '" + this.seqName + "'.  exonStart=" + exonStart + "  exonEnd=" + exonEnd);
                } else if (exonEnd - exonStart + 1L < 3L) {
                    if (exonEnd - exonStart + 1L == 2L) {
                        OutputHandlerGeneCallStats.writeGFTLine(fout, this.seqName, "start_codon", prevExonEnd + this.offset, prevExonEnd + this.offset, strand, 0, this.genePrefix, geneNum);
                        OutputHandlerGeneCallStats.writeGFTLine(fout, this.seqName, "CDS", exonStart + this.offset, exonEnd + this.offset, strand, frame, this.genePrefix, geneNum);
                        OutputHandlerGeneCallStats.writeGFTLine(fout, this.seqName, "start_codon", exonStart + this.offset, exonEnd + this.offset, strand, 2, this.genePrefix, geneNum);
                    } else if (exonEnd - exonStart + 1L == 1L) {
                        OutputHandlerGeneCallStats.writeGFTLine(fout, this.seqName, "start_codon", prevExonEnd + this.offset - 1L, prevExonEnd + this.offset, strand, 0, this.genePrefix, geneNum);
                        OutputHandlerGeneCallStats.writeGFTLine(fout, this.seqName, "CDS", exonStart + this.offset, exonEnd + this.offset, strand, frame, this.genePrefix, geneNum);
                        OutputHandlerGeneCallStats.writeGFTLine(fout, this.seqName, "start_codon", exonStart + this.offset, exonEnd + this.offset, strand, 1, this.genePrefix, geneNum);
                    }
                } else {
                    OutputHandlerGeneCallStats.writeGFTLine(fout, this.seqName, "CDS", exonStart + this.offset, exonEnd + this.offset, strand, frame, this.genePrefix, geneNum);
                    OutputHandlerGeneCallStats.writeGFTLine(fout, this.seqName, "start_codon", exonEnd + this.offset - 2L, exonEnd + this.offset, strand, 0, this.genePrefix, geneNum);
                }
                inMinusExon = false;
                firstExon = true;
                startCodonSplit = false;
                ++geneNum;
            }
            ++seqCount;
        }
        ((Writer)fout).close();
    }

    private void parseSeqName(TrainingSequence seq, int seqNum) {
        NameInputSequence nameInput = null;
        InputSequence inputSeq = seq.getInputSequence();
        if (inputSeq instanceof InputSequenceComposite) {
            nameInput = (NameInputSequence)inputSeq.getComponent("name");
        }
        if (nameInput == null) {
            log.debug((Object)("Sequence name not specified.  Setting sequence name to 'SEQ_" + String.valueOf(seqNum) + "'"));
            this.seqName = "SEQ_" + String.valueOf(seqNum);
            this.genePrefix = "SEQ_" + String.valueOf(seqNum);
            this.offset = 0L;
            return;
        }
        String name = nameInput.getName().trim();
        if (name.startsWith("group:") || name.startsWith("seq:")) {
            int numColons = OutputHandlerGeneCallStats.numOccurrences(name, ':');
            if (numColons == 1) {
                int colon1 = name.indexOf(":");
                this.seqName = name;
                this.genePrefix = name.substring(colon1 + 1, name.length());
                this.offset = 0L;
                return;
            }
            if (numColons == 2) {
                int colon1 = name.indexOf(":");
                int colon2 = name.lastIndexOf(":");
                this.seqName = name.substring(0, colon2);
                this.genePrefix = name.substring(colon1 + 1, colon2);
                int pound = this.genePrefix.indexOf("#");
                if (pound > 0) {
                    this.genePrefix = this.genePrefix.substring(0, pound);
                }
                this.setOffset(name.substring(colon2 + 1, name.length()));
                return;
            }
        }
        log.debug((Object)("Sequence name is in unexpected format.  Setting offset=0 and sequence name='" + name + "'."));
        this.seqName = name;
        this.genePrefix = name;
        this.offset = 0L;
    }

    private static int numOccurrences(String str, char c) {
        int num = 0;
        int index = str.indexOf(c);
        while (index != -1) {
            ++num;
            index = str.indexOf(c, index + 1);
        }
        return num;
    }

    private void setOffset(String str) {
        int numDashes = OutputHandlerGeneCallStats.numOccurrences(str, '-');
        if (numDashes == 0) {
            this.offset = 0L;
        } else if (numDashes == 1) {
            try {
                int dash = str.indexOf("-");
                this.offset = Long.valueOf(str.substring(0, dash)) - 1L;
            }
            catch (NumberFormatException e) {
                System.err.println("Sequence range values in unexpected format.  Setting offset=0 for sequence='" + this.seqName + "'.");
                this.offset = 0L;
            }
        } else {
            System.err.println("Sequence range values in unexpected format.  Setting offset=0 for sequence='" + this.seqName + "'.");
            this.offset = 0L;
        }
    }

    private static int setFrame(int ref) {
        int frame = -1;
        switch (ref) {
            case 1: {
                frame = 0;
                break;
            }
            case 2: {
                frame = 2;
                break;
            }
            case 3: {
                frame = 1;
                break;
            }
            case 7: {
                frame = 1;
                break;
            }
            case 8: {
                frame = 2;
                break;
            }
            case 9: {
                frame = 0;
                break;
            }
            default: {
                Assert.a(false, "Error setting frame, ref = ", ref);
            }
        }
        return frame;
    }

    private static void writeGFTLine(Writer out, String seqName, String feature, long exonStart, long exonEnd, String strand, int frame, String genePrefix, int geneNum) throws IOException {
        Assert.a(frame == 0 || frame == 1 || frame == 2, "Frame value invalid, frame = ", frame);
        String geneId = genePrefix + "G_" + String.valueOf(geneNum);
        String transId = genePrefix + "T_" + String.valueOf(geneNum) + ".1";
        out.write(seqName + "\t" + "CONRAD" + "\t" + feature + "\t" + exonStart + "\t" + exonEnd + "\t" + "." + "\t" + strand + "\t" + frame + "\t" + "gene_id \"" + geneId + "\"; transcript_id \"" + transId + "\";\n");
    }

    public double[] getViterbiScores() {
        return this.viterbiScores;
    }

    public boolean isWriteTrainingData() {
        return this.writeTrainingData;
    }

    public void setWriteTrainingData(boolean writeTrainingData) {
        this.writeTrainingData = writeTrainingData;
    }

    public static class Results
    implements Serializable {
        private static final long serialVersionUID = 9082449588200635355L;
        public PredictedActualBinaryContingencyTable ctCodingNucleotide;
        public PredictedActualBinaryContingencyTable ctExons;
        public List<PredictedActualBinaryContingencyTable> ctStates;
        public List<PredictedActualBinaryContingencyTable> ctTransitions;
        public int correct;
        public int incorrect;
        public int perfect;
        public int imperfect;
    }
}

