/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.solver;

import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.util.Assert;
import calhoun.util.DenseIntMatrix2D;
import java.util.ArrayList;
import java.util.List;

public interface CacheProcessor {
    public void setInputData(ModelManager var1, InputSequence<?> var2);

    public void setTrainingData(ModelManager var1, List<? extends TrainingSequence<?>> var2);

    public List<? extends TrainingSequence<?>> getData();

    public double[] getFeatureSums();

    public double[][] getSequenceFeatureSums();

    public boolean[] getInvalidTransitions();

    public SolverSetup getSolverSetup();

    public FeatureEvaluation[] getFeatureEvaluations();

    public LengthFeatureEvaluation[][] getLengthFeatureEvaluations();

    public void evaluatePosition(int var1, int var2);

    public void evaluateSegmentsEndingAt(int var1, int var2);

    public static final class StatePotentials {
        public byte state;
        public byte[] potentials;
    }

    public static class SolverSetup {
        public int nFeatures;
        public int nStates;
        public int nPotentials;
        public int nTransitions;
        public int[] seqOffsets;
        public int nSeqs;
        public int longestSeq;
        public short[] transitionFrom;
        public short[] transitionTo;
        public short[] orderedPotentials;
        public int totalPositions;
        public int[] selfTransitions;
        public DenseIntMatrix2D transitionIndex;
        public byte[][] exitTransitions;
        public short[] maxStateLengths;
        public short maxLookback = 1;
        public StatePotentials[] statesWithLookback;
        public StatePotentials[] statesWithoutLookback;

        public void setup(ModelManager fm, List<? extends TrainingSequence<?>> data, boolean allPaths, short[] maxStateLengths2, boolean ignoreSemiMarkovSelfTransitions) {
            this.maxStateLengths = maxStateLengths2;
            this.initStatesWithLookback(this.maxStateLengths);
            Assert.a(this.statesWithLookback != null);
            Assert.a(this.statesWithoutLookback != null);
        }

        protected boolean allowSelf(int state) {
            return this.maxStateLengths[state] > 1;
        }

        public void initStatesWithLookback(short[] maxStateLengths) {
            ArrayList<StatePotentials> with = new ArrayList<StatePotentials>();
            ArrayList<StatePotentials> without = new ArrayList<StatePotentials>();
            this.exitTransitions = new byte[maxStateLengths.length][];
            for (int i = 0; i < maxStateLengths.length; i = (int)((byte)(i + 1))) {
                StatePotentials p = new StatePotentials();
                p.state = (byte)i;
                ArrayList<Byte> pots = new ArrayList<Byte>();
                ArrayList<Byte> exits = new ArrayList<Byte>();
                boolean length = maxStateLengths[i] > 1;
                for (int prevState = 0; prevState < maxStateLengths.length; ++prevState) {
                    int trans = this.transitionIndex.getQuick(prevState, i);
                    if (trans != -1) {
                        pots.add((byte)(trans + this.nStates));
                    }
                    if ((trans = this.transitionIndex.getQuick(i, prevState)) == -1 || prevState == i) continue;
                    exits.add((byte)(trans + this.nStates));
                }
                p.potentials = this.toByteArray(pots);
                if (length) {
                    with.add(p);
                } else {
                    without.add(p);
                }
                this.exitTransitions[i] = this.toByteArray(exits);
            }
            this.statesWithLookback = with.toArray(new StatePotentials[with.size()]);
            this.statesWithoutLookback = without.toArray(new StatePotentials[without.size()]);
        }

        private byte[] toByteArray(List<Byte> list) {
            byte[] ret = new byte[list.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = list.get(i);
            }
            return ret;
        }
    }

    public static class LengthFeatureEvaluation {
        public short lookback = (short)-1;
        public FeatureEvaluation nodeEval;
        public FeatureEvaluation[] edgeEvals;

        public LengthFeatureEvaluation(int nFeatures) {
            this.nodeEval = new FeatureEvaluation(nFeatures);
        }

        public static LengthFeatureEvaluation[][] create(StatePotentials[] statePotentials, int nLookbacks, int nFeatures) {
            LengthFeatureEvaluation[][] lookbacks = new LengthFeatureEvaluation[statePotentials.length][nLookbacks];
            for (int i = 0; i < statePotentials.length; ++i) {
                for (int j = 0; j < nLookbacks; ++j) {
                    lookbacks[i][j] = new LengthFeatureEvaluation(nFeatures);
                }
            }
            return lookbacks;
        }
    }

    public static class FeatureEvaluation {
        public short[] index;
        public float[] value;

        FeatureEvaluation(int nFeatures) {
            this.index = new short[nFeatures];
            this.value = new float[nFeatures];
            this.index[0] = -1;
        }

        public static FeatureEvaluation[] create(int nPotentials, int featureSize) {
            FeatureEvaluation[] potential = new FeatureEvaluation[nPotentials];
            for (int i = 0; i < potential.length; ++i) {
                potential[i] = new FeatureEvaluation(featureSize);
            }
            return potential;
        }
    }
}

