/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.solver;

import java.util.Iterator;

public final class RecyclingBuffer<T> {
    public T[] array;
    public int length;
    public int currentStart;

    public RecyclingBuffer(T[] arg) {
        this.currentStart = this.length;
        this.array = arg;
        this.length = this.array.length;
    }

    public final T get(int i) {
        if (i >= this.length) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        return this.array[(this.currentStart + i) % this.length];
    }

    public final void set(int i, T val) {
        if (i >= this.length) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        this.array[(this.currentStart + i) % this.length] = val;
    }

    public final T addFirst(T t) {
        this.currentStart = (this.currentStart + this.length - 1) % this.length;
        T ret = this.array[this.currentStart];
        this.array[this.currentStart] = t;
        return ret;
    }

    public final int getTotalSize() {
        return this.length;
    }

    final class RecyclingBufferIterator
    implements Iterator<T> {
        int current = 0;

        RecyclingBufferIterator() {
        }

        @Override
        public final boolean hasNext() {
            return this.current < RecyclingBuffer.this.length;
        }

        @Override
        public final T next() {
            Object ret = RecyclingBuffer.this.get(this.current);
            ++this.current;
            return ret;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

