/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.solver.check;

import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.SemiMarkovSetup;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.analysis.crf.solver.CacheProcessor;
import calhoun.analysis.crf.solver.CacheProcessorBasic;
import calhoun.analysis.crf.solver.check.FeatureCache;
import calhoun.analysis.crf.solver.check.FeatureCacheLength;
import calhoun.util.Assert;
import calhoun.util.DenseBooleanMatrix2D;
import calhoun.util.DenseIntMatrix2D;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AllSparseLengthCacheProcessor
extends CacheProcessorBasic {
    private static final Log log = LogFactory.getLog(AllSparseLengthCacheProcessor.class);
    int lookbackArraySize = -1;
    int lookbackArrayFeatureSize = -1;
    public boolean allPaths;
    short[] minStateLengths;
    boolean ignoreSemiMarkovSelfTransitions;
    boolean includeExplicitLengthEdges;
    private boolean[] invalidTransitions;
    private short[] id;
    private byte[] potentialIx;
    private float[] val;
    private int[] starts;
    private int[] lengthStarts;
    private short[] lengthLookbacks;
    private byte[] lengthPotentials;
    private short[] lengthIndexes;
    private float[] lengthVals;
    private boolean constAtStartPos;
    private int[] nonconstantStarts;

    @Override
    public void setTrainingData(ModelManager fm, List<? extends TrainingSequence<?>> data) {
        FeatureCache cache;
        super.setTrainingData(fm, data);
        this.initSequenceInfo();
        this.modelInfo.maxStateLengths = this.maxStateLengths;
        this.initTransitions(this.allPaths);
        this.evals = CacheProcessor.FeatureEvaluation.create(this.modelInfo.nPotentials, Math.max(5, this.modelInfo.nFeatures));
        if (this.maxStateLengths == null) {
            cache = new FeatureCache(fm, data, this.allPaths);
            this.modelInfo.maxLookback = 1;
        } else {
            FeatureCacheLength lenCache = new FeatureCacheLength(fm, data, this.allPaths, this.maxStateLengths, this.minStateLengths, this.ignoreSemiMarkovSelfTransitions);
            this.modelInfo.maxLookback = lenCache.maxLookback;
            this.lengthLookbacks = lenCache.lookbacks;
            this.lengthStarts = lenCache.lengthStarts;
            this.lengthPotentials = lenCache.lengthPotentials;
            this.lengthIndexes = lenCache.lengthIndexes;
            this.lengthVals = lenCache.lengthVals;
            this.modelInfo.initStatesWithLookback(this.maxStateLengths);
            if (this.lookbackArraySize == -1) {
                this.lookbackArraySize = this.modelInfo.maxLookback + 2;
            }
            if (this.lookbackArrayFeatureSize == -1) {
                this.lookbackArrayFeatureSize = Math.max(5, this.modelInfo.nFeatures);
            }
            this.lengthEvals = CacheProcessor.LengthFeatureEvaluation.create(this.modelInfo.statesWithLookback, this.lookbackArraySize, this.lookbackArrayFeatureSize);
            cache = lenCache;
        }
        this.invalidTransitions = cache.invalidTransitions;
        this.id = cache.id;
        this.potentialIx = cache.potentialIx;
        this.val = cache.val;
        this.featureSums = cache.featureSums;
        this.starts = cache.starts;
        this.evaluateConstantFeatures(false);
    }

    @Override
    public void initTransitions(boolean allPaths) {
        this.modelInfo.transitionIndex = new DenseIntMatrix2D(this.modelInfo.nStates, this.modelInfo.nStates);
        this.modelInfo.transitionIndex.assign(-1);
        this.modelInfo.selfTransitions = new int[this.modelInfo.nStates];
        Arrays.fill(this.modelInfo.selfTransitions, -1);
        DenseBooleanMatrix2D transitions = this.fm.getLegalTransitions();
        if (transitions == null || allPaths) {
            transitions = new DenseBooleanMatrix2D(this.modelInfo.nStates, this.modelInfo.nStates);
            transitions.assign(true);
        }
        int count = 0;
        for (short i = 0; i < this.modelInfo.nStates; i = (short)(i + 1)) {
            Assert.a(this.ignoreSemiMarkovSelfTransitions || !this.isSemiMarkovState(i) || !transitions.getQuick(i, i), "Self transitions are not currently allowed in the semi-Markov model.", i);
            for (int j = 0; j < this.modelInfo.nStates; j = (int)((short)(j + 1))) {
                if (!transitions.getQuick(i, j) && (i != j || !this.isSemiMarkovState(i))) continue;
                count = (short)(count + 1);
            }
        }
        this.modelInfo.nTransitions = count;
        this.modelInfo.nPotentials = this.modelInfo.nStates + this.modelInfo.nTransitions;
        this.modelInfo.orderedPotentials = new short[this.modelInfo.nPotentials];
        this.modelInfo.transitionFrom = new short[this.modelInfo.nTransitions];
        this.modelInfo.transitionTo = new short[this.modelInfo.nTransitions];
        count = 0;
        int orderedCount = 0;
        for (int i = 0; i < this.modelInfo.nStates; i = (int)((short)(i + 1))) {
            this.modelInfo.orderedPotentials[orderedCount] = i;
            ++orderedCount;
            for (int j = 0; j < this.modelInfo.nStates; j = (int)((short)(j + 1))) {
                if (!transitions.getQuick(j, i) && (i != j || !this.isSemiMarkovState(i))) continue;
                this.modelInfo.orderedPotentials[orderedCount] = (short)(this.modelInfo.nStates + count);
                ++orderedCount;
                this.modelInfo.transitionIndex.setQuick(j, i, count);
                if (i == j) {
                    this.modelInfo.selfTransitions[i] = count;
                }
                this.modelInfo.transitionFrom[count] = j;
                this.modelInfo.transitionTo[count] = i;
                count = (short)(count + 1);
            }
        }
        Assert.a(count == this.modelInfo.nTransitions);
    }

    @Override
    public boolean[] getInvalidTransitions() {
        return this.invalidTransitions;
    }

    @Override
    public double[] getFeatureSums() {
        return this.featureSums;
    }

    @Override
    public void evaluatePosition(int seq, int pos) {
        if (pos == 0 != this.constAtStartPos) {
            this.evaluateConstantFeatures(pos == 0);
        }
        int overallPos = this.modelInfo.seqOffsets[seq] + pos;
        int current = this.starts[overallPos];
        int cacheStop = this.starts[overallPos + 1];
        short cachedPotential = -1;
        float cachedVal = Float.NaN;
        int cachedId = -1;
        if (current < cacheStop) {
            cachedPotential = this.potentialIx[current];
            cachedVal = this.val[current];
            cachedId = this.id[current];
            ++current;
        }
        for (short currentPotential : this.modelInfo.orderedPotentials) {
            int currentStart = this.nonconstantStarts[currentPotential];
            CacheProcessor.FeatureEvaluation potEval = this.evals[currentPotential];
            while (cachedPotential == currentPotential) {
                potEval.index[currentStart] = cachedId;
                potEval.value[currentStart++] = cachedVal;
                if (current >= cacheStop) break;
                cachedPotential = this.potentialIx[current];
                cachedVal = this.val[current];
                cachedId = this.id[current];
                ++current;
            }
            potEval.index[currentStart] = -1;
        }
    }

    @Override
    public void evaluateSegmentsEndingAt(int seq, int pos) {
        int overallPosition = this.modelInfo.seqOffsets[seq] + pos;
        int lengthCacheStart = this.lengthStarts[overallPosition];
        int lengthCacheStop = this.lengthStarts[overallPosition + 1];
        int cachedLookback = -1;
        int cachedPotential = -1;
        if (lengthCacheStart < lengthCacheStop) {
            cachedLookback = this.lengthLookbacks[lengthCacheStart];
            cachedPotential = this.lengthPotentials[lengthCacheStart];
        }
        CacheProcessor.StatePotentials[] statesWithLookback = this.modelInfo.statesWithLookback;
        int nSemiMarkovStates = statesWithLookback.length;
        for (int stateIx = 0; stateIx < nSemiMarkovStates; ++stateIx) {
            CacheProcessor.StatePotentials statePotentials = statesWithLookback[stateIx];
            CacheProcessor.LengthFeatureEvaluation[] lookbackEvals = this.lengthEvals[stateIx];
            int currentLookback = -1;
            int lookbackIndex = -1;
            CacheProcessor.LengthFeatureEvaluation featureEval = null;
            byte node = statePotentials.state;
            int featureEvalIndex = 0;
            while (cachedLookback != -1) {
                int cachedState = cachedPotential;
                if (cachedPotential > this.modelInfo.nStates) {
                    int trans = cachedPotential - this.modelInfo.nStates;
                    cachedState = this.modelInfo.transitionTo[trans];
                }
                if (cachedState != node) break;
                if (currentLookback == -1) {
                    currentLookback = cachedLookback;
                    lookbackIndex = 0;
                    featureEval = lookbackEvals[lookbackIndex];
                    featureEval.lookback = (short)currentLookback;
                    featureEvalIndex = 0;
                } else if (currentLookback != cachedLookback) {
                    featureEval.nodeEval.index[featureEvalIndex] = -1;
                    currentLookback = cachedLookback;
                    featureEval = lookbackEvals[++lookbackIndex];
                    featureEval.lookback = (short)currentLookback;
                    featureEvalIndex = 0;
                }
                if (cachedPotential > this.modelInfo.nStates) {
                    Assert.a(this.lengthIndexes[lengthCacheStart] == -1, "ExplicitLength edge features are not supported");
                    if (featureEvalIndex == 0) {
                        featureEval.nodeEval.index[featureEvalIndex++] = -1;
                    }
                } else {
                    featureEval.nodeEval.index[featureEvalIndex] = this.lengthIndexes[lengthCacheStart];
                    featureEval.nodeEval.value[featureEvalIndex] = this.lengthVals[lengthCacheStart];
                    ++featureEvalIndex;
                }
                if (++lengthCacheStart < lengthCacheStop) {
                    cachedLookback = this.lengthLookbacks[lengthCacheStart];
                    cachedPotential = this.lengthPotentials[lengthCacheStart];
                    continue;
                }
                cachedLookback = -1;
            }
            if (currentLookback != -1) {
                featureEval.nodeEval.index[featureEvalIndex] = -1;
            }
            lookbackEvals[++lookbackIndex].lookback = (short)-1;
        }
    }

    void evaluateConstantFeatures(boolean atStartPos) {
        this.constAtStartPos = atStartPos;
        this.nonconstantStarts = new int[this.modelInfo.nPotentials];
        for (CacheProcessor.FeatureEvaluation indexArray : this.evals) {
            indexArray.index[0] = -1;
        }
        byte currentPotential = 0;
        int currentStart = 0;
        for (int current = 0; current < this.starts[0]; ++current) {
            byte cachedPotential = this.potentialIx[current];
            if (atStartPos && cachedPotential >= this.modelInfo.nStates) continue;
            if (cachedPotential != currentPotential) {
                this.evals[currentPotential].index[currentStart] = -1;
                this.nonconstantStarts[currentPotential] = currentStart;
                currentStart = 0;
                currentPotential = cachedPotential;
            }
            CacheProcessor.FeatureEvaluation potEval = this.evals[currentPotential];
            potEval.index[currentStart] = this.id[current];
            potEval.value[currentStart++] = this.val[current];
        }
        this.evals[currentPotential].index[currentStart] = -1;
        this.nonconstantStarts[currentPotential] = currentStart;
    }

    public boolean isAllPaths() {
        return this.allPaths;
    }

    public void setAllPaths(boolean allPaths) {
        this.allPaths = allPaths;
    }

    public void setSemiMarkovSetup(SemiMarkovSetup setup) {
        this.maxStateLengths = setup.getMaxLengths();
        this.minStateLengths = setup.getMinLengths();
        this.ignoreSemiMarkovSelfTransitions = setup.isIgnoreSemiMarkovSelfTransitions();
    }

    public int getLookbackArrayFeatureSize() {
        return this.lookbackArrayFeatureSize;
    }

    public void setLookbackArrayFeatureSize(int lookbackArrayFeatureSize) {
        this.lookbackArrayFeatureSize = lookbackArrayFeatureSize;
    }

    public int getLookbackArraySize() {
        return this.lookbackArraySize;
    }

    public void setLookbackArraySize(int lookbackArraySize) {
        this.lookbackArraySize = lookbackArraySize;
    }
}

