/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.solver.check;

import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.analysis.crf.solver.CacheProcessor;
import calhoun.analysis.crf.solver.check.ArrayFeatureList;
import calhoun.analysis.crf.solver.check.FeatureCache;
import calhoun.util.Assert;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FeatureCacheLength
extends FeatureCache {
    private static final Log log = LogFactory.getLog(FeatureCacheLength.class);
    public CacheProcessor.StatePotentials[] statesWithLookback;
    public CacheProcessor.StatePotentials[] statesWithoutLookback;
    public short[] maxStateLengths;
    public short[] minStateLengths;
    public int[] lengthStarts;
    public short maxLookback = 1;
    public int nLookbackFeatures;
    public short[] lookbacks;
    public byte[] lengthPotentials;
    public short[] lengthIndexes;
    public float[] lengthVals;
    int totalDummy;
    boolean featureFound = false;
    int currentFeature;

    public FeatureCacheLength(ModelManager fm, List<? extends TrainingSequence<?>> data, boolean allPaths, short[] maxStateLengths, short[] minStateLengths, boolean ignoreSemiMarkovSelfTransitions) {
        this.maxStateLengths = maxStateLengths;
        this.minStateLengths = minStateLengths;
        this.ignoreSemiMarkovSelf = ignoreSemiMarkovSelfTransitions;
        this.init(fm, data, allPaths);
        this.initStatesWithLookback(maxStateLengths);
        this.lengthStarts = new int[this.totalPositions + 1];
        this.computeLengthCache(true);
        this.nLookbackFeatures = this.currentFeature;
        this.lookbacks = new short[this.nLookbackFeatures];
        this.lengthPotentials = new byte[this.nLookbackFeatures];
        this.lengthIndexes = new short[this.nLookbackFeatures];
        this.lengthVals = new float[this.nLookbackFeatures];
        this.computeLengthCache(false);
        log.info((Object)String.format("%d length features. %d are constraints.  Max lookback %d", this.nLookbackFeatures, this.totalDummy, this.maxLookback));
    }

    @Override
    protected boolean allowSelf(int state) {
        return this.maxStateLengths[state] > 1;
    }

    void computeLengthCache(boolean estimate) {
        this.currentFeature = 0;
        ArrayFeatureList nodeFeatureList = new ArrayFeatureList(this.fm);
        ArrayFeatureList edgeFeatureList = new ArrayFeatureList(this.fm);
        for (int i = 0; i < this.nSeqs; ++i) {
            TrainingSequence seq = (TrainingSequence)this.data.get(i);
            int seqLen = seq.length();
            int lastState = -1;
            short length = 0;
            int trainingState = -1;
            boolean segmentEnd = true;
            for (int pos = 0; pos < seqLen; ++pos) {
                if (segmentEnd) {
                    if (trainingState != -1) {
                        Assert.a(length == 0 || this.maxStateLengths[trainingState] == 1 || length <= this.maxStateLengths[trainingState] && length >= this.minStateLengths[trainingState], "Seq #" + i + " Pos " + pos + " Training segment " + length + " is longer than allowed length " + this.maxStateLengths[trainingState]);
                    }
                    lastState = trainingState;
                    length = 0;
                } else {
                    length = (short)(length + 1);
                }
                trainingState = (short)seq.getY(pos);
                segmentEnd = pos == seqLen - 1 || trainingState != seq.getY(pos + 1);
                int overallPos = this.seqOffsets[i] + pos;
                this.lengthStarts[overallPos] = this.currentFeature;
                int positionIndex = overallPos * this.nPotentials;
                block2: for (CacheProcessor.StatePotentials statePotentials : this.statesWithLookback) {
                    byte currentState = statePotentials.state;
                    boolean validExit = this.checkExit(positionIndex, pos, seqLen, currentState);
                    if (!validExit) continue;
                    int selfTrans = this.transitionIndex.getQuick(currentState, currentState) + this.nStates;
                    Assert.a(selfTrans != -1);
                    short maxStateLookback = this.maxStateLengths[currentState];
                    this.maxLookback = (short)Math.max(this.maxLookback, maxStateLookback);
                    for (short lookback = 0; lookback < maxStateLookback; lookback = (short)(lookback + 1)) {
                        boolean computeNodeSums;
                        int startPos = pos - lookback;
                        int lookbackPosIndex = startPos * this.nPotentials;
                        if (lookbackPosIndex + currentState < 0 || lookbackPosIndex + currentState >= this.invalidTransitions.length) continue;
                        if (this.invalidTransitions[lookbackPosIndex + currentState] || lookback > 0 && this.invalidTransitions[lookbackPosIndex + this.nPotentials + selfTrans]) continue block2;
                        if (lookback + 1 < this.minStateLengths[currentState]) continue;
                        nodeFeatureList.clear();
                        nodeFeatureList.evaluateNodeLength(seq, pos, lookback + 1, currentState);
                        if (!nodeFeatureList.isValid()) continue;
                        boolean bl = computeNodeSums = segmentEnd && currentState == trainingState && lookback == length;
                        if (startPos == 0) {
                            this.loadCache(estimate, computeNodeSums, lookback, currentState, nodeFeatureList);
                            if (nodeFeatureList.size() != 0) continue block2;
                            this.dummyFeature(estimate, lookback, currentState);
                            continue block2;
                        }
                        boolean nodesWritten = false;
                        for (byte potential : statePotentials.potentials) {
                            short fromState;
                            if (this.invalidTransitions[lookbackPosIndex + potential] || (fromState = this.transitionFrom[potential - this.nStates]) == currentState) continue;
                            edgeFeatureList.clear();
                            edgeFeatureList.evaluateEdgeLength(seq, pos, lookback + 1, fromState, currentState);
                            if (!edgeFeatureList.isValid()) continue;
                            if (!nodesWritten) {
                                this.loadCache(estimate, computeNodeSums, lookback, currentState, nodeFeatureList);
                                nodesWritten = true;
                            }
                            this.loadCache(estimate, computeNodeSums && lastState == fromState, lookback, potential, edgeFeatureList);
                            if (edgeFeatureList.size() != 0) continue;
                            this.dummyFeature(estimate, lookback, potential);
                        }
                    }
                }
            }
        }
        this.lengthStarts[this.totalPositions] = this.currentFeature;
    }

    boolean checkExit(int positionIndex, int pos, int seqLen, int node) {
        if (this.invalidTransitions[positionIndex + node]) {
            return false;
        }
        if (pos == seqLen - 1) {
            return true;
        }
        boolean wayOut = false;
        int nextPosIndex = positionIndex + this.nPotentials;
        for (int transIndex = 0; transIndex < this.nStates; ++transIndex) {
            int trans;
            if (transIndex == node || (trans = this.transitionIndex.getQuick(node, transIndex)) == -1 || this.invalidTransitions[nextPosIndex + trans + this.nStates]) continue;
            wayOut = true;
            break;
        }
        return wayOut;
    }

    void dummyFeature(boolean estimate, short lookback, byte potential) {
        if (estimate) {
            ++this.currentFeature;
            ++this.totalDummy;
        } else {
            this.lookbacks[this.currentFeature] = lookback;
            this.lengthPotentials[this.currentFeature] = potential;
            this.lengthIndexes[this.currentFeature] = -1;
            ++this.currentFeature;
        }
    }

    void loadCache(boolean estimate, boolean computeSums, short lookback, byte potential, ArrayFeatureList featureList) {
        int size = featureList.size();
        if (estimate) {
            this.currentFeature += size;
        } else {
            for (int i = 0; i < size; ++i) {
                float val;
                short index;
                this.lookbacks[this.currentFeature] = lookback;
                this.lengthPotentials[this.currentFeature] = potential;
                this.lengthIndexes[this.currentFeature] = index = (short)featureList.getIndex(i);
                this.lengthVals[this.currentFeature] = val = (float)featureList.getValue(i);
                if (computeSums) {
                    short s = index;
                    this.featureSums[s] = this.featureSums[s] + (double)val;
                }
                ++this.currentFeature;
            }
        }
    }

    void initStatesWithLookback(short[] maxStateLengths) {
        ArrayList<CacheProcessor.StatePotentials> with = new ArrayList<CacheProcessor.StatePotentials>();
        ArrayList<CacheProcessor.StatePotentials> without = new ArrayList<CacheProcessor.StatePotentials>();
        for (int i = 0; i < maxStateLengths.length; i = (int)((byte)(i + 1))) {
            CacheProcessor.StatePotentials p = new CacheProcessor.StatePotentials();
            p.state = (byte)i;
            ArrayList<Byte> pots = new ArrayList<Byte>();
            boolean length = maxStateLengths[i] > 1;
            for (int prevState = 0; prevState < maxStateLengths.length; ++prevState) {
                int trans = this.transitionIndex.getQuick(prevState, i);
                if (trans == -1) continue;
                pots.add((byte)(trans + this.nStates));
            }
            p.potentials = this.toByteArray(pots);
            if (length) {
                with.add(p);
                continue;
            }
            without.add(p);
        }
        this.statesWithLookback = with.toArray(new CacheProcessor.StatePotentials[with.size()]);
        this.statesWithoutLookback = without.toArray(new CacheProcessor.StatePotentials[without.size()]);
    }

    private byte[] toByteArray(List<Byte> list) {
        byte[] ret = new byte[list.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = list.get(i);
        }
        return ret;
    }
}

