/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.solver.semimarkov;

import calhoun.analysis.crf.LocalPathSimilarityScore;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.analysis.crf.scoring.SimScoreMaxStateAgreement;
import calhoun.analysis.crf.solver.CacheProcessor;
import calhoun.analysis.crf.solver.LookbackBuffer;
import calhoun.analysis.crf.solver.semimarkov.CleanMaximumLikelihoodSemiMarkovGradient;
import calhoun.util.Assert;
import calhoun.util.ColtUtil;
import calhoun.util.FileUtil;
import java.util.Arrays;
import java.util.List;

public class CleanLocalScoreSemiMarkovGradient
extends CleanMaximumLikelihoodSemiMarkovGradient {
    LocalPathSimilarityScore score = new SimScoreMaxStateAgreement();
    double[][] localScoreStableCache;
    double[][] localScoreTransitionCache;
    double[][] betas;
    int[] betaNorms;
    double[][] allEdgeProb;
    double[][] allNodeProb;
    double[][] scoreAlpha;
    double[][] scoreBeta;
    double[][] semiMarkovScoreAlpha;
    double[][] semiMarkovScoreBeta;
    boolean semiMarkov;

    @Override
    public void setTrainingData(ModelManager fm, List<? extends TrainingSequence<?>> data) {
        super.setTrainingData(fm, data);
        this.betas = new double[this.modelInfo.nStates][this.modelInfo.longestSeq];
        this.betaNorms = new int[this.modelInfo.longestSeq];
        this.allEdgeProb = new double[this.modelInfo.nTransitions][this.modelInfo.longestSeq];
        this.allNodeProb = new double[this.modelInfo.nStates][this.modelInfo.longestSeq];
        this.scoreAlpha = new double[this.modelInfo.nStates][this.modelInfo.longestSeq];
        this.scoreBeta = new double[this.modelInfo.nStates][this.modelInfo.longestSeq];
        boolean bl = this.semiMarkov = this.modelInfo.maxLookback > 1;
        if (this.semiMarkov) {
            this.semiMarkovScoreAlpha = new double[this.modelInfo.nStates][this.modelInfo.longestSeq];
            this.semiMarkovScoreBeta = new double[this.modelInfo.nStates][this.modelInfo.longestSeq];
        }
        this.betaProcessor.setGlobalArrays(this.betas, this.betaNorms, this.allNodeProb, this.allEdgeProb);
        this.fillScoreCache(this.cacheProcessor.getData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double apply(double[] param, double[] grad) {
        log.debug((Object)String.format("Beginning It: %d Weights: %s", this.iter, ColtUtil.format(param)));
        this.lambda = param;
        double[] scoreFeatureProductExpectation = new double[grad.length];
        Arrays.fill(grad, 0.0);
        double result = 0.0;
        try {
            this.logs.open();
            for (int i = 0; i < this.modelInfo.nSeqs; ++i) {
                Arrays.fill(this.expects, 0.0);
                int len = this.modelInfo.seqOffsets[i + 1] - this.modelInfo.seqOffsets[i];
                this.alphaAndBetaPass(i, len);
                this.writeMarginals(i, len);
                this.scoreAlphaBeta(i, len);
                Arrays.fill(scoreFeatureProductExpectation, 0.0);
                double thisResult = this.scoreFeatureExpections(i, len, scoreFeatureProductExpectation);
                for (int j = 0; j < this.modelInfo.nFeatures; ++j) {
                    int n = j;
                    grad[n] = grad[n] + (scoreFeatureProductExpectation[j] - thisResult * this.expects[j]);
                    Assert.a(!Double.isNaN(grad[j]));
                }
                if (debug) {
                    log.debug((Object)String.format("Iter: %d Seq: %d Expected Score: %g Grad: %s Expected Features: %s Expected Product: %s", this.iter, i, thisResult, ColtUtil.format(grad), ColtUtil.format(this.expects), ColtUtil.format(scoreFeatureProductExpectation)));
                }
                result += thisResult;
            }
            for (int j = 0; j < this.modelInfo.nFeatures; ++j) {
                grad[j] = grad[j] / (double)this.modelInfo.totalPositions;
            }
            Assert.a(!Double.isNaN(result /= (double)this.modelInfo.totalPositions));
            if (debug) {
                log.debug((Object)String.format("Iter: %d Val: %g Grad: %s Weights: %s", this.iter, result, ColtUtil.format(grad), ColtUtil.format(this.lambda)));
            } else if (log.isInfoEnabled()) {
                log.debug((Object)String.format("Iter: %d Val: %g Grad: %s", this.iter, result, ColtUtil.format(grad)));
            }
            ++this.iter;
        }
        finally {
            this.logs.close();
        }
        return result;
    }

    private final double scoreFeatureExpections(int seqNum, int len, double[] scoreFeatureProductExpectation) {
        double result = 0.0;
        int seqOffset = this.modelInfo.seqOffsets[seqNum];
        this.scorePosZero(seqNum, scoreFeatureProductExpectation);
        double[] stableState = this.nextBuffer.stableState;
        Arrays.fill(stableState, 0.0);
        this.nextBuffer = this.lookbackBuffer.addFirst(this.nextBuffer);
        int prevPos = 0;
        int pos = 1;
        while (pos < len) {
            int overallPosition = seqOffset + pos;
            this.cacheProcessor.evaluatePosition(seqNum, pos);
            this.cacheMi(seqNum, this.nextBuffer.mi, stableState, this.nextBuffer.stableState, pos);
            stableState = this.nextBuffer.stableState;
            this.nextBuffer = this.lookbackBuffer.addFirst(this.nextBuffer);
            CacheProcessor.FeatureEvaluation nodeEvals = null;
            for (short potential : this.modelInfo.orderedPotentials) {
                if (potential < this.modelInfo.nStates) {
                    nodeEvals = this.evals[potential];
                    continue;
                }
                int trans = potential - this.modelInfo.nStates;
                short yprev = this.modelInfo.transitionFrom[trans];
                short y = this.modelInfo.transitionTo[trans];
                double ep = this.allEdgeProb[trans][prevPos];
                double npPrev = this.allNodeProb[yprev][prevPos];
                double np = this.allNodeProb[y][pos];
                if (!(np > 0.0) || !(npPrev > 0.0) || !(ep >= 0.0)) continue;
                double scoreExpect = ep * this.localScoreTransitionCache[trans][overallPosition];
                result += scoreExpect;
                double conditionalIn = Math.min(1.0, ep / npPrev);
                double conditionalOut = Math.min(1.0, ep / np);
                double inner = scoreExpect;
                inner += conditionalIn * this.scoreAlpha[yprev][prevPos];
                if ((inner += conditionalOut * this.scoreBeta[y][pos]) == 0.0) continue;
                CacheProcessor.FeatureEvaluation potEvals = this.evals[potential];
                short[] indices = potEvals.index;
                float[] vals = potEvals.value;
                int fCount = 0;
                short index = indices[fCount];
                while (index != -1) {
                    short s = index;
                    scoreFeatureProductExpectation[s] = scoreFeatureProductExpectation[s] + inner * (double)vals[fCount];
                    if (this.logs.expectedProductWriter != null) {
                        FileUtil.safeWrite(this.logs.expectedProductWriter, String.format("Seq: %d Pos: %d Edge: %d-%d\tFeat: %d = %g = %g + Val: %g * (s: %g * ep: %g + a: %g * ms: %g + b: %g * me: %g)\n", seqNum, pos, (int)yprev, (int)y, index, scoreFeatureProductExpectation[index], scoreFeatureProductExpectation[index] - inner * (double)vals[fCount], Float.valueOf(vals[fCount]), this.localScoreTransitionCache[trans][overallPosition], ep, this.scoreAlpha[yprev][prevPos], conditionalIn, this.scoreBeta[y][pos], conditionalOut));
                    }
                    index = indices[++fCount];
                }
                indices = nodeEvals.index;
                vals = nodeEvals.value;
                fCount = 0;
                index = indices[fCount];
                while (index != -1) {
                    short s = index;
                    scoreFeatureProductExpectation[s] = scoreFeatureProductExpectation[s] + inner * (double)vals[fCount];
                    if (this.logs.expectedProductWriter != null) {
                        FileUtil.safeWrite(this.logs.expectedProductWriter, String.format("Seq: %d Pos: %d State: %d-%d\tNode Feat: %d = %g = %g + Val: %g * (s: %g * ep: %g + a: %g * ms: %g + b: %g * me: %g)\n", seqNum, pos, (int)yprev, (int)y, index, scoreFeatureProductExpectation[index], scoreFeatureProductExpectation[index] - inner * (double)vals[fCount], Float.valueOf(vals[fCount]), this.localScoreTransitionCache[trans][overallPosition], ep, this.scoreAlpha[yprev][prevPos], conditionalIn, this.scoreBeta[y][pos], conditionalOut));
                    }
                    index = indices[++fCount];
                }
            }
            if (this.semiMarkov) {
                this.cacheProcessor.evaluateSegmentsEndingAt(seqNum, pos);
                int nSemiMarkovStates = this.modelInfo.statesWithLookback.length;
                for (int i = 0; i < nSemiMarkovStates; ++i) {
                    CacheProcessor.LengthFeatureEvaluation[] lookbacksForState = this.lengthEvals[i];
                    CacheProcessor.StatePotentials statePotentials = this.modelInfo.statesWithLookback[i];
                    byte toNode = statePotentials.state;
                    int lbIndex = 0;
                    CacheProcessor.LengthFeatureEvaluation lengthEval = lookbacksForState[lbIndex];
                    short lookback = lengthEval.lookback;
                    while (lookback != -1) {
                        double stableValue;
                        int beginPos = pos - lookback - 1;
                        Assert.a(lengthEval.edgeEvals == null);
                        double stableScore = this.localScoreStableCache[toNode][overallPosition] - this.localScoreStableCache[toNode][overallPosition - lookback];
                        double beta = this.betas[toNode][pos];
                        int betaNorm = this.betaNorms[pos];
                        LookbackBuffer segBegin = ((LookbackBuffer[])this.lookbackBuffer.array)[(this.lookbackBuffer.currentStart + lookback) % this.lookbackBuffer.length];
                        double nodeValue = stableValue = stableState[toNode] - segBegin.stableState[toNode];
                        nodeEvals = lengthEval.nodeEval;
                        short[] indices = nodeEvals.index;
                        float[] vals = nodeEvals.value;
                        int ix = 0;
                        short index = indices[ix];
                        while (index >= 0) {
                            nodeValue += (double)vals[ix] * this.lambda[index];
                            index = indices[++ix];
                        }
                        double inner = 0.0;
                        if (beginPos == -1) {
                            double segProb = beta * this.zInv * CleanLocalScoreSemiMarkovGradient.exp(this.starterAlpha[toNode] + nodeValue + (double)(50 * (betaNorm - this.zNorm)));
                            if (betaNorm == Integer.MIN_VALUE) {
                                segProb = 0.0;
                            }
                            inner += segProb * stableScore;
                            double segEndMarg = this.allNodeProb[toNode][pos] - this.allEdgeProb[this.modelInfo.selfTransitions[toNode]][pos];
                            double conditionalOut = segEndMarg > 0.0 ? CleanLocalScoreSemiMarkovGradient.minMax(segProb / segEndMarg) : 0.0;
                            inner += conditionalOut * this.semiMarkovScoreBeta[toNode][pos];
                            if (this.logs.expectedProductWriter != null) {
                                FileUtil.safeWrite(this.logs.expectedProductWriter, String.format("Seq: %d Pos: 0-%d State: %d\t Inner %g = cOut: %g * sb: %g + stabScore: %g * p: %g (b: %g * zInv %g * exp(nodeL:%g + stable: %g + FACTOR*(normB: %d + normZ: %d)))\n", seqNum, pos, toNode, inner, conditionalOut, this.semiMarkovScoreBeta[toNode][pos], stableScore, segProb, beta, this.zInv, nodeValue - stableValue, stableValue + this.starterAlpha[toNode], betaNorm, this.zNorm));
                            }
                        } else {
                            for (byte potential : statePotentials.potentials) {
                                int invalidIndex;
                                int trans = potential - this.modelInfo.nStates;
                                short fromNode = this.modelInfo.transitionFrom[trans];
                                Assert.a(lengthEval.edgeEvals == null, "Explicit length edge features not supported.");
                                if (fromNode == toNode || this.invalidTransitions[(invalidIndex = (seqOffset + beginPos + 1) * this.modelInfo.nPotentials) + potential]) continue;
                                double prevAlpha = this.alphas[beginPos][fromNode];
                                int prevAlphaNorm = this.alphaNorms[beginPos];
                                double transitionValue = segBegin.mi[trans];
                                double segProb = prevAlpha * beta * this.zInv * CleanLocalScoreSemiMarkovGradient.exp(nodeValue + transitionValue + (double)(50 * (prevAlphaNorm + betaNorm - this.zNorm)));
                                if (prevAlphaNorm == Integer.MIN_VALUE || betaNorm == Integer.MIN_VALUE) {
                                    segProb = 0.0;
                                }
                                if (Double.isNaN(segProb)) {
                                    Assert.a(false, "Bad Segment Prob. Seq ", seqNum, " Pos ", prevPos, "-", pos);
                                }
                                double segmentScore = this.localScoreTransitionCache[trans][seqOffset + beginPos + 1] + stableScore;
                                inner += segProb * segmentScore;
                                double prevSegMarg = this.allNodeProb[fromNode][beginPos] - (this.modelInfo.maxStateLengths[fromNode] > 1 ? this.allEdgeProb[this.modelInfo.selfTransitions[fromNode]][beginPos] : 0.0);
                                double conditionalIn = prevSegMarg > 0.0 ? CleanLocalScoreSemiMarkovGradient.minMax(segProb / prevSegMarg) : 0.0;
                                inner += conditionalIn * this.semiMarkovScoreAlpha[fromNode][beginPos];
                                double segEndMarg = this.allNodeProb[toNode][pos] - this.allEdgeProb[this.modelInfo.selfTransitions[toNode]][pos];
                                double conditionalOut = segEndMarg > 0.0 ? CleanLocalScoreSemiMarkovGradient.minMax(segProb / segEndMarg) : 0.0;
                                inner += conditionalOut * this.semiMarkovScoreBeta[toNode][pos];
                                if (this.logs.expectedProductWriter == null) continue;
                                FileUtil.safeWrite(this.logs.expectedProductWriter, String.format("Seq: %d Pos: %d-%d State: %d-%d\t Inner %g = cIn: %g * sa: %g + cOut: %g * sb: %g + score: %g (trans: %g + stab: %s) * p: %g (a: %g * b: %g * zInv %g * exp(nodeL:%g + stable: %g + trans: %g + FACTOR*(normA: %d + normB: %d + normZ: %d)))\n", seqNum, beginPos + 1, pos, (int)fromNode, toNode, inner, conditionalIn, this.semiMarkovScoreAlpha[fromNode][beginPos], conditionalOut, this.semiMarkovScoreBeta[toNode][pos], segmentScore, this.localScoreTransitionCache[trans][seqOffset + beginPos + 1], stableScore, segProb, prevAlpha, beta, this.zInv, nodeValue - stableValue, stableValue, transitionValue, prevAlphaNorm, betaNorm, this.zNorm));
                            }
                        }
                        CacheProcessor.FeatureEvaluation lengthNodeEvals = lengthEval.nodeEval;
                        indices = lengthNodeEvals.index;
                        vals = lengthNodeEvals.value;
                        ix = 0;
                        index = indices[ix];
                        while (index >= 0) {
                            short s = index;
                            scoreFeatureProductExpectation[s] = scoreFeatureProductExpectation[s] + inner * (double)vals[ix];
                            if (this.logs.expectedProductWriter != null) {
                                FileUtil.safeWrite(this.logs.expectedProductWriter, String.format("Seq: %d Pos: %d-%d State: %d\tFeat: %d = %g = %g + Val: %g * Inner: %g\n", seqNum, beginPos + 1, pos, toNode, index, scoreFeatureProductExpectation[index], scoreFeatureProductExpectation[index] - inner * (double)vals[ix], Float.valueOf(vals[ix]), inner));
                            }
                            index = indices[++ix];
                        }
                        Assert.a(lengthEval.edgeEvals == null, "Explicit length edges are not supported.");
                        lengthEval = lookbacksForState[++lbIndex];
                        lookback = lengthEval.lookback;
                    }
                }
            }
            prevPos = pos++;
        }
        return result;
    }

    void scorePosZero(int seqNum, double[] scoreFeatureProductExpectation) {
        this.cacheProcessor.evaluatePosition(seqNum, 0);
        for (int state = 0; state < this.modelInfo.nStates; ++state) {
            double inner = this.scoreBeta[state][0];
            CacheProcessor.FeatureEvaluation potEvals = this.evals[state];
            short[] indices = potEvals.index;
            float[] vals = potEvals.value;
            int fCount = 0;
            short index = indices[fCount];
            while (index != -1) {
                short s = index;
                scoreFeatureProductExpectation[s] = scoreFeatureProductExpectation[s] + inner * (double)vals[fCount];
                if (this.logs.expectedProductWriter != null) {
                    FileUtil.safeWrite(this.logs.expectedProductWriter, String.format("Seq: %d Pos: 0 State: %d\tFeat: %d = %g = %g + Val: %g * Beta[%d][%d]: %g:\n", seqNum, state, index, scoreFeatureProductExpectation[index], scoreFeatureProductExpectation[index] - inner * (double)vals[fCount], Float.valueOf(vals[fCount]), 0, state, inner));
                }
                index = indices[++fCount];
            }
        }
        if (this.semiMarkov) {
            this.cacheProcessor.evaluateSegmentsEndingAt(seqNum, 0);
            int nSemiMarkovStates = this.modelInfo.statesWithLookback.length;
            for (int i = 0; i < nSemiMarkovStates; ++i) {
                CacheProcessor.LengthFeatureEvaluation[] lookbacksForState = this.lengthEvals[i];
                CacheProcessor.LengthFeatureEvaluation lengthEval = lookbacksForState[0];
                if (lengthEval.lookback == -1) continue;
                Assert.a(lengthEval.lookback == 0);
                CacheProcessor.StatePotentials statePotentials = this.modelInfo.statesWithLookback[i];
                byte state = statePotentials.state;
                double inner = this.semiMarkovScoreBeta[state][0];
                short[] indices = lengthEval.nodeEval.index;
                float[] vals = lengthEval.nodeEval.value;
                int fCount = 0;
                short index = indices[fCount];
                while (index != -1) {
                    short s = index;
                    scoreFeatureProductExpectation[s] = scoreFeatureProductExpectation[s] + inner * (double)vals[fCount];
                    if (this.logs.expectedProductWriter != null) {
                        FileUtil.safeWrite(this.logs.expectedProductWriter, String.format("Seq: %d Pos: 0 State: %d\tLen. Feat: %d = %g = %g + Val: %g * Beta[%d][%d]: %g:\n", seqNum, state, index, scoreFeatureProductExpectation[index], scoreFeatureProductExpectation[index] - inner * (double)vals[fCount], Float.valueOf(vals[fCount]), 0, state, inner));
                    }
                    index = indices[++fCount];
                }
                Assert.a(lookbacksForState[1].lookback == -1);
            }
        }
    }

    private final void scoreAlphaBeta(int seqNum, int len) {
        double update;
        double conditional;
        double np;
        double ep;
        short y;
        short yprev;
        int trans;
        int y2;
        int seqOffset = this.modelInfo.seqOffsets[seqNum];
        int pos = len - 1;
        for (y2 = 0; y2 < this.modelInfo.nStates; ++y2) {
            Arrays.fill(this.scoreBeta[y2], 0.0);
            if (!this.semiMarkov) continue;
            Arrays.fill(this.semiMarkovScoreBeta[y2], 0.0);
        }
        int prevPos = len - 2;
        while (prevPos >= 0) {
            for (trans = 0; trans < this.modelInfo.nTransitions; ++trans) {
                yprev = this.modelInfo.transitionFrom[trans];
                y = this.modelInfo.transitionTo[trans];
                ep = this.allEdgeProb[trans][prevPos];
                np = this.allNodeProb[y][pos];
                if (!(np > 0.0) || !(ep >= 0.0)) continue;
                conditional = Math.min(1.0, ep / np);
                update = ep * this.localScoreTransitionCache[trans][seqOffset + pos] + conditional * this.scoreBeta[y][pos];
                double[] dArray = this.scoreBeta[yprev];
                int n = prevPos;
                dArray[n] = dArray[n] + update;
                if (this.modelInfo.maxStateLengths[y] <= 1 || y == yprev) continue;
                double[] dArray2 = this.semiMarkovScoreBeta[yprev];
                int n2 = prevPos;
                dArray2[n2] = dArray2[n2] + update;
            }
            pos = prevPos--;
        }
        prevPos = 0;
        for (y2 = 0; y2 < this.modelInfo.nStates; ++y2) {
            Arrays.fill(this.scoreAlpha[y2], 0.0);
            if (!this.semiMarkov) continue;
            Arrays.fill(this.semiMarkovScoreAlpha[y2], 0.0);
        }
        pos = 1;
        while (pos < len - 1) {
            for (trans = 0; trans < this.modelInfo.nTransitions; ++trans) {
                double nodeMarg;
                yprev = this.modelInfo.transitionFrom[trans];
                y = this.modelInfo.transitionTo[trans];
                ep = this.allEdgeProb[trans][prevPos];
                np = this.allNodeProb[yprev][prevPos];
                if (!(np > 0.0) || !(ep >= 0.0)) continue;
                conditional = Math.min(1.0, ep / np);
                update = conditional * this.scoreAlpha[yprev][prevPos];
                double[] dArray = this.scoreAlpha[y];
                int n = pos;
                dArray[n] = dArray[n] + (update += ep * this.localScoreTransitionCache[trans][seqOffset + pos]);
                if (this.modelInfo.maxStateLengths[y] > 1 && (nodeMarg = this.allNodeProb[y][pos]) > 0.0) {
                    double outConditional = CleanLocalScoreSemiMarkovGradient.minMax((nodeMarg - this.allEdgeProb[this.modelInfo.selfTransitions[y]][pos]) / nodeMarg);
                    double[] dArray3 = this.semiMarkovScoreAlpha[y];
                    int n3 = pos;
                    dArray3[n3] = dArray3[n3] + update * outConditional;
                }
                if (this.logs.scoreAlphaWriter == null) continue;
                FileUtil.safeWrite(this.logs.scoreAlphaWriter, String.format("Seq: %d alpha[%d][%d] = %g = %g + Pr: %g * alpha[%d][%d] %g + Pr: %g * Score: %g\n", seqNum, pos, (int)y, this.scoreAlpha[y][pos], this.scoreAlpha[y][pos] - update, ep / this.allNodeProb[yprev][prevPos], prevPos, (int)yprev, this.scoreAlpha[yprev][prevPos], ep, this.localScoreTransitionCache[trans][seqOffset + pos]));
            }
            prevPos = pos++;
        }
    }

    void fillScoreCache(List<? extends TrainingSequence<?>> data) {
        this.localScoreStableCache = new double[this.modelInfo.nStates][this.modelInfo.totalPositions];
        this.localScoreTransitionCache = new double[this.modelInfo.nTransitions][this.modelInfo.totalPositions];
        int overallPosition = 0;
        for (int i = 0; i < data.size(); ++i) {
            TrainingSequence<?> seq = data.get(i);
            ++overallPosition;
            for (int pos = 1; pos < seq.length(); ++pos) {
                for (int transition = 0; transition < this.modelInfo.nTransitions; ++transition) {
                    double localScore;
                    short from = this.modelInfo.transitionFrom[transition];
                    short to = this.modelInfo.transitionTo[transition];
                    this.localScoreTransitionCache[transition][overallPosition] = localScore = this.score.evaluate(from, to, seq, pos);
                    if (from != to) continue;
                    this.localScoreStableCache[to][overallPosition] = this.localScoreStableCache[to][overallPosition - 1] + localScore;
                }
                ++overallPosition;
            }
        }
    }

    private static final double minMax(double val) {
        double ret;
        double d = val <= 0.0 ? 0.0 : (ret = val >= 1.0 ? 1.0 : val);
        if (Double.isNaN(ret)) {
            Assert.a(false, "Min max called on " + val);
        }
        return ret;
    }

    private final void writeMarginals(int i, int len) {
        if (this.logs.marginalsWriter != null) {
            for (int pos = 0; pos < len; ++pos) {
                FileUtil.safeWrite(this.logs.marginalsWriter, String.format("Seq %d Pos %d -", i, pos));
                for (short potential : this.modelInfo.orderedPotentials) {
                    if (potential < this.modelInfo.nStates) {
                        FileUtil.safeWrite(this.logs.marginalsWriter, String.format(" State %d: %e", potential, this.allNodeProb[potential][pos]));
                        continue;
                    }
                    int trans = potential - this.modelInfo.nStates;
                    FileUtil.safeWrite(this.logs.marginalsWriter, String.format(" Edge %d-%d: %e", this.modelInfo.transitionFrom[trans], this.modelInfo.transitionTo[trans], this.allEdgeProb[trans][pos]));
                }
                FileUtil.safeWrite(this.logs.marginalsWriter, "\n");
            }
        }
    }

    public LocalPathSimilarityScore getScore() {
        return this.score;
    }

    public void setScore(LocalPathSimilarityScore score) {
        this.score = score;
    }

    public String getScoreAlphaFile() {
        return this.logs.scoreAlphaFile;
    }

    public void setScoreAlphaFile(String scoreAlphaFile) {
        this.logs.scoreAlphaFile = scoreAlphaFile;
    }

    public String getExpectedProductFile() {
        return this.logs.expectedProductFile;
    }

    public void setExpectedProductFile(String expectedProductFile) {
        this.logs.expectedProductFile = expectedProductFile;
    }

    public String getMarginalsFile() {
        return this.logs.marginalsFile;
    }

    public void setMarginalsFile(String marginalsFile) {
        this.logs.marginalsFile = marginalsFile;
    }
}

