/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.statistics;

import calhoun.util.Assert;

public class GammaDistribution {
    private static double[] bern = new double[]{1.0, -0.5, 0.16666666666666666, 0.0, -0.03333333333333333, 0.0, 0.023809523809523808, 0.0, -0.03333333333333333, 0.0, 0.07575757575757576, 0.0, -0.2531135531135531, 0.0, 1.1666666666666667};

    public static double lgamma(double p, double lambda, double x) {
        Assert.a(lambda > 0.0);
        Assert.a(x > 0.0);
        Assert.a(p > 0.0);
        double ret = (p - 1.0) * Math.log(x) - x * lambda + p * Math.log(lambda) - GammaDistribution.lgamma(p);
        if (Double.isNaN(ret)) {
            Assert.a(false, "  pow1=" + Math.pow(x, p - 1.0) + "  exp1=" + Math.exp(-x * lambda) + "  pow2=" + Math.pow(lambda, p) + "  gamma=" + GammaDistribution.gamma(p));
        }
        return ret;
    }

    public static double gamma(double p, double lambda, double x) {
        Assert.a(lambda > 0.0);
        Assert.a(x > 0.0);
        Assert.a(p > 0.0);
        double lret = GammaDistribution.lgamma(p, lambda, x);
        double ret = Math.exp(lret);
        Assert.a(ret != Double.NEGATIVE_INFINITY && ret != Double.POSITIVE_INFINITY && !Double.isNaN(ret));
        return ret;
    }

    public static double gamma(double x) {
        Assert.a(x > 0.0);
        double y = GammaDistribution.lgamma(x);
        return Math.exp(y);
    }

    private static double lgamma(double x) {
        Assert.a(x > 0.0);
        double l2pi = Math.log(Math.PI * 2);
        if (x < 10.0) {
            return GammaDistribution.lgamma(x + 1.0) - Math.log(x);
        }
        double y = (x - 0.5) * Math.log(x) - x + 0.5 * l2pi;
        double zz = 1.0 / x;
        int k = 1;
        while (2 * k <= bern.length) {
            int t = 2 * k;
            double term = bern[2 * k] / (double)(t * (t - 1));
            y += (term *= zz);
            zz /= x * x;
            ++k;
        }
        return y;
    }

    public static double[] mleg(double a1, double a2) {
        double fval;
        int iter;
        double s = a2 - Math.log(a1);
        Assert.a(s <= 0.0, "log E(x) < E(log (x)) \n");
        double pp = -s;
        for (iter = 1; iter <= 30 && !((fval = s - (GammaDistribution.psi(pp) - Math.log(pp))) < 0.0); ++iter) {
            pp *= 2.0;
        }
        for (iter = 1; iter <= 30 && !((fval = s - (GammaDistribution.psi(pp) - Math.log(pp))) > 0.0); ++iter) {
            pp /= 2.0;
        }
        for (iter = 1; iter <= 10; ++iter) {
            fval = GammaDistribution.psi(pp) - Math.log(pp);
            double top = s - fval;
            double bot = GammaDistribution.tau(pp) - 1.0 / pp;
            pp += top / bot;
        }
        double ll = pp / a1;
        return new double[]{pp, ll};
    }

    private static double psi(double x) {
        Assert.a(x > 0.0, "(psi) bad value: " + x);
        Assert.a(bern.length == 15);
        if (x < 10.0) {
            return GammaDistribution.psi(x + 1.0) - 1.0 / x;
        }
        double y = Math.log(x) - 1.0 / (2.0 * x);
        double zz = 1.0;
        int k = 1;
        while (2 * k < bern.length) {
            double term = bern[2 * k] / (double)(2 * k);
            y -= (term *= (zz /= x * x));
            ++k;
        }
        return y;
    }

    private static double tau(double x) {
        Assert.a(x > 0.0, "(tau) bad value: " + x);
        if (x < 10.0) {
            return GammaDistribution.tau(x + 1.0) + 1.0 / (x * x);
        }
        double y = 1.0 / x + 1.0 / (2.0 * x * x);
        double zz = 1.0 / x;
        int k = 1;
        while (2 * k < bern.length) {
            double term = bern[2 * k] / (double)(2 * k);
            term *= (zz /= x * x);
            y -= (term *= -((double)(2 * k)));
            ++k;
        }
        return y;
    }
}

