/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.statistics;

import calhoun.util.Assert;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class PredictedActualBinaryContingencyTable
implements Serializable {
    private static final long serialVersionUID = 557844841355570852L;
    private int tp = 0;
    private int fp = 0;
    private int fn = 0;
    private int tn = 0;
    private boolean frozen = false;

    public void set(int tp, int fp, int fn, int tn) {
        Assert.a(!this.frozen);
        this.tp = tp;
        this.fp = fp;
        this.fn = fn;
        this.tn = tn;
        this.frozen = true;
    }

    public void set(int tp, int fp, int fn) {
        Assert.a(!this.frozen);
        this.tp = tp;
        this.fp = fp;
        this.fn = fn;
        this.tn = -1;
        this.frozen = true;
    }

    public void forgetTN() {
        Assert.a(!this.frozen);
        Assert.a(this.tn == 0);
        this.tn = -1;
    }

    public void incrementTP() {
        Assert.a(!this.frozen);
        ++this.tp;
    }

    public void incrementFP() {
        Assert.a(!this.frozen);
        ++this.fp;
    }

    public void incrementFN() {
        Assert.a(!this.frozen);
        ++this.fn;
    }

    public void incrementTN() {
        Assert.a(!this.frozen);
        Assert.a(this.tn >= 0);
        ++this.tn;
    }

    public void increment(boolean predicted, boolean actual) {
        Assert.a(!this.frozen);
        if (predicted && actual) {
            ++this.tp;
        }
        if (predicted && !actual) {
            ++this.fp;
        }
        if (!predicted && actual) {
            ++this.fn;
        }
        if (!predicted && !actual) {
            Assert.a(this.tn >= 0);
            ++this.tn;
        }
    }

    public void freeze() {
        this.frozen = true;
    }

    public int getTP() {
        Assert.a(this.frozen);
        return this.tp;
    }

    public int getFP() {
        Assert.a(this.frozen);
        return this.fp;
    }

    public int getFN() {
        Assert.a(this.frozen);
        return this.fn;
    }

    public int getTN() {
        Assert.a(this.frozen);
        Assert.a(this.tn >= 0);
        return this.tn;
    }

    public int ap() {
        Assert.a(this.frozen);
        return this.tp + this.fn;
    }

    public int an() {
        Assert.a(this.frozen);
        Assert.a(this.tn >= 0);
        return this.fp + this.tn;
    }

    public int pp() {
        Assert.a(this.frozen);
        return this.tp + this.fp;
    }

    public int pn() {
        Assert.a(this.frozen);
        Assert.a(this.tn >= 0);
        return this.tn + this.fn;
    }

    private boolean splitMargins() {
        if (this.tn >= 0) {
            if (this.tp + this.fn <= 0) {
                return false;
            }
            if (this.tn + this.fp <= 0) {
                return false;
            }
            if (this.tp + this.fp <= 0) {
                return false;
            }
            if (this.tn + this.fn <= 0) {
                return false;
            }
        } else {
            if (this.tp + this.fn <= 0) {
                return false;
            }
            if (this.tp + this.fp <= 0) {
                return false;
            }
        }
        return true;
    }

    public double correlationCoefficient() {
        Assert.a(this.frozen);
        Assert.a(this.splitMargins());
        double num = this.tp * this.tn - this.fn * this.fp;
        double den2 = (double)(this.tp + this.fn) * (double)(this.tn + this.fp) * (double)(this.tp + this.fp) * (double)(this.tn + this.fn);
        double cc = num / Math.sqrt(den2);
        return cc;
    }

    public double averageConditionalProbability() {
        Assert.a(this.frozen);
        Assert.a(this.splitMargins());
        double acp = 0.0;
        acp += (double)this.tp / (double)(this.tp + this.fn);
        acp += (double)this.tp / (double)(this.tp + this.fp);
        acp += (double)this.tn / (double)(this.tn + this.fp);
        acp += (double)this.tn / (double)(this.tn + this.fn);
        return acp /= 4.0;
    }

    public double approximateCorrelation() {
        Assert.a(this.frozen);
        return 2.0 * (this.averageConditionalProbability() - 0.5);
    }

    public double averageSensitivitySpecificity() {
        Assert.a(this.frozen);
        return 0.5 * (this.sensitivity() + this.specificity());
    }

    public double sensitivity() {
        Assert.a(this.frozen);
        Assert.a(this.tp + this.fn > 0);
        return (double)this.tp / (double)(this.tp + this.fn);
    }

    public double specificity() {
        Assert.a(this.frozen);
        Assert.a(this.tp + this.fp > 0);
        return (double)this.tp / (double)(this.tp + this.fp);
    }

    public String summarize() {
        String ret = "";
        DecimalFormat d3 = new DecimalFormat();
        ((NumberFormat)d3).setMinimumFractionDigits(3);
        ((NumberFormat)d3).setMaximumFractionDigits(3);
        if (this.tn >= 0) {
            ret = ret + "( TP=" + this.tp + ", FP=" + this.fp + ", FN=" + this.fn + ", TN=" + this.tn + " ) ";
            ret = ret + "( AP=" + this.ap() + ", AN=" + this.an() + ", PP=" + this.pp() + ", PN=" + this.pn() + " ) ";
            if (this.splitMargins()) {
                ret = ret + "( CC=" + d3.format(this.correlationCoefficient()) + " ) ";
                ret = ret + "( ACP=" + d3.format(this.averageConditionalProbability()) + " ) ";
                ret = ret + "( AC=" + d3.format(this.approximateCorrelation()) + " ) ";
                ret = ret + "( sens=" + d3.format(this.sensitivity()) + ", spec=" + d3.format(this.specificity()) + ", avSS=" + d3.format(this.averageSensitivitySpecificity()) + " ) ";
            } else {
                ret = ret + "( margins not split ) ";
            }
        } else {
            ret = ret + "( TP=" + this.tp + ", FP=" + this.fp + ", FN=" + this.fn + " ) ";
            ret = ret + "( AP=" + this.ap() + ", PP=" + this.pp() + " )";
            ret = this.splitMargins() ? ret + "( sens=" + d3.format(this.sensitivity()) + ", spec=" + d3.format(this.specificity()) + ", avSS=" + d3.format(this.averageSensitivitySpecificity()) + " ) " : ret + "( margins not split ) ";
        }
        return ret;
    }
}

