/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.test;

import calhoun.analysis.crf.Conrad;
import calhoun.analysis.crf.executables.InputSequenceSubsetter;
import calhoun.analysis.crf.executables.PartitionRandomlyTrainTestFiles;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.util.AbstractTestCase;
import calhoun.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CRFIOTest
extends AbstractTestCase {
    private static final Log log = LogFactory.getLog(CRFIOTest.class);
    boolean debug = log.isDebugEnabled();

    public void testArrayReaderInt() throws Exception {
        String fileName = "test/input/test_tabbed_array_reader_int.txt";
        String[][] s = FileUtil.readFlatFile(fileName);
        CRFIOTest.assertEquals((String)s[0][0], (String)"14");
        CRFIOTest.assertEquals((String)s[0][1], (String)"276470");
    }

    public void testInputSequenceReader() throws Exception {
        String configFile = "test/input/test_subsetting_configfile.xml";
        String inputFile = "test/input/test_subsetting_inputfile.txt";
        String outputFile = "test/working/test_subsetting_output.txt";
        Conrad c = new Conrad(configFile);
        List<TrainingSequence<?>> t = c.getInputHandler().readTrainingData(inputFile);
        CRFIOTest.assertEquals((int)t.size(), (int)1);
        CRFIOTest.assertEquals((int)t.get(0).length(), (int)7560);
        ArrayList<InputSequence> s = new ArrayList<InputSequence>();
        s.add(t.get(0).subSequence(1, 10));
        s.add(t.get(0).subSequence(1, 20));
        c.getInputHandler().writeTrainingData(outputFile, s);
        List<TrainingSequence<?>> u = c.getInputHandler().readTrainingData(outputFile);
        CRFIOTest.assertEquals((int)2, (int)u.size());
        CRFIOTest.assertEquals((int)10, (int)u.get(0).length());
        CRFIOTest.assertEquals((int)20, (int)u.get(1).length());
    }

    public void testInputSequenceFileReader() throws Exception {
        String configFile = "test/input/inputFilesTest/test_subsetting_configfile.xml";
        String configFile2 = "test/input/inputFilesTest/test_subsetting_configfile2.xml";
        String inputFile = "test/input/inputFilesTest";
        String outputFile = "test/working/test_file_subsetting_output.txt";
        String matchFile = "test/output/test_file_subsetting_output.txt";
        Conrad c = new Conrad(configFile);
        List<TrainingSequence<?>> t = c.getInputHandler().readTrainingData(inputFile);
        CRFIOTest.assertEquals((int)2, (int)t.size());
        CRFIOTest.assertEquals((int)7560, (int)t.get(0).length());
        ArrayList<InputSequence> s = new ArrayList<InputSequence>();
        s.add(t.get(0).subSequence(1, 10));
        s.add(t.get(0).subSequence(1, 20));
        s.add(t.get(1).subSequence(1, 10));
        Conrad c2 = new Conrad(configFile2);
        c2.getInputHandler().writeTrainingData(outputFile, s);
        this.assertFilesMatch(matchFile, outputFile);
    }

    public void testInputSequenceSubsetterCommandLine() throws Exception {
        String configFile = "test/input/test_subsetting_configfile.xml";
        String inputFile = "test/input/test_subsetting_inputfile.txt";
        String regionsFile = "test/input/test_subsetting_regions.txt";
        String outputFile = "test/working/test_subsetting_output.txt";
        InputSequenceSubsetter.main(new String[]{configFile, inputFile, regionsFile, "5", outputFile, "0"});
        Conrad c = new Conrad(configFile);
        List<TrainingSequence<?>> u = c.getInputHandler().readTrainingData(outputFile);
        CRFIOTest.assertEquals((int)u.size(), (int)2);
        CRFIOTest.assertEquals((int)u.get(0).length(), (int)15);
        CRFIOTest.assertEquals((int)u.get(1).length(), (int)30);
    }

    public void testInputSequenceSubsetterCommandLineSeparateFiles() throws Exception {
        String configFile = "test/input/inputFilesTest/test_subsetting_configfile.xml";
        String inputFile = "test/input/inputFilesTest";
        String regionsFile = "test/input/test_subsetting_regions.txt";
        String outputFile = "test/working/test_subsetting_output_files";
        File f = new File(outputFile);
        f.mkdirs();
        InputSequenceSubsetter.main(new String[]{configFile, inputFile, regionsFile, "5", outputFile, "0"});
        this.assertFilesMatch("test/working/test_subsetting_output_files/hidden.dat", "test/output/test_subsetting_output_files/hidden.dat");
        this.assertFilesMatch("test/working/test_subsetting_output_files/ref.dat", "test/output/test_subsetting_output_files/ref.dat");
        this.assertFilesMatch("test/working/test_subsetting_output_files/name.dat", "test/output/test_subsetting_output_files/name.dat");
        this.assertFilesMatch("test/working/test_subsetting_output_files/aln.dat", "test/output/test_subsetting_output_files/aln.dat");
    }

    public void testInputSequenceSubsetterCommandLineForcingGenic() throws Exception {
        String configFile = "test/input/test_subsetting_configfile.xml";
        String inputFile = "test/input/test_subsetting_inputfile.txt";
        String regionsFile = "test/input/test_subsetting_regions.txt";
        String outputFile = "test/working/test_subsetting_output.txt";
        InputSequenceSubsetter.main(new String[]{configFile, inputFile, regionsFile, "5", outputFile, "1"});
        Conrad c = new Conrad(configFile);
        List<TrainingSequence<?>> u = c.getInputHandler().readTrainingData(outputFile);
        CRFIOTest.assertEquals((int)u.size(), (int)0);
    }

    public void testTrainTestSplitCommandLine() throws Exception {
        String configFile = "test/input/test_subsetting_configfile.xml";
        String inputFile = "test/input/test_traintest_split.txt";
        String nTrainArg = "1";
        String outputTrain = "test/working/test_subsetting_output.txt";
        String outputTest = "test/working/test_subsetting_output.txt";
        PartitionRandomlyTrainTestFiles.main(new String[]{configFile, inputFile, nTrainArg, outputTrain, outputTest});
        Conrad c = new Conrad(configFile);
        List<TrainingSequence<?>> u = c.getInputHandler().readTrainingData(outputTest);
        CRFIOTest.assertEquals((int)u.size(), (int)2);
    }
}

