/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.test;

import calhoun.analysis.crf.Conrad;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.CompositeInput;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.analysis.crf.solver.StandardOptimizer;
import calhoun.analysis.crf.test.ZeroOrderManager;
import calhoun.util.AbstractTestCase;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CRFTest
extends AbstractTestCase {
    private static final Log log = LogFactory.getLog(CRFTest.class);

    public void testFullCycle() throws Exception {
        Conrad crf = ZeroOrderManager.getCRF();
        List<TrainingSequence<?>> data = crf.getInputHandler().readTrainingData("test/input/zeroOrderTest.txt");
        CRFTest.assertEquals((int)data.size(), (int)3);
        crf.train(data);
        log.info((Object)crf.printWeights());
        crf.test(data, "test/working/zeroOrderPredicted.txt");
        this.assertFilesMatch("test/output/zeroOrderPredicted.txt", "test/working/zeroOrderPredicted.txt");
    }

    public void testSpringConfig() throws Exception {
        Conrad c = new Conrad("test/input/configTest.xml");
        ModelManager cm = c.getModel();
        CRFTest.assertEquals((int)7, (int)cm.getNumStates());
        CRFTest.assertEquals((String)"exon1", (String)cm.getStateName(1));
        CompositeInput.LegacyInputHandler seq = (CompositeInput.LegacyInputHandler)c.getInputHandler();
        CRFTest.assertNotNull((Object)seq);
        StandardOptimizer opt = (StandardOptimizer)c.getOptimizer();
        CRFTest.assertEquals((int)1, (int)opt.getMaxIters());
    }

    public void testToolkitMainSeparateTraining() throws Exception {
        Conrad.main(new String[]{"trainFeatures", "test/input/zeroOrderLBFGS.xml", "test/input/zeroOrderTest.txt", "test/working/zeroModelSep.ser"});
        Conrad.main(new String[]{"trainWeights", "test/working/zeroModelSep.ser", "test/input/zeroOrderTest.txt", "test/working/zeroModelSep2.ser"});
        Conrad.main(new String[]{"test", "test/working/zeroModelSep2.ser", "test/input/zeroOrderTest.txt", "test/working/zeroOrderSepMainPredicted.txt"});
    }
}

