/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.test;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.CacheStrategySpec;
import calhoun.analysis.crf.Conrad;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerEdge;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.util.AbstractTestCase;
import java.util.List;

public class ConstraintTest
extends AbstractTestCase {
    public void testViterbiConstraints() throws Exception {
        Conrad r = new Conrad("test/input/constraintModel.xml");
        r.trainFeatures("test/input/shortTrain.tricycle13.txt");
        r.setWeights(new double[]{1.0});
        ConstraintTest.assertEquals((String)"Edge Feature", (String)r.getModel().getFeatureName(0));
        r.test("test/input/shortTrain.tricycle13.txt", "test/working/constraintTest.txt");
        this.assertFilesMatch("test/output/constraintTest.txt", "test/working/constraintTest.txt");
    }

    public void testConstraintsDifferentCaches() throws Exception {
        Conrad r = new Conrad("test/input/constraintModel.xml");
        r.train("test/input/genesShorterTrain.txt");
        double normWeight = r.getWeights()[0];
        r = new Conrad("test/input/constraintModelCache.xml");
        r.train("test/input/genesShorterTrain.txt");
        ConstraintTest.assertEquals((double)normWeight, (double)r.getWeights()[0], (double)1.0E-4);
    }

    public static class FixedEdges
    extends AbstractFeatureManager
    implements FeatureManagerEdge {
        private static final long serialVersionUID = 5995552526733022868L;
        int startIx;
        int[] clusters = new int[]{0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4};

        public void evaluateEdge(InputSequence seq, int pos, int prevState, int state, FeatureList result) {
            result.addFeature(this.startIx, this.clusters[state] == this.clusters[prevState] ? Math.log(0.3) : Math.log(0.7));
        }

        @Override
        public String getFeatureName(int featureIndex) {
            return "Edge Feature";
        }

        @Override
        public int getNumFeatures() {
            return 1;
        }

        @Override
        public void train(int startingIndex, ModelManager modelInfo, List data) {
            this.startIx = startingIndex;
        }

        @Override
        public CacheStrategySpec getCacheStrategy() {
            return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.UNSPECIFIED);
        }
    }
}

