/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.test;

import calhoun.analysis.crf.Conrad;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.features.tricycle13.KmerFeatures;
import calhoun.analysis.crf.io.InputHandlerInterleaved;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.StringInput;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.analysis.crf.solver.check.ArrayFeatureList;
import calhoun.analysis.crf.test.ZeroOrderManager;
import calhoun.util.AbstractTestCase;
import calhoun.util.Assert;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FeatureTest
extends AbstractTestCase {
    private static final Log log = LogFactory.getLog(FeatureTest.class);
    boolean debug = log.isDebugEnabled();

    public void testKmerFeatures() throws Exception {
        List<? extends TrainingSequence<?>> data = new InputHandlerInterleaved(new StringInput()).readTrainingData("test/input/zeroOrderTest.txt");
        KmerFeatures kf = new KmerFeatures();
        kf.setRareThreshold(0);
        kf.train(0, (ModelManager)new ZeroOrderManager(), (List<? extends TrainingSequence<? extends Character>>)data);
        FeatureTest.assertEquals((int)2, (int)kf.getNumFeatures());
        FeatureTest.assertEquals((double)this.expectedProb(53, 30), (double)kf.getKmerProb(0, "A", 0), (double)0.01);
        FeatureTest.assertEquals((double)this.expectedProb(30, 53), (double)kf.getKmerProb(0, "A", 1), (double)0.01);
        FeatureTest.assertEquals((double)this.expectedProb(55, 38), (double)kf.getKmerProb(0, "T", 0), (double)0.01);
        FeatureTest.assertEquals((double)this.expectedProb(38, 55), (double)kf.getKmerProb(0, "T", 1), (double)0.01);
        FeatureTest.assertEquals((double)this.expectedProb(21, 91), (double)kf.getKmerProb(0, "C", 0), (double)0.01);
        FeatureTest.assertEquals((double)this.expectedProb(91, 21), (double)kf.getKmerProb(0, "C", 1), (double)0.01);
        FeatureTest.assertEquals((double)this.expectedProb(23, 82), (double)kf.getKmerProb(0, "G", 0), (double)0.01);
        FeatureTest.assertEquals((double)this.expectedProb(82, 23), (double)kf.getKmerProb(0, "G", 1), (double)0.01);
    }

    double expectedProb(int a, int b) {
        return Math.log((float)(a + 1) / (float)(a + b + 2));
    }

    public void testFeatureNames() throws Exception {
        List<? extends TrainingSequence<?>> data = new InputHandlerInterleaved(new StringInput()).readTrainingData("test/input/zeroOrderTest.txt");
        Conrad runner = ZeroOrderManager.getCRF();
        runner.trainFeatures(data);
        FeatureTest.assertEquals((String)"Start.lowGC", (String)runner.getModel().getFeatureName(0));
        FeatureTest.assertEquals((String)"End.highGC", (String)runner.getModel().getFeatureName(3));
        FeatureTest.assertEquals((String)"Kmer.lowGC.0", (String)runner.getModel().getFeatureName(4));
        FeatureTest.assertEquals((String)"Kmer.highGC.0", (String)runner.getModel().getFeatureName(5));
        FeatureTest.assertEquals((String)"Edge.lowGC-lowGC", (String)runner.getModel().getFeatureName(6));
        FeatureTest.assertEquals((int)10, (int)runner.getModel().getNumFeatures());
    }

    public void testWriteFeatures() throws Exception {
        List<TrainingSequence<?>> data = new InputHandlerInterleaved(new StringInput()).readTrainingData("test/input/zeroOrderTest.txt");
        Conrad runner = ZeroOrderManager.getCRF();
        runner.trainFeatures(data);
        this.writeFeatures(runner, "test/working/zeroOrderFeatures.csv", data.get(0));
        this.assertFilesMatch("test/output/zeroOrderFeatures.csv", "test/working/zeroOrderFeatures.csv");
    }

    public void testComponentFeatures() throws Exception {
        Conrad runner = new Conrad("test/input/componentFeatures.xml");
        List<TrainingSequence<?>> data = runner.getInputHandler().readTrainingData("test/input/testTrain.txt");
        runner.trainFeatures(data);
        ArrayFeatureList result = new ArrayFeatureList(runner.getModel());
        result.evaluateNode(data.get(0), 0, 0);
    }

    public void writeFeatures(Conrad runner, String file, InputSequence data) throws IOException {
        int i;
        ModelManager model = runner.getModel();
        boolean training = TrainingSequence.class.isInstance(data);
        int numFixed = 2 + (training ? 1 : 0);
        int totalFeatures = model.getNumFeatures();
        Object[] line = new String[numFixed + totalFeatures];
        BufferedWriter fw = new BufferedWriter(new FileWriter(file));
        line[0] = "pos";
        line[1] = "x";
        if (training) {
            line[2] = "y";
        }
        for (i = 0; i < totalFeatures; ++i) {
            line[i + numFixed] = model.getFeatureName(i);
        }
        fw.write('#' + StringUtils.join((Object[])line, (String)"\t") + '\n');
        for (i = 0; i < data.length(); ++i) {
            line[0] = Integer.toString(i);
            line[1] = data.getX(i).toString();
            if (training) {
                line[2] = Integer.toString(((TrainingSequence)data).getY(i));
            }
            for (int j = 0; j < totalFeatures; ++j) {
                line[numFixed + j] = "0";
            }
            int nStates = model.getNumStates();
            ArrayFeatureList result = new ArrayFeatureList(model);
            for (int state = 0; state < nStates; ++state) {
                result.evaluateNode(data, i, state);
                this.updateFeatureValues(result, (String[])line, numFixed);
                if (i <= 0) continue;
                for (int prevState = 0; prevState < nStates; ++prevState) {
                    result.evaluateEdge(data, i, prevState, state);
                    this.updateFeatureValues(result, (String[])line, numFixed);
                }
            }
            fw.write(StringUtils.join((Object[])line, (String)"\t") + '\n');
        }
        ((Writer)fw).close();
    }

    void updateFeatureValues(ArrayFeatureList result, String[] line, int numFixed) {
        int[] indices = result.getIndices();
        double[] vals = result.getValues();
        int size = result.size();
        for (int i = 0; i < size; ++i) {
            Assert.a(line[numFixed + indices[i]].equals("0"), "Feature had a previous value: " + line[numFixed + indices[i]]);
            line[numFixed + indices[i]] = Float.toString((float)vals[i]);
        }
    }
}

