/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.test;

import calhoun.analysis.crf.statistics.BasicStats;
import calhoun.analysis.crf.statistics.GammaDistribution;
import calhoun.analysis.crf.statistics.MixtureOfGammas;
import calhoun.analysis.crf.test.CRFIOTest;
import calhoun.util.AbstractTestCase;
import calhoun.util.Assert;
import calhoun.util.FileUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GammaDistributionsTest
extends AbstractTestCase {
    private static final Log log = LogFactory.getLog(CRFIOTest.class);
    boolean debug = log.isDebugEnabled();

    public void testGammaDistribution() throws Exception {
        String fileName = "test/input/testIntronLengths.txt";
        double[] intronlengths = FileUtil.readDoublesFromSingleTabbedLine(fileName);
        int nIntrons = intronlengths.length;
        GammaDistributionsTest.assertEquals((int)nIntrons, (int)5863);
        GammaDistributionsTest.assertEquals((double)intronlengths[0], (double)59.0, (double)1.0E-5);
        GammaDistributionsTest.assertEquals((double)intronlengths[1], (double)99.0, (double)1.0E-5);
        double mean = 0.0;
        double meanlog = 0.0;
        for (int j = 0; j < nIntrons; ++j) {
            Assert.a(intronlengths[j] > 0.0);
            mean += intronlengths[j];
            meanlog += Math.log(intronlengths[j]);
        }
        System.out.println("Mean = " + (mean /= (double)nIntrons));
        System.out.println("Meanlog = " + (meanlog /= (double)nIntrons));
        double[] plam = GammaDistribution.mleg(mean, meanlog);
        double p = plam[0];
        double lam = plam[1];
        GammaDistributionsTest.assertEquals((Object)mean, (Object)(p / lam));
        System.out.println("Shape parameter p is " + p);
        System.out.println("Rate parameter lambda is " + lam);
    }

    public void testGammaFunction() throws Exception {
        GammaDistributionsTest.assertEquals((double)GammaDistribution.gamma(1.0), (double)1.0, (double)1.0E-6);
        GammaDistributionsTest.assertEquals((double)GammaDistribution.gamma(2.0), (double)1.0, (double)1.0E-6);
        GammaDistributionsTest.assertEquals((double)GammaDistribution.gamma(3.0), (double)2.0, (double)1.0E-6);
        GammaDistributionsTest.assertEquals((double)GammaDistribution.gamma(4.0), (double)6.0, (double)1.0E-6);
        GammaDistributionsTest.assertEquals((double)GammaDistribution.gamma(5.0), (double)24.0, (double)1.0E-6);
        GammaDistributionsTest.assertEquals((double)GammaDistribution.gamma(0.5), (double)Math.sqrt(Math.PI), (double)1.0E-6);
    }

    public void testMixtureGammaModel() throws Exception {
        String fileName = "test/input/testIntronLengths.txt";
        double[] intronlengths = FileUtil.readDoublesFromSingleTabbedLine(fileName);
        int nIntrons = intronlengths.length;
        int len = nIntrons + 4;
        double[] x = new double[len];
        double[] post = new double[len];
        for (int j = 0; j < nIntrons; ++j) {
            x[j] = intronlengths[j];
        }
        x[nIntrons] = 50.0;
        post[nIntrons] = 1.0;
        x[nIntrons + 1] = 60.0;
        post[nIntrons + 1] = 1.0;
        x[nIntrons + 2] = 60.0;
        post[nIntrons + 2] = 0.0;
        x[nIntrons + 3] = 90.0;
        post[nIntrons + 3] = 0.0;
        double p = 0.5;
        double shape1 = 15.0;
        double lambda1 = 0.25;
        double shape2 = 5.0;
        double lambda2 = 0.05;
        for (int iteration = 0; iteration < 20; ++iteration) {
            System.out.println("Iteration " + iteration + "\tp=" + p + "\tshape1=" + shape1 + "\tlambda1=" + lambda1 + "\tmean1=" + shape1 / lambda1 + "\tshape2=" + shape2 + "\tlambda2=" + lambda2 + "\tmean2=" + shape2 / lambda2);
            for (int j = 0; j < nIntrons; ++j) {
                double p2;
                double p1 = p * GammaDistribution.gamma(shape1, lambda1, x[j]);
                Assert.a(p1 + (p2 = (1.0 - p) * GammaDistribution.gamma(shape2, lambda2, x[j])) > 0.0);
                post[j] = p1 / (p1 + p2);
            }
            double mean1 = 0.0;
            double mean2 = 0.0;
            double meanlog1 = 0.0;
            double meanlog2 = 0.0;
            for (int j = 0; j < len; ++j) {
                Assert.a(x[j] > 0.0);
                mean1 += post[j] * x[j];
                mean2 += (1.0 - post[j]) * x[j];
                meanlog1 += post[j] * Math.log(x[j]);
                meanlog2 += (1.0 - post[j]) * Math.log(x[j]);
            }
            p = BasicStats.meanDoubleArray(post);
            double[] plam1 = GammaDistribution.mleg(mean1 /= p * (double)len, meanlog1 /= p * (double)len);
            double[] plam2 = GammaDistribution.mleg(mean2 /= (1.0 - p) * (double)len, meanlog2 /= (1.0 - p) * (double)len);
            shape1 = plam1[0];
            lambda1 = plam1[1];
            shape2 = plam2[0];
            lambda2 = plam2[1];
        }
    }

    public void testMixtureGammaModelForceExponential() throws Exception {
        String fileName = "test/input/testIntronLengths.txt";
        double[] intronlengths = FileUtil.readDoublesFromSingleTabbedLine(fileName);
        new MixtureOfGammas(intronlengths);
        MixtureOfGammas mg = new MixtureOfGammas(intronlengths, true);
        for (int j = 2; j < 200; ++j) {
            System.out.println("j=" + j + "   " + Math.log(mg.evaluate(j) / mg.evaluate(j - 1)));
        }
        GammaDistributionsTest.assertEquals((double)Math.log(mg.evaluate(2.0) / mg.evaluate(1.0)), (double)Math.log(mg.evaluate(102.0) / mg.evaluate(101.0)), (double)1.0E-4);
    }

    public void testMixtureOfGammasClass() throws Exception {
        String fileName = "test/input/testIntronLengths.txt";
        double[] intronlengths = FileUtil.readDoublesFromSingleTabbedLine(fileName);
        MixtureOfGammas MG = new MixtureOfGammas(intronlengths);
        MG.summarize(System.out);
        GammaDistributionsTest.assertEquals((double)MG.getMix(), (double)0.859, (double)0.01);
        MixtureOfGammas MG2 = new MixtureOfGammas(0.86, 71.0, 1.27, 4.1, 0.041);
        GammaDistributionsTest.assertEquals((double)MG2.evaluate(55.0), (double)0.053107, (double)0.01);
        GammaDistributionsTest.assertEquals((double)MG2.logEvaluate(55.0), (double)-2.935446, (double)0.01);
        MixtureOfGammas MG3 = new MixtureOfGammas(1.0, 1.0, 1.0, 1.0, 2.0);
        GammaDistributionsTest.assertEquals((double)MG3.evaluate(1.0), (double)Math.exp(-1.0), (double)0.01);
        GammaDistributionsTest.assertEquals((double)MG3.logEvaluate(1.0), (double)-1.0, (double)0.01);
        MixtureOfGammas MG4 = new MixtureOfGammas(0.0, 1.0, 1.0, 1.0, 2.0);
        GammaDistributionsTest.assertEquals((double)MG4.evaluate(1.0), (double)(2.0 * Math.exp(-2.0)), (double)0.01);
        GammaDistributionsTest.assertEquals((double)MG4.logEvaluate(1.0), (double)(Math.log(2.0) - 2.0), (double)0.01);
        MixtureOfGammas MG5 = new MixtureOfGammas(0.5, 1.0, 1.0, 1.0, 2.0);
        GammaDistributionsTest.assertEquals((double)MG5.evaluate(1.0), (double)(0.5 * Math.exp(-1.0) + 1.0 * Math.exp(-2.0)), (double)0.01);
        GammaDistributionsTest.assertEquals((double)MG5.logEvaluate(1.0), (double)Math.log(0.5 * Math.exp(-1.0) + 1.0 * Math.exp(-2.0)), (double)0.01);
        MixtureOfGammas MG6 = new MixtureOfGammas(new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0});
        MG6.summarize(System.out);
        GammaDistributionsTest.assertEquals((double)MG6.getMean(), (double)3.5, (double)0.001);
    }
}

