/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.test;

import calhoun.analysis.crf.features.supporting.LogProbLookup;
import calhoun.analysis.crf.io.InputSequenceCharacter;
import calhoun.seq.KmerHasher;
import calhoun.util.AbstractTestCase;

public class LogprobLookupTest
extends AbstractTestCase {
    public void testLogProbLookupRC() throws Exception {
        int j;
        String forward = "TGTTGGTACGCTTGCGGCTCTGCTGCAGCGAAAAAAAAGATCGAAATGACCAG";
        String reverse = "CTGGTCATTTCGATCTTTTTTTTCGCTGCAGCAGAGCCGCAAGCGTACCAACA";
        String computedReverse = KmerHasher.reverseComplement(forward);
        int len = forward.length();
        LogprobLookupTest.assertEquals((String)reverse, (String)computedReverse);
        InputSequenceCharacter forwardSeq = new InputSequenceCharacter(forward);
        InputSequenceCharacter reverseSeq = new InputSequenceCharacter(reverse);
        LogProbLookup lf = new LogProbLookup(2, 1.0);
        LogProbLookup lr = new LogProbLookup(2, 1.0);
        for (j = 0; j < len; ++j) {
            lf.increment(forwardSeq, j, true);
            lr.increment(reverseSeq, j, false);
        }
        lf.finalize();
        lr.finalize();
        for (j = 0; j < len; ++j) {
            LogprobLookupTest.assertEquals((double)lf.lookup(forwardSeq, j, true), (double)lr.lookup(forwardSeq, j, true), (double)1.0E-4);
            LogprobLookupTest.assertEquals((double)lf.lookup(forwardSeq, j, false), (double)lr.lookup(forwardSeq, j, false), (double)1.0E-4);
            LogprobLookupTest.assertEquals((double)lf.lookup(forwardSeq, j, true), (double)lr.lookup(reverseSeq, len - j - 1, false), (double)1.0E-4);
        }
        System.out.println("hello");
    }
}

