/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.test;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.CacheStrategySpec;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.util.Assert;
import calhoun.util.DenseBooleanMatrix2D;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TestFeatureManager2
extends AbstractFeatureManager
implements ModelManager {
    private static final long serialVersionUID = 5316261467715122688L;
    private static final Log log = LogFactory.getLog(TestFeatureManager2.class);
    int edgeIx = -1;
    int node1Ix = -1;
    int node2Ix = -1;
    int nodeLenIx = -1;
    int nFeatures;

    public TestFeatureManager2(int type, boolean len) {
        switch (type) {
            case 0: {
                this.nFeatures = 1;
                this.edgeIx = 0;
                break;
            }
            case 1: {
                this.nFeatures = 2;
                this.node1Ix = 0;
                if (len) {
                    this.nodeLenIx = 1;
                    break;
                }
                this.node2Ix = 1;
                break;
            }
            case 2: {
                this.nFeatures = 3;
                this.edgeIx = 0;
                this.node1Ix = 1;
                if (len) {
                    this.nodeLenIx = 2;
                    break;
                }
                this.node2Ix = 2;
                break;
            }
            case 3: {
                this.nFeatures = 1;
                if (len) {
                    this.nodeLenIx = 0;
                    break;
                }
                this.node2Ix = 0;
                break;
            }
            default: {
                Assert.a(false, "Type " + type + " not 0-2.");
            }
        }
    }

    @Override
    public int getNumStates() {
        return 2;
    }

    @Override
    public String getStateName(int state) {
        return "testState" + state;
    }

    @Override
    public String getFeatureName(int featureIndex) {
        return "testFeature" + featureIndex;
    }

    @Override
    public int getNumFeatures() {
        return this.nFeatures;
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List data) {
    }

    @Override
    public DenseBooleanMatrix2D getLegalTransitions() {
        if (this.nodeLenIx != -1) {
            DenseBooleanMatrix2D trans = new DenseBooleanMatrix2D(2, 2);
            trans.setQuick(0, 1, true);
            trans.setQuick(1, 0, true);
            return trans;
        }
        return null;
    }

    @Override
    public int getStateIndex(String name) {
        Assert.a(false);
        return 0;
    }

    public void evaluateEdge(InputSequence seq, int pos, int prevState, int state, FeatureList result) {
        if (this.edgeIx != -1) {
            result.addFeature(this.edgeIx, (float)Math.log(prevState == state ? 0.6666666666666666 : 0.3333333333333333));
        }
    }

    public void evaluateNode(InputSequence seq, int pos, int state, FeatureList result) {
        double val = Math.log(state == 0 ? 0.3333333432674408 : 0.6666666865348816) * 0.5;
        if (this.node1Ix != -1) {
            result.addFeature(this.node1Ix, val);
        }
        if (this.node2Ix != -1) {
            result.addFeature(this.node2Ix, val);
        }
    }

    public void evaluateEdgeLength(InputSequence seq, int pos, int featLength, int prevState, int state, FeatureList result) {
    }

    public void evaluateNodeLength(InputSequence seq, int pos, int featLength, int state, FeatureList result) {
        if (this.nodeLenIx != -1) {
            double val = 0.5 * Math.log(state == 0 ? 0.3333333432674408 : 0.6666666865348816) * (double)featLength;
            result.addFeature(this.nodeLenIx, (float)val);
        }
    }

    @Override
    public CacheStrategySpec getCacheStrategy() {
        return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.UNSPECIFIED);
    }
}

