/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.test;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.CacheStrategySpec;
import calhoun.analysis.crf.CompositeFeatureManager;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerNode;
import calhoun.analysis.crf.FeatureManagerNodeBoundaries;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.util.Assert;
import calhoun.util.DenseBooleanMatrix2D;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TestFeatureManager3
extends CompositeFeatureManager
implements ModelManager {
    private static final long serialVersionUID = 5162614677151226890L;
    private static final Log log = LogFactory.getLog(TestFeatureManager3.class);
    boolean len;

    public TestFeatureManager3(int type, boolean len) {
        this.len = len;
        switch (type) {
            case 1: {
                this.addFeatureManager(new TestNodeFeature());
            }
            case 3: {
                break;
            }
            default: {
                Assert.a(false, "Type " + type + " not 1 or 3.");
            }
        }
        if (len) {
            this.addFeatureManager(new DenseTestNodeLengthFeature());
        } else {
            this.addFeatureManager(new TestNodeFeature());
        }
    }

    @Override
    public int getNumStates() {
        return 2;
    }

    @Override
    public String getStateName(int state) {
        return "testState" + state;
    }

    @Override
    public int getStateIndex(String name) {
        Assert.a(false);
        return 0;
    }

    @Override
    public DenseBooleanMatrix2D getLegalTransitions() {
        if (this.len) {
            DenseBooleanMatrix2D trans = new DenseBooleanMatrix2D(2, 2);
            trans.setQuick(0, 1, true);
            trans.setQuick(1, 0, true);
            return trans;
        }
        return null;
    }

    class DenseTestNodeLengthFeature
    extends TestFeature
    implements FeatureManagerNodeBoundaries {
        private static final long serialVersionUID = -8448250464759172704L;

        DenseTestNodeLengthFeature() {
        }

        @Override
        public CacheStrategySpec getCacheStrategy() {
            CacheStrategySpec css = new CacheStrategySpec(CacheStrategySpec.CacheStrategy.DENSE_NODE_BOUNDARY);
            CacheStrategySpec.DenseBoundaryCachingDetails details = new CacheStrategySpec.DenseBoundaryCachingDetails(2);
            details.add(0, 0, this.startIx, 0, 0);
            details.add(1, 1, this.startIx, 0, 0);
            details.check();
            css.details = details;
            return css;
        }
    }

    class TestNodeFeature
    extends TestFeature
    implements FeatureManagerNode {
        private static final long serialVersionUID = 5966577419490935155L;

        TestNodeFeature() {
        }

        @Override
        public CacheStrategySpec getCacheStrategy() {
            CacheStrategySpec css = new CacheStrategySpec(CacheStrategySpec.CacheStrategy.DENSE);
            return css;
        }
    }

    abstract class TestFeature
    extends AbstractFeatureManager
    implements FeatureManagerNode {
        int startIx;

        TestFeature() {
        }

        public void evaluateNode(InputSequence seq, int pos, int state, FeatureList result) {
            double val = (float)(pos % 5 + 1) / 6.0f;
            if (state == 1) {
                val = 1.0 - val;
            }
            val = Math.log(val);
            result.addFeature(this.startIx, val);
        }

        @Override
        public String getFeatureName(int featureIndex) {
            Assert.a(featureIndex == this.startIx);
            return "DenseNode";
        }

        @Override
        public void train(int startingIndex, ModelManager modelInfo, List data) {
            this.startIx = startingIndex;
        }

        @Override
        public int getNumFeatures() {
            return 1;
        }
    }
}

