/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.test;

import calhoun.analysis.crf.CRFObjectiveFunctionGradient;
import calhoun.analysis.crf.Conrad;
import calhoun.analysis.crf.io.StringInput;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.analysis.crf.solver.StandardOptimizer;
import calhoun.util.AbstractTestCase;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ValidPathsTest
extends AbstractTestCase {
    private static final Log log = LogFactory.getLog(ValidPathsTest.class);
    static List<? extends TrainingSequence<?>> train1 = StringInput.prepareData("000001\nATAGAG\n101010\nAGAGAG\n");
    static String[] test1 = new String[]{"1\nA\n0\nT\n", "10\nAT\n01\nAA\n00\nTA\n11\nAA\n"};
    static String[] test2 = new String[]{"1\nA\n0\nT\n", "10\nAT\n01\nAA\n"};

    public void testSumPathsAllPaths() throws Exception {
        this.sumLikelihoodSets("test/input/validPathsModelAllPathsBasic.xml", train1, test1);
    }

    public void testSumPathsAllPathsCached() throws Exception {
        this.sumLikelihoodSets("test/input/validPathsModelAllPaths.xml", train1, test1);
    }

    public void testSumPaths() throws Exception {
        List<? extends TrainingSequence<Character>> train = StringInput.prepareData("010101\nATAGAG\n101010\nAGAGAG\n");
        String[] tests = new String[]{"101010101010101010101010\nATGACAGTAGACATGACAGTAGAC\n010101010101010101010101\nAATGACTGACACAATGACTGACAC\n", "101010101010\nATGACAGTAGAC\n010101010101\nAATGACTGACAC\n", "10\nAT\n01\nAA\n", "1\nA\n0\nT\n"};
        this.sumLikelihoodSets("test/input/validPathsModel.xml", train, tests);
    }

    public void testSumPathsMoreComplicated() throws Exception {
        List<? extends TrainingSequence<Character>> train = StringInput.prepareData("000001\nATAGAG\n101010\nAGAGAG\n");
        String[] tests = new String[]{"1\nA\n0\nT\n", "10\nAT\n01\nAA\n00\nTA\n", "000\nATG\n001\nAAC\n010\nTAG\n100\nGAG\n101\nTGG\n"};
        this.sumLikelihoodSets("test/input/validPathsModelMoreComplicated.xml", train, tests);
    }

    public void testRejectInvalidTrainingPath() throws Exception {
        boolean failure = false;
        List<? extends TrainingSequence<Character>> train = StringInput.prepareData("010101\nATAGAG\n011101\nAGAGAG\n");
        Conrad r = new Conrad("test/input/validPathsModel.xml");
        try {
            r.train(train);
        }
        catch (Exception e) {
            log.info((Object)e);
            failure = true;
        }
        ValidPathsTest.assertTrue((boolean)failure);
    }

    void sumLikelihoodSets(String runner, List<? extends TrainingSequence<?>> train, String[] tests) throws Exception {
        Conrad r = new Conrad(runner);
        r.trainFeatures(train);
        double[] weights = new double[r.getModel().getNumFeatures()];
        Arrays.fill(weights, 1.0);
        this.sumLikelihood(r, weights, tests);
        for (int i = 0; i < weights.length; ++i) {
            weights[i] = Math.random() * 10.0;
        }
        this.sumLikelihood(r, weights, tests);
    }

    void sumLikelihood(Conrad r, double[] weights, String[] tests) throws Exception {
        log.debug((Object)"Sumlikelihoods test");
        for (String testString : tests) {
            List<? extends TrainingSequence<Character>> test = StringInput.prepareData(testString);
            double likelihood = 0.0;
            for (TrainingSequence<Character> trainingSequence : test) {
                CRFObjectiveFunctionGradient obj = ((StandardOptimizer)r.getOptimizer()).getObjectiveFunction();
                obj.setTrainingData(r.getModel(), Collections.singletonList(trainingSequence));
                double[] dummy = new double[weights.length];
                double ll = obj.apply(weights, dummy);
                double l = Math.exp(ll * (double)trainingSequence.length());
                log.debug((Object)("Likelihood: " + l + " for " + trainingSequence));
                likelihood += l;
            }
            ValidPathsTest.assertEquals((double)1.0, (double)likelihood, (double)1.0E-6);
        }
    }
}

