/*
 * Decompiled with CFR 0.152.
 */
package calhoun.seq;

import calhoun.seq.FastaSequence;
import calhoun.seq.QualityIterator;
import calhoun.seq.SimpleFastaSequence;
import calhoun.util.ConfigException;
import calhoun.util.ErrorException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FastaIterator
implements Iterator<FastaSequence> {
    public static final String HEADER_START = ">";
    private File file;
    private BufferedReader reader;
    private String nextHeader;
    private QualityIterator qualityIt;

    public FastaIterator(String file) throws IOException {
        this(new File(file), null);
    }

    public FastaIterator(File file) throws IOException {
        this(file, null);
    }

    public FastaIterator(String sequence, String quality) throws IOException {
        this(new File(sequence), quality == null ? null : new File(quality));
    }

    public FastaIterator(File sequence, File quality) throws IOException {
        String nextHeaderLine;
        this.file = sequence;
        if (!this.file.exists()) {
            throw new IOException("The fasta file \"" + this.file + "\" does not exist");
        }
        if (this.file.length() == 0L) {
            this.nextHeader = null;
            return;
        }
        if (quality != null) {
            this.qualityIt = new QualityIterator(quality, false);
        }
        this.reader = new BufferedReader(new FileReader(this.file));
        while ((nextHeaderLine = this.reader.readLine()).trim().length() == 0) {
        }
        if (!nextHeaderLine.startsWith(HEADER_START)) {
            throw new ConfigException(this.file + " is not a valid FASTA file");
        }
        this.nextHeader = nextHeaderLine.substring(1).trim();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("can't remove items from a FastaIterator");
    }

    @Override
    public boolean hasNext() {
        return this.nextHeader != null;
    }

    @Override
    public FastaSequence next() {
        if (this.nextHeader == null) {
            throw new NoSuchElementException();
        }
        ReaderSequence seq = new ReaderSequence(this.file, this.nextHeader);
        try {
            this.nextHeader = seq.loadSequence(this.reader);
        }
        catch (Exception e) {
            throw new RuntimeException("error reading " + this.file, e);
        }
        try {
            if (this.nextHeader == null) {
                this.reader.close();
            }
        }
        catch (IOException ex) {
            throw new ErrorException("Error closing " + this.file.getAbsolutePath(), ex);
        }
        if (this.qualityIt != null) {
            this.qualityIt.addNextQuality(seq);
        }
        return seq;
    }

    public static class ReaderSequence
    extends SimpleFastaSequence {
        private static final long serialVersionUID = -637754971987954577L;
        File file;

        public ReaderSequence(File file, String header) {
            this.file = file;
            this.setHeader(header);
        }

        public File getFile() {
            return this.file;
        }

        public String loadSequence(BufferedReader reader) throws IOException {
            String line;
            StringBuffer buffer = new StringBuffer();
            while ((line = reader.readLine()) != null && !line.startsWith(FastaIterator.HEADER_START)) {
                buffer.append(line.trim());
            }
            this.setSequence(buffer.toString());
            if (line != null) {
                line = line.substring(1).trim();
            }
            return line;
        }
    }
}

