/*
 * Decompiled with CFR 0.152.
 */
package calhoun.seq;

import calhoun.seq.FastaSequence;
import calhoun.util.ConfigException;
import calhoun.util.FileUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FastaWriter {
    private static final Log log = LogFactory.getLog(FastaWriter.class);
    public static final int DEFAULT_LINE_LENGTH = 60;
    BufferedWriter writer;
    String filename = "<unknown>";
    int lineLength;
    boolean ownsWriter = true;

    public FastaWriter(String file, boolean append) {
        this(new File(file), append, 60);
    }

    public FastaWriter(String file, boolean append, int lineLength) {
        this(new File(file), append, lineLength);
    }

    public FastaWriter(File file, boolean append) {
        this(file, append, 60);
    }

    public FastaWriter(File file, boolean append, int lineLength) {
        try {
            this.setupWriter(new FileWriter(file, append), lineLength);
            if (append && file.length() > 0L) {
                this.writer.newLine();
            }
        }
        catch (FileNotFoundException ex) {
            throw new ConfigException("Not able to write fasta file: " + file, ex);
        }
        catch (IOException ex) {
            throw new ConfigException("Error writing fasta file: " + file, ex);
        }
        this.filename = file.getAbsolutePath();
    }

    public FastaWriter(Writer w, int lineLength) {
        this.setupWriter(w, lineLength);
        this.ownsWriter = false;
    }

    protected void setupWriter(Writer w, int lineLength) {
        this.lineLength = lineLength;
        this.writer = new BufferedWriter(w);
    }

    public void writeSeq(String header, String content) {
        try {
            this.writer.write(">");
            this.writer.write(header);
            this.writer.newLine();
            log.debug((Object)("Writing sequence of length: " + content.length() + " to " + this.filename));
            for (int i = 0; i < content.length(); i += this.lineLength) {
                CharSequence line = content.subSequence(i, Math.min(this.lineLength + i, content.length()));
                this.writer.write(((Object)line).toString());
                this.writer.newLine();
            }
            this.writer.flush();
        }
        catch (IOException ex) {
            throw new ConfigException("Not able to write fasta file: " + this.filename, ex);
        }
    }

    public void writeSeq(String header, String string, Integer start, Integer stop) {
        CharSequence sequence = string;
        if (start != null && stop != null) {
            sequence = sequence.subSequence(start - 1, stop);
        } else if (start != null) {
            sequence = sequence.subSequence(start - 1, sequence.length());
        } else if (stop != null) {
            sequence = sequence.subSequence(0, stop);
        }
        this.writeSeq(header, sequence.toString());
    }

    public void writeSeq(FastaSequence seq) {
        this.writeSeq(seq.getHeader(), seq.getSequence());
    }

    public void close() {
        FileUtil.safeClose(this.writer);
    }

    public String getFilename() {
        return this.filename;
    }

    protected void finalize() {
        if (this.ownsWriter) {
            this.close();
        }
    }
}

