/*
 * Decompiled with CFR 0.152.
 */
package calhoun.seq;

import calhoun.util.Assert;
import calhoun.util.ErrorException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KmerHasher
implements Serializable {
    private static final long serialVersionUID = -3402947063680917230L;
    private static final Log log = LogFactory.getLog(KmerHasher.class);
    CharacterHash charHash;
    int length;
    int mscMult;
    int lscMult;
    public static CharacterHash DNA = new CharacterHash(){
        private static final long serialVersionUID = -5641887174464060367L;
        final char[] BASES = new char[]{'A', 'C', 'G', 'T'};

        @Override
        public short getSize() {
            return 4;
        }

        @Override
        public int hash(char a) {
            switch (a) {
                case 'A': 
                case 'a': {
                    return 0;
                }
                case 'C': 
                case 'c': {
                    return 1;
                }
                case 'G': 
                case 'g': {
                    return 2;
                }
                case 'T': 
                case 't': {
                    return 3;
                }
            }
            throw new ErrorException("Bad character for hashing '" + a + "'.  Only A,C,T,G,a,c,t,g are allowed.");
        }

        @Override
        public char reverse(int a) {
            return this.BASES[a];
        }
    };
    public static CharacterHash ACGTN = new CharacterHash(){
        private static final long serialVersionUID = -4366495850512839766L;
        final char[] BASES = new char[]{'A', 'C', 'G', 'T', 'N'};

        @Override
        public short getSize() {
            return 5;
        }

        @Override
        public int hash(char a) {
            switch (a) {
                case 'A': 
                case 'a': {
                    return 0;
                }
                case 'C': 
                case 'c': {
                    return 1;
                }
                case 'G': 
                case 'g': {
                    return 2;
                }
                case 'T': 
                case 't': {
                    return 3;
                }
                case 'N': 
                case 'n': {
                    return 4;
                }
            }
            throw new ErrorException("Bad character for hashing '" + a + "'.  Only A,C,T,G,N,a,c,t,g,n are allowed.");
        }

        @Override
        public char reverse(int a) {
            return this.BASES[a];
        }
    };
    public static CharacterHash ACGTNcomp = new CharacterHash(){
        private static final long serialVersionUID = -5959780907260989652L;
        final char[] BASES = new char[]{'T', 'G', 'C', 'A', 'N'};

        @Override
        public short getSize() {
            return 5;
        }

        @Override
        public int hash(char a) {
            switch (a) {
                case 'T': 
                case 't': {
                    return 0;
                }
                case 'G': 
                case 'g': {
                    return 1;
                }
                case 'C': 
                case 'c': {
                    return 2;
                }
                case 'A': 
                case 'a': {
                    return 3;
                }
                case 'N': 
                case 'n': {
                    return 4;
                }
            }
            throw new ErrorException("Bad character for hashing '" + a + "'.  Only A,C,T,G,N,a,c,t,g,n are allowed.");
        }

        @Override
        public char reverse(int a) {
            return this.BASES[a];
        }
    };
    public static CharacterHash ACGTother = new CharacterHash(){
        private static final long serialVersionUID = -3279138437137318988L;
        final char[] BASES = new char[]{'A', 'C', 'G', 'T', 'N'};

        @Override
        public short getSize() {
            return 5;
        }

        @Override
        public int hash(char a) {
            switch (a) {
                case 'A': 
                case 'a': {
                    return 0;
                }
                case 'C': 
                case 'c': {
                    return 1;
                }
                case 'G': 
                case 'g': {
                    return 2;
                }
                case 'T': 
                case 't': {
                    return 3;
                }
            }
            return 4;
        }

        @Override
        public char reverse(int a) {
            return this.BASES[a];
        }
    };
    public static CharacterHash ACGTotherRC = new CharacterHash(){
        private static final long serialVersionUID = 609468521914363959L;
        final char[] BASES = new char[]{'T', 'G', 'C', 'A', 'N'};

        @Override
        public short getSize() {
            return 5;
        }

        @Override
        public int hash(char a) {
            switch (a) {
                case 'A': 
                case 'a': {
                    return 3;
                }
                case 'C': 
                case 'c': {
                    return 2;
                }
                case 'G': 
                case 'g': {
                    return 1;
                }
                case 'T': 
                case 't': {
                    return 0;
                }
            }
            return 4;
        }

        @Override
        public char reverse(int a) {
            return this.BASES[a];
        }
    };
    public static CharacterHash LETTERS = new CharacterHash(){
        private static final long serialVersionUID = -4036999685428397071L;

        @Override
        public short getSize() {
            return 26;
        }

        @Override
        public int hash(char a) {
            if (a >= 'a' && a <= 'z') {
                return a - 97;
            }
            if (a >= 'A' && a <= 'Z') {
                return a - 65;
            }
            throw new ErrorException("Bad character for hashing '" + a + "'.  Only a-z and A-Z are allowed.");
        }

        @Override
        public char reverse(int a) {
            return (char)(97 + (char)a);
        }
    };

    public KmerHasher(CharacterHash charHash, int length) {
        this.charHash = charHash;
        this.length = length;
        this.mscMult = (int)Math.pow(charHash.getSize(), length - 1);
        this.lscMult = charHash.getSize();
    }

    public static String reverseComplement(String forward) {
        String reverse = "";
        CharacterHash hf = ACGTother;
        CharacterHash hr = ACGTotherRC;
        for (int j = forward.length() - 1; j >= 0; --j) {
            reverse = reverse + hr.reverse(hf.hash(forward.charAt(j)));
        }
        return reverse;
    }

    public int range() {
        return this.mscMult * this.lscMult;
    }

    public int hash(String str, int pos) {
        Assert.a(pos >= 0);
        Assert.a(pos + this.length <= str.length());
        int hash = 0;
        for (int i = 0; i < this.length; ++i) {
            hash = hash * this.lscMult + this.charHash.hash(str.charAt(pos + i));
        }
        return hash;
    }

    public int hash(char[] chr) {
        int hash = 0;
        for (int i = 0; i < this.length; ++i) {
            hash = hash * this.lscMult + this.charHash.hash(chr[i]);
        }
        return hash;
    }

    public int hash(char[] chr, int start) {
        int hash = 0;
        for (int i = start; i < this.length + start; ++i) {
            hash = hash * this.lscMult + this.charHash.hash(chr[i]);
        }
        return hash;
    }

    public int shiftHash(char chr, int hash) {
        return hash % this.mscMult * this.lscMult + this.charHash.hash(chr);
    }

    public int reverseShiftHash(char chr, int hash) {
        return this.charHash.hash(chr) * this.mscMult + hash / this.lscMult;
    }

    public int hash(char c) {
        return this.charHash.hash(c);
    }

    public boolean hashable(char a) {
        try {
            this.charHash.hash(a);
        }
        catch (ErrorException E) {
            return false;
        }
        return true;
    }

    public static interface CharacterHash
    extends Serializable {
        public short getSize();

        public int hash(char var1) throws ErrorException;

        public char reverse(int var1);
    }
}

