/*
 * Decompiled with CFR 0.152.
 */
package calhoun.seq;

import calhoun.seq.FastaSequence;
import calhoun.seq.SimpleFastaSequence;
import calhoun.util.DataException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QualityIterator
implements Iterator {
    private static final Log log = LogFactory.getLog(QualityIterator.class);
    File file;
    BufferedReader reader;
    String lastReadHeader;
    byte[] lastReadQualitySequence;
    String lastReadLine;
    byte[] lastReadQuality;
    boolean endOfFileReached;

    public QualityIterator(String fileName, boolean isGzipped) throws IOException {
        this(new File(fileName), isGzipped);
    }

    public QualityIterator(String fileName) throws IOException {
        this(new File(fileName), false);
    }

    public QualityIterator(BufferedReader reader) {
        this.commonInit(reader);
    }

    protected void commonInit(BufferedReader reader) {
        this.endOfFileReached = false;
        this.reader = reader;
        this.readNext();
    }

    public QualityIterator(File file, boolean isGzipped) throws IOException {
        this.file = file;
        InputStream is = new FileInputStream(file);
        if (isGzipped) {
            is = new GZIPInputStream(is);
        }
        this.reader = new BufferedReader(new InputStreamReader(is));
        this.commonInit(this.reader);
    }

    public Object next() {
        return this.nextQuality();
    }

    public FastaSequence nextQuality() {
        SimpleFastaSequence qs = new SimpleFastaSequence();
        this.addNextQuality(qs);
        return qs;
    }

    public void addNextQuality(SimpleFastaSequence input) {
        if (this.endOfFileReached) {
            throw new DataException("Attempted to read past end of file " + this.file.getAbsolutePath());
        }
        if (input.header == null) {
            input.setHeader(this.lastReadHeader);
        } else if (!input.header.equals(this.lastReadHeader)) {
            throw new DataException("Quality file header " + this.lastReadHeader + " doesn't match sequence header " + input.header);
        }
        if (input.hasSequence() && input.getLength() != this.lastReadQualitySequence.length) {
            throw new DataException("Quality file length " + this.lastReadQualitySequence.length + " doesn't match sequence length " + input.getLength() + " for " + input.header);
        }
        input.setQuality(this.lastReadQualitySequence);
        this.readNext();
    }

    @Override
    public boolean hasNext() {
        return !this.endOfFileReached;
    }

    /*
     * Unable to fully structure code
     */
    protected void readNext() {
        try {
            do {
                if ((line = this.lastReadLine == null ? this.reader.readLine() : this.lastReadLine) == null) {
                    this.endOfFileReached = true;
                    return;
                }
                if ((line = line.trim()).startsWith(">")) continue;
                throw new DataException("Expected \">\" when reading next quality sequence");
            } while (line.length() == 0);
            this.lastReadHeader = line.substring(1).trim();
            os = new ByteArrayOutputStream();
            block3: while (true) {
                if ((line = this.reader.readLine()) == null) {
                    this.lastReadLine = null;
                    break;
                }
                if ((line = line.trim()).startsWith(">")) {
                    this.lastReadLine = line;
                    break;
                }
                if (line.length() <= 0) continue;
                numbers = line.split(" ");
                i = 0;
                while (true) {
                    if (i < numbers.length) ** break;
                    continue block3;
                    val = Integer.parseInt(numbers[i]);
                    os.write(val);
                    ++i;
                }
                break;
            }
            this.lastReadQualitySequence = os.toByteArray();
        }
        catch (IOException e) {
            throw new DataException("Exception reading " + this.file.getPath(), e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

