/*
 * Decompiled with CFR 0.152.
 */
package calhoun.seq.test;

import calhoun.seq.KmerHasher;
import calhoun.util.AbstractTestCase;

public class KmerHasherTest
extends AbstractTestCase {
    public void testDnaLengthOne() {
        KmerHasher h = new KmerHasher(KmerHasher.DNA, 1);
        KmerHasherTest.assertEquals((int)0, (int)h.hash("a", 0));
        KmerHasherTest.assertEquals((int)0, (int)h.hash("a", 0));
        KmerHasherTest.assertEquals((int)1, (int)h.hash("C", 0));
        KmerHasherTest.assertEquals((int)2, (int)h.hash("G", 0));
        KmerHasherTest.assertEquals((int)3, (int)h.hash("T", 0));
    }

    public void testLetterLengthOne() {
        KmerHasher h = new KmerHasher(KmerHasher.LETTERS, 1);
        KmerHasherTest.assertEquals((int)0, (int)h.hash("a", 0));
        KmerHasherTest.assertEquals((int)0, (int)h.hash("A", 0));
        KmerHasherTest.assertEquals((int)1, (int)h.hash("b", 0));
        KmerHasherTest.assertEquals((int)25, (int)h.hash("Z", 0));
    }

    public void testDnaLengthTwo() {
        KmerHasher h = new KmerHasher(KmerHasher.DNA, 2);
        KmerHasherTest.assertEquals((int)0, (int)h.hash("aa", 0));
        KmerHasherTest.assertEquals((int)1, (int)h.hash("ac", 0));
        KmerHasherTest.assertEquals((int)4, (int)h.hash("ca", 0));
        KmerHasherTest.assertEquals((int)5, (int)h.hash("cc", 0));
        KmerHasherTest.assertEquals((int)15, (int)h.hash("TT", 0));
    }

    public void testLettersLengthTwo() {
        KmerHasher h = new KmerHasher(KmerHasher.LETTERS, 2);
        KmerHasherTest.assertEquals((int)0, (int)h.hash("aa", 0));
        KmerHasherTest.assertEquals((int)1, (int)h.hash("ab", 0));
        KmerHasherTest.assertEquals((int)26, (int)h.hash("ba", 0));
        KmerHasherTest.assertEquals((int)651, (int)h.hash("zb", 0));
    }

    public void testCallTypes() {
        KmerHasher h = new KmerHasher(KmerHasher.DNA, 4);
        KmerHasherTest.assertEquals((int)130, (int)h.hash("gaag", 0));
        KmerHasherTest.assertEquals((int)130, (int)h.hash("aagaagaa", 2));
        KmerHasherTest.assertEquals((int)130, (int)h.hash(new char[]{'g', 'a', 'a', 'g'}));
    }

    public void testShift() {
        KmerHasher h = new KmerHasher(KmerHasher.DNA, 4);
        int hash = h.hash("agaa", 0);
        KmerHasherTest.assertEquals((int)32, (int)hash);
        KmerHasherTest.assertEquals((int)130, (int)h.shiftHash('g', hash));
        KmerHasherTest.assertEquals((int)hash, (int)h.reverseShiftHash('a', 130));
    }

    public void testReverse() {
    }
}

