/*
 * Decompiled with CFR 0.152.
 */
package calhoun.seq.test;

import calhoun.seq.RepeatedSubsequence;
import calhoun.util.AbstractTestCase;
import java.util.Map;

public class RepeatedSubsequenceTest
extends AbstractTestCase {
    public void testRepeatedSubsequence() {
        RepeatedSubsequenceTest.assertEquals((String)"ATGC", (String)RepeatedSubsequence.calc("ATGC"));
        RepeatedSubsequenceTest.assertEquals((String)"A", (String)RepeatedSubsequence.calc("AA"));
        RepeatedSubsequenceTest.assertEquals((String)"A", (String)RepeatedSubsequence.calc("AAA"));
        RepeatedSubsequenceTest.assertEquals((String)"A", (String)RepeatedSubsequence.calc("AAAA"));
        RepeatedSubsequenceTest.assertEquals((String)"A", (String)RepeatedSubsequence.calc("AAAAA"));
        RepeatedSubsequenceTest.assertEquals((String)"A", (String)RepeatedSubsequence.calc("AAAAAA"));
        RepeatedSubsequenceTest.assertEquals((String)"AT", (String)RepeatedSubsequence.calc("ATATATATAT"));
        RepeatedSubsequenceTest.assertEquals((String)"ATATCG", (String)RepeatedSubsequence.calc("ATATCGATATCG"));
        RepeatedSubsequenceTest.assertEquals((String)"AT", (String)RepeatedSubsequence.calc("ATATATATATAT"));
    }

    public void testRollingMatch() {
        RepeatedSubsequenceTest.assertEquals((boolean)true, (boolean)RepeatedSubsequence.isRollingMatch("ATGC", "ATGC"));
        RepeatedSubsequenceTest.assertEquals((boolean)true, (boolean)RepeatedSubsequence.isRollingMatch("CATG", "ATGC"));
        RepeatedSubsequenceTest.assertEquals((boolean)true, (boolean)RepeatedSubsequence.isRollingMatch("GCAT", "ATGC"));
        RepeatedSubsequenceTest.assertEquals((boolean)true, (boolean)RepeatedSubsequence.isRollingMatch("TGCA", "ATGC"));
        RepeatedSubsequenceTest.assertEquals((boolean)false, (boolean)RepeatedSubsequence.isRollingMatch("TCGA", "ATGC"));
    }

    private String getCanonical(Map<String, Integer> m, String seq) {
        seq = RepeatedSubsequence.calc(seq);
        for (String key : m.keySet()) {
            if (!RepeatedSubsequence.isRollingMatch(key, seq)) continue;
            m.put(key, m.get(key) + 1);
            return key;
        }
        m.put(seq, 1);
        return seq;
    }
}

