/*
 * Decompiled with CFR 0.152.
 */
package calhoun.util;

import java.io.Serializable;
import java.util.Arrays;

public final class DenseIntMatrix2D
implements Serializable {
    private static final long serialVersionUID = 993972669435690618L;
    int[] array;
    int length;

    public DenseIntMatrix2D(int x, int y) {
        this.array = new int[x * y];
        this.length = y;
    }

    public final int getQuick(int x, int y) {
        return this.array[x * this.length + y];
    }

    public final void setQuick(int x, int y, int val) {
        this.array[x * this.length + y] = val;
    }

    public final void assign(int val) {
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = val;
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append('\n');
        for (int i = 0; i < this.array.length / this.length; ++i) {
            int row = i * this.length;
            for (int j = 0; j < this.length; ++j) {
                b.append(this.array[row + j]).append("   ");
            }
            b.append('\n');
        }
        return b.toString();
    }

    public boolean equals(Object rhs) {
        DenseIntMatrix2D matrix = (DenseIntMatrix2D)rhs;
        return Arrays.equals(this.array, matrix.array);
    }
}

