/*
 * Decompiled with CFR 0.152.
 */
package calhoun.util;

import bmsi.util.Diff;
import bmsi.util.DiffPrint;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;

public class FileDiff {
    private String[] firstLines;
    private String[] secondLines;
    private boolean closeReaders;
    private Reader firstLinesReader;
    private Reader secondLinesReader;
    private boolean ignoreWhitespace = true;
    private String commentLineIndicator;
    private Diff.change change = null;

    public static boolean filesMatch(String first, String second) throws IOException {
        return !new FileDiff(first, second).execute();
    }

    public FileDiff(String first, String second) throws IOException {
        this(new InputStreamReader((InputStream)new FileInputStream(first), "UTF-8"), new InputStreamReader((InputStream)new FileInputStream(second), "UTF-8"), true);
    }

    public FileDiff(File first, File second) throws IOException {
        this(new InputStreamReader((InputStream)new FileInputStream(first), "UTF-8"), new InputStreamReader((InputStream)new FileInputStream(second), "UTF-8"), true);
    }

    public FileDiff(Reader first, Reader second) {
        this(first, second, false);
    }

    public FileDiff(Reader first, Reader second, boolean closeReaders) {
        this.firstLinesReader = first;
        this.secondLinesReader = second;
        this.closeReaders = closeReaders;
    }

    public void setIgnoreWhitespace(boolean b) {
        this.ignoreWhitespace = b;
    }

    public boolean getIgnoreWhitespace() {
        return this.ignoreWhitespace;
    }

    public void setCommentLineIndicator(String commentLineIndicator) {
        this.commentLineIndicator = commentLineIndicator;
    }

    public String getCommentLineIndicator() {
        return this.commentLineIndicator;
    }

    public boolean execute() throws IOException {
        this.firstLines = this.readLines(this.firstLinesReader);
        this.secondLines = this.readLines(this.secondLinesReader);
        if (this.closeReaders) {
            this.firstLinesReader.close();
            this.secondLinesReader.close();
        }
        Diff diff = new Diff(this.firstLines, this.secondLines);
        this.change = diff.diff_2(false);
        return this.change != null;
    }

    public String toString() {
        if (this.change != null) {
            DiffPrint.NormalPrint np = new DiffPrint.NormalPrint(this.firstLines, this.secondLines);
            StringWriter str = new StringWriter();
            PrintWriter writer = new PrintWriter(str);
            np.setWriter(writer);
            np.print_script(this.change);
            writer.close();
            return str.toString();
        }
        return "";
    }

    private String[] readLines(Reader r) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(r);
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            if (this.ignoreWhitespace) {
                line = line.trim();
            }
            if (this.ignoreWhitespace && "".equals(line) || this.commentLineIndicator != null && line.startsWith(this.commentLineIndicator)) continue;
            lines.add(line);
        }
        String[] result = new String[lines.size()];
        return lines.toArray(result);
    }
}

