/*
 * Decompiled with CFR 0.152.
 */
package calhoun.util;

import calhoun.util.Assert;
import calhoun.util.ErrorException;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileUtil {
    private static final Log log = LogFactory.getLog(FileUtil.class);

    private FileUtil() {
    }

    public static final String readFile(File filename) throws IOException {
        return FileUtil.readReader(new FileReader(filename));
    }

    public static final void appendSeparator(File in) throws Exception {
        FileOutputStream f = new FileOutputStream(in, true);
        f.write(File.separator.getBytes());
    }

    public static final void copyFile(File in, File out, boolean append) throws Exception {
        FileChannel sourceChannel = new FileInputStream(in).getChannel();
        FileChannel destinationChannel = new FileOutputStream(out, append).getChannel();
        sourceChannel.transferTo(0L, sourceChannel.size(), destinationChannel);
        sourceChannel.close();
        destinationChannel.close();
    }

    public static final void copyFile(File in, File out) throws Exception {
        FileUtil.copyFile(in, out, false);
    }

    public static final void renameFile(File oldFile, File newFile) throws Exception {
        newFile.getParentFile().mkdirs();
        if (!oldFile.renameTo(newFile)) {
            FileUtil.copyFile(oldFile, newFile);
            oldFile.delete();
        }
    }

    public static final BufferedWriter safeOpen(String file) {
        try {
            return file == null ? null : new BufferedWriter(new FileWriter(file));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static final void safeWrite(Writer w, String s) {
        try {
            w.write(s);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static final void unzipFile(File file, File toDirectory) throws Exception {
        ZipEntry entry;
        toDirectory.mkdirs();
        ZipInputStream zis = new ZipInputStream(new FileInputStream(file));
        while ((entry = zis.getNextEntry()) != null) {
            int read;
            if (entry.isDirectory()) {
                new File(toDirectory, entry.getName()).mkdirs();
                continue;
            }
            FileOutputStream fos = new FileOutputStream(new File(toDirectory, entry.getName()));
            byte[] bytes = new byte[8096];
            while ((read = zis.read(bytes)) != -1) {
                fos.write(bytes, 0, read);
            }
        }
    }

    public static final boolean isGzipStream(InputStream s) {
        try {
            byte[] b = new byte[]{0, 0};
            int magic = 0;
            if (s.read(b) == 2) {
                magic = (b[1] & 0xFF) << 8 | b[0] & 0xFF;
            }
            return magic == 35615;
        }
        catch (IOException e) {
            throw new ErrorException(e);
        }
    }

    public static final boolean isGzipFile(File file) {
        try {
            FileInputStream s = new FileInputStream(file);
            boolean result = FileUtil.isGzipStream(s);
            ((InputStream)s).close();
            return result;
        }
        catch (IOException e) {
            throw new ErrorException(e);
        }
    }

    public static final boolean isGzipFile(String filename) {
        return FileUtil.isGzipFile(new File(filename));
    }

    public static final String[] getBaseAndExtension(File file) {
        String name = file.getName();
        int period = name.lastIndexOf(46);
        if (period == -1) {
            return new String[]{name, null};
        }
        return new String[]{name.substring(0, period), name.substring(period + 1)};
    }

    public static File makeTempCopy(File in) throws Exception {
        File f;
        int index = 0;
        String pathPrefix = in.getAbsolutePath();
        do {
            f = new File(pathPrefix + "temp_" + index);
            ++index;
        } while (f.exists());
        FileUtil.copyFile(in, f);
        return f;
    }

    public static final String readInputStream(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        return FileUtil.readReader(reader);
    }

    public static final String readReader(Reader reader) throws IOException {
        char[] buf = new char[4096];
        StringBuffer ret = new StringBuffer();
        int size = 0;
        do {
            if ((size = reader.read(buf)) == -1) continue;
            ret.append(buf, 0, size);
        } while (size != -1);
        return ret.toString();
    }

    public static final byte[] readFileAsBytes(String filename) throws IOException {
        File f = new File(filename);
        byte[] data = new byte[(int)f.length()];
        FileInputStream is = new FileInputStream(f);
        ((InputStream)is).read(data);
        ((InputStream)is).close();
        return data;
    }

    public static final String readFile(String filename) throws IOException {
        return FileUtil.readFile(new File(filename));
    }

    public static String[][] readFlatFile(String fileName) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        ArrayList<String[]> ret = new ArrayList<String[]>();
        while ((line = in.readLine()) != null) {
            if (line.trim().charAt(0) == '#') continue;
            ret.add(line.split("\t"));
        }
        return (String[][])ret.toArray((T[])new String[ret.size()][]);
    }

    public static String[][] readFlatFileWithComments(String fileName) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        ArrayList<String[]> ret = new ArrayList<String[]>();
        while ((line = in.readLine()) != null) {
            ret.add(line.split("\t"));
        }
        return (String[][])ret.toArray((T[])new String[ret.size()][]);
    }

    public static double[] readDoublesFromSingleTabbedLine(String fileName) throws IOException {
        String[][] s = FileUtil.readFlatFile(fileName);
        Assert.a(s.length == 1);
        int len = s[0].length;
        double[] ret = new double[len];
        for (int j = 0; j < len; ++j) {
            ret[j] = Double.parseDouble(s[0][j]);
        }
        return ret;
    }

    public static String[] readLines(String fileName) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        ArrayList<String> ret = new ArrayList<String>();
        while ((line = in.readLine()) != null) {
            ret.add(line);
        }
        return ret.toArray(new String[ret.size()]);
    }

    public static final void writeFile(File filename, String data) throws IOException {
        FileWriter fw = new FileWriter(filename);
        PrintWriter logWriter = new PrintWriter(fw);
        logWriter.print(data);
        fw.close();
    }

    public static final void writeObject(String filename, Object data) throws IOException {
        BufferedOutputStream fw = new BufferedOutputStream(new FileOutputStream(filename));
        ObjectOutputStream objectWriter = new ObjectOutputStream(fw);
        objectWriter.writeObject(data);
        objectWriter.close();
    }

    public static final Object readObject(String filename) throws IOException, ClassNotFoundException {
        FileInputStream fr = new FileInputStream(filename);
        ObjectInputStream objectIn = new ObjectInputStream(fr);
        Object object = objectIn.readObject();
        objectIn.close();
        return object;
    }

    public static final String fileRecordCompare(String expected, String actual, String maskingRegEx) throws IOException {
        String s;
        String s2;
        BufferedReader expectedReader = new BufferedReader(new FileReader(expected));
        HashMap<String, Integer> records = new HashMap<String, Integer>();
        while ((s2 = expectedReader.readLine()) != null) {
            Number count;
            if (maskingRegEx != null) {
                s2 = s2.replaceAll(maskingRegEx, "[!MASKED!]");
            }
            if ((count = (Number)records.get(s2)) == null) {
                records.put(s2, new Integer(1));
                continue;
            }
            records.put(s2, new Integer(count.intValue() + 1));
        }
        expectedReader.close();
        StringBuffer ret = new StringBuffer();
        BufferedReader actualReader = new BufferedReader(new FileReader(actual));
        while ((s = actualReader.readLine()) != null) {
            if (maskingRegEx != null) {
                s = s.replaceAll(maskingRegEx, "[!MASKED!]");
            }
            if (records.containsKey(s)) {
                Number count = (Number)records.get(s);
                if (count.intValue() == 1) {
                    records.remove(s);
                    continue;
                }
                records.put(s, new Integer(count.intValue() - 1));
                continue;
            }
            ret.append("+ " + s + "\n");
        }
        for (String element : records.keySet()) {
            ret.append("- " + element + "\n");
        }
        if (ret.length() == 0) {
            return null;
        }
        return ret.toString();
    }

    public static final String fileRecordCompare(String expected, String actual) throws IOException {
        return FileUtil.fileRecordCompare(expected, actual, null);
    }

    public static final void writeFile(String filename, String data) throws IOException {
        FileUtil.writeFile(new File(filename), data);
    }

    public static final String appendPath(String parent, String child) {
        String separator = "/";
        StringBuffer buf = new StringBuffer(parent);
        if (!parent.endsWith(separator)) {
            buf.append(separator);
        }
        if (child.startsWith(separator)) {
            buf.append(child.substring(1));
        } else {
            buf.append(child);
        }
        return buf.toString();
    }

    public static final void safeClose(Writer f) {
        try {
            if (f != null) {
                f.close();
            }
        }
        catch (IOException ex) {
            throw new ErrorException("Error closing writer: " + f, ex);
        }
    }

    public static final void safeClose(Reader f) {
        try {
            if (f != null) {
                f.close();
            }
        }
        catch (IOException ex) {
            throw new ErrorException("Error closing reader: " + f, ex);
        }
    }

    public static final void safeClose(OutputStream f) {
        try {
            if (f != null) {
                f.close();
            }
        }
        catch (IOException ex) {
            throw new ErrorException("Error closing outputStream: " + f, ex);
        }
    }

    public static final void safeClose(InputStream f) {
        try {
            if (f != null) {
                f.close();
            }
        }
        catch (IOException ex) {
            throw new ErrorException("Error closing inputStream: " + f, ex);
        }
    }

    public static final void safeClose(RandomAccessFile f) {
        try {
            if (f != null) {
                f.close();
            }
        }
        catch (IOException ex) {
            throw new ErrorException("Error closing randomAccessFile: " + f, ex);
        }
    }

    public static final FileLock lockFile(RandomAccessFile raf) {
        FileChannel ch = raf.getChannel();
        return FileUtil.doLock(ch);
    }

    public static final FileLock lockFile(FileOutputStream fos) {
        FileChannel ch = fos.getChannel();
        return FileUtil.doLock(ch);
    }

    private static final FileLock doLock(FileChannel ch) {
        FileLock lock;
        try {
            lock = ch.lock();
        }
        catch (IOException ex) {
            log.warn((Object)"File locking not supported on this platform. Continuing.");
            log.warn((Object)("If the file " + ch + " is in use by another process, " + "silent corruption may occur."));
            lock = null;
        }
        catch (Exception ex) {
            throw new ErrorException("Error trying to acquire lock on file. ", ex);
        }
        return lock;
    }

    public static final void safeRelease(FileLock lock) {
        try {
            if (lock != null) {
                lock.release();
            }
        }
        catch (IOException ex) {
            throw new ErrorException("Error releasing lock: " + lock, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte determineNewlineSize(File file) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        try {
            int count;
            byte[] data = new byte[1000];
            do {
                count = ((InputStream)stream).read(data);
                log.debug((Object)("byte read in " + file.getName() + " : " + count));
                for (int i = 0; i < count; ++i) {
                    if (data[i] == 10) {
                        log.debug((Object)"Found Newline");
                        byte by = 1;
                        return by;
                    }
                    if (data[i] != 13) continue;
                    log.debug((Object)"Found CarriageReturn");
                    int nextChar = i + 1 < count ? data[i + 1] : ((InputStream)stream).read();
                    byte by = (byte)(nextChar == 10 ? 2 : 1);
                    return by;
                }
            } while (count != -1);
            byte by = 1;
            return by;
        }
        finally {
            ((InputStream)stream).close();
        }
    }
}

