/*
 * Decompiled with CFR 0.152.
 */
package calhoun.util;

import calhoun.util.ConfigException;
import calhoun.util.ErrorException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceLoader {
    private static final Log log = LogFactory.getLog(ResourceLoader.class);
    private static ResourceFinder[] resourceFinders = new ResourceFinder[]{new FileSystem(), new ClassResource(), new SystemResource()};

    public static InputStream openInputStream(Class cls, String resourceID) {
        log.debug((Object)("Attempting to load resource " + resourceID));
        resourceID = resourceID.replace('\\', '/');
        for (int i = 0; i < resourceFinders.length; ++i) {
            log.debug((Object)("\tTrying resource finder " + resourceFinders[i]));
            InputStream is = resourceFinders[i].openResource(cls, resourceID);
            if (is == null) continue;
            log.debug((Object)"\tResource found");
            return is;
        }
        throw new ConfigException("Resource '" + resourceID + "' not found for " + cls);
    }

    public static String openTextResource(Class cls, String resourceId) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(ResourceLoader.openInputStream(cls, resourceId)));
            StringWriter writer = new StringWriter();
            PrintWriter print = new PrintWriter(writer);
            while ((line = reader.readLine()) != null) {
                print.println(line);
            }
            print.flush();
            return writer.toString();
        }
        catch (IOException x) {
            throw new ErrorException(x);
        }
    }

    static class SystemResource
    implements ResourceFinder {
        SystemResource() {
        }

        @Override
        public InputStream openResource(Class cls, String resourceID) {
            return cls.getClassLoader().getResourceAsStream(resourceID);
        }
    }

    static class ClassResource
    implements ResourceFinder {
        ClassResource() {
        }

        @Override
        public InputStream openResource(Class cls, String resourceID) {
            return cls.getResourceAsStream(resourceID);
        }
    }

    static class FileSystem
    implements ResourceFinder {
        FileSystem() {
        }

        @Override
        public InputStream openResource(Class cls, String resourceID) {
            File file = new File(resourceID);
            if (!file.exists() || !file.isFile()) {
                return null;
            }
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException x) {
                log.warn((Object)"Unable to open existing file as resource", (Throwable)x);
                return null;
            }
        }
    }

    public static interface ResourceFinder {
        public InputStream openResource(Class var1, String var2);
    }
}

