/*
 * Decompiled with CFR 0.152.
 */
package calhoun.util;

import calhoun.util.ConfigException;
import calhoun.util.ErrorException;
import calhoun.util.FileUtil;
import calhoun.util.ResourceLoader;
import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.zip.GZIPInputStream;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public final class XmlUtil {
    private static final Log log = LogFactory.getLog(XmlUtil.class);

    private XmlUtil() {
    }

    public static void transform(String input, String output, String stylesheet) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            StreamSource source = new StreamSource(ResourceLoader.openInputStream(XmlUtil.class, stylesheet));
            Templates templates = tFactory.newTemplates(source);
            Transformer transformer = templates.newTransformer();
            StreamSource sourceXML = new StreamSource(input);
            StreamResult result = new StreamResult(output);
            transformer.transform(sourceXML, result);
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
    }

    public static Document newDocument() {
        return DocumentHelper.createDocument();
    }

    public static Element newElement(String name) {
        return DocumentHelper.createElement((String)name);
    }

    public static Document parseFile(String filename) {
        try {
            SAXReader xmlReader = new SAXReader();
            FilterInputStream s = new BufferedInputStream(ResourceLoader.openInputStream(XmlUtil.class, filename));
            ((InputStream)s).mark(100);
            boolean isGzip = FileUtil.isGzipStream(s);
            ((InputStream)s).reset();
            if (isGzip) {
                s = new GZIPInputStream(s);
            }
            return xmlReader.read((InputStream)s);
        }
        catch (IOException e) {
            throw new ErrorException(e);
        }
        catch (DocumentException ex) {
            throw new ConfigException("Invalid XML file: ", ex);
        }
    }

    public static Document parseString(String data) {
        try {
            return DocumentHelper.parseText((String)data);
        }
        catch (DocumentException ex) {
            throw new ErrorException("Invalid XML data: ", ex);
        }
    }

    public static String prettyPrint(Document doc) {
        return XmlUtil.prettyPrint((Node)doc);
    }

    public static String prettyPrint(Node node) {
        StringWriter sw = new StringWriter();
        try {
            OutputFormat outformat = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((Writer)sw, outformat);
            writer.write(node);
            writer.flush();
        }
        catch (Exception ex) {
            throw new ErrorException("Error writing XML output ", ex);
        }
        return sw.toString();
    }

    public static void prettyPrint(Document doc, OutputStream out) {
        try {
            OutputFormat outformat = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter(out, outformat);
            writer.write(doc);
            writer.flush();
        }
        catch (Exception ex) {
            throw new ErrorException("Error writing XML output ", ex);
        }
    }

    public static void prettyPrint(Document doc, String filename) {
        try {
            FileOutputStream out = new FileOutputStream(filename);
            XmlUtil.prettyPrint(doc, out);
            ((OutputStream)out).close();
        }
        catch (IOException ex) {
            throw new ConfigException("Error saving XML to file ", ex);
        }
    }
}

