/*
 * Decompiled with CFR 0.152.
 */
package flanagan.math;

import java.util.Vector;

public class Fmath {
    public static final double N_AVAGADRO = 6.0221419947E23;
    public static final double K_BOLTZMANN = 1.380650324E-23;
    public static final double H_PLANCK = 6.6260687652E-34;
    public static final double H_PLANCK_RED = 1.0545715972483913E-34;
    public static final double C_LIGHT = 2.99792458E8;
    public static final double R_GAS = 8.31447215;
    public static final double F_FARADAY = 96485.341539;
    public static final double T_ABS = -273.15;
    public static final double Q_ELECTRON = -1.60217646263E-19;
    public static final double M_ELECTRON = 9.1093818872E-31;
    public static final double M_PROTON = 1.6726215813E-27;
    public static final double M_NEUTRON = 1.6749271613E-27;
    public static final double EPSILON_0 = 8.854187817E-12;
    public static final double MU_0 = 1.2566370614359173E-6;
    public static final double EULER_CONSTANT_GAMMA = 0.5772156649015627;

    public static double log10(double a) {
        return Math.log(a) / Math.log(10.0);
    }

    public static float log10(float a) {
        double aa = a;
        return (float)(Math.log(aa) / Math.log(10.0));
    }

    public static double square(double a) {
        return a * a;
    }

    public static float square(float a) {
        return a * a;
    }

    public static int square(int a) {
        return a * a;
    }

    public static int factorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n must be a positive integer");
        }
        if (n > 12) {
            throw new IllegalArgumentException("n must less than 13 to avoid integer overflow\nTry long or double argument");
        }
        int f = 1;
        for (int i = 1; i <= n; ++i) {
            f *= i;
        }
        return f;
    }

    public static long factorial(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("n must be a positive integer");
        }
        if (n > 20L) {
            throw new IllegalArgumentException("n must less than 21 to avoid long integer overflow\nTry double argument");
        }
        long f = 1L;
        int i = 1;
        while ((long)i <= n) {
            f *= (long)i;
            ++i;
        }
        return f;
    }

    public static double factorial(double n) {
        if (n < 0.0 || n - (double)((int)n) != 0.0) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        double f = 1.0;
        int nn = (int)n;
        for (int i = 1; i <= nn; ++i) {
            f *= (double)i;
        }
        return f;
    }

    public static double logFactorial(int n) {
        if (n < 0 || n - n != 0) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        double f = 0.0;
        for (int i = 2; i <= n; ++i) {
            f += Math.log(i);
        }
        return f;
    }

    public static double logFactorial(double n) {
        if (n < 0.0 || n - (double)((int)n) != 0.0) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        double f = 0.0;
        int nn = (int)n;
        for (int i = 2; i <= nn; ++i) {
            f += Math.log(i);
        }
        return f;
    }

    public static double maximum(double[] aa) {
        int n = aa.length;
        double aamax = aa[0];
        for (int i = 1; i < n; ++i) {
            if (!(aa[i] > aamax)) continue;
            aamax = aa[i];
        }
        return aamax;
    }

    public static float maximum(float[] aa) {
        int n = aa.length;
        float aamax = aa[0];
        for (int i = 1; i < n; ++i) {
            if (!(aa[i] > aamax)) continue;
            aamax = aa[i];
        }
        return aamax;
    }

    public static int maximum(int[] aa) {
        int n = aa.length;
        int aamax = aa[0];
        for (int i = 1; i < n; ++i) {
            if (aa[i] <= aamax) continue;
            aamax = aa[i];
        }
        return aamax;
    }

    public static long maximum(long[] aa) {
        long n = aa.length;
        long aamax = aa[0];
        int i = 1;
        while ((long)i < n) {
            if (aa[i] > aamax) {
                aamax = aa[i];
            }
            ++i;
        }
        return aamax;
    }

    public static double minimum(double[] aa) {
        int n = aa.length;
        double aamin = aa[0];
        for (int i = 1; i < n; ++i) {
            if (!(aa[i] < aamin)) continue;
            aamin = aa[i];
        }
        return aamin;
    }

    public static float minimum(float[] aa) {
        int n = aa.length;
        float aamin = aa[0];
        for (int i = 1; i < n; ++i) {
            if (!(aa[i] < aamin)) continue;
            aamin = aa[i];
        }
        return aamin;
    }

    public static int minimum(int[] aa) {
        int n = aa.length;
        int aamin = aa[0];
        for (int i = 1; i < n; ++i) {
            if (aa[i] >= aamin) continue;
            aamin = aa[i];
        }
        return aamin;
    }

    public static long minimum(long[] aa) {
        long n = aa.length;
        long aamin = aa[0];
        int i = 1;
        while ((long)i < n) {
            if (aa[i] < aamin) {
                aamin = aa[i];
            }
            ++i;
        }
        return aamin;
    }

    public static double[] reverseArray(double[] aa) {
        int n = aa.length;
        double[] bb = new double[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[n - 1 - i];
        }
        return bb;
    }

    public static float[] reverseArray(float[] aa) {
        int n = aa.length;
        float[] bb = new float[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[n - 1 - i];
        }
        return bb;
    }

    public static int[] reverseArray(int[] aa) {
        int n = aa.length;
        int[] bb = new int[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[n - 1 - i];
        }
        return bb;
    }

    public static long[] reverseArray(long[] aa) {
        int n = aa.length;
        long[] bb = new long[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[n - 1 - i];
        }
        return bb;
    }

    public static char[] reverseArray(char[] aa) {
        int n = aa.length;
        char[] bb = new char[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[n - 1 - i];
        }
        return bb;
    }

    public static double[] arrayAbs(double[] aa) {
        int n = aa.length;
        double[] bb = new double[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = Math.abs(aa[i]);
        }
        return bb;
    }

    public static float[] arrayAbs(float[] aa) {
        int n = aa.length;
        float[] bb = new float[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = Math.abs(aa[i]);
        }
        return bb;
    }

    public static long[] arrayAbs(long[] aa) {
        int n = aa.length;
        long[] bb = new long[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = Math.abs(aa[i]);
        }
        return bb;
    }

    public static int[] arrayAbs(int[] aa) {
        int n = aa.length;
        int[] bb = new int[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = Math.abs(aa[i]);
        }
        return bb;
    }

    public static double[] arrayMultByConstant(double[] aa, double constant) {
        int n = aa.length;
        double[] bb = new double[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i] * constant;
        }
        return bb;
    }

    public static double[] arrayMultByConstant(int[] aa, double constant) {
        int n = aa.length;
        double[] bb = new double[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = (double)aa[i] * constant;
        }
        return bb;
    }

    public static double[] arrayMultByConstant(double[] aa, int constant) {
        int n = aa.length;
        double[] bb = new double[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i] * (double)constant;
        }
        return bb;
    }

    public static double[] arrayMultByConstant(int[] aa, int constant) {
        int n = aa.length;
        double[] bb = new double[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i] * constant;
        }
        return bb;
    }

    public static double nearestElementValue(double[] array, double value) {
        double diff = Math.abs(array[0] - value);
        double nearest = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (!(Math.abs(array[i] - value) < diff)) continue;
            diff = Math.abs(array[i] - value);
            nearest = array[i];
        }
        return nearest;
    }

    public static int nearestElementIndex(double[] array, double value) {
        double diff = Math.abs(array[0] - value);
        int nearest = 0;
        for (int i = 1; i < array.length; ++i) {
            if (!(Math.abs(array[i] - value) < diff)) continue;
            diff = Math.abs(array[i] - value);
            nearest = i;
        }
        return nearest;
    }

    public static double nearestLowerElementValue(double[] array, double value) {
        double diff0 = 0.0;
        double diff1 = 0.0;
        double nearest = 0.0;
        int ii = 0;
        boolean test = true;
        double min = array[0];
        while (test) {
            if (array[ii] < min) {
                min = array[ii];
            }
            if (value - array[ii] >= 0.0) {
                diff0 = value - array[ii];
                nearest = array[ii];
                test = false;
                continue;
            }
            if (++ii <= array.length - 1) continue;
            nearest = min;
            diff0 = min - value;
            test = false;
        }
        for (int i = 0; i < array.length; ++i) {
            diff1 = value - array[i];
            if (!(diff1 >= 0.0) || !(diff1 < diff0)) continue;
            diff0 = diff1;
            nearest = array[i];
        }
        return nearest;
    }

    public static int nearestLowerElementIndex(double[] array, double value) {
        double diff0 = 0.0;
        double diff1 = 0.0;
        int nearest = 0;
        int ii = 0;
        boolean test = true;
        double min = array[0];
        int minI = 0;
        while (test) {
            if (array[ii] < min) {
                min = array[ii];
                minI = ii;
            }
            if (value - array[ii] >= 0.0) {
                diff0 = value - array[ii];
                nearest = ii;
                test = false;
                continue;
            }
            if (++ii <= array.length - 1) continue;
            nearest = minI;
            diff0 = min - value;
            test = false;
        }
        for (int i = 0; i < array.length; ++i) {
            diff1 = value - array[i];
            if (!(diff1 >= 0.0) || !(diff1 < diff0)) continue;
            diff0 = diff1;
            nearest = i;
        }
        return nearest;
    }

    public static double nearestHigherElementValue(double[] array, double value) {
        double diff0 = 0.0;
        double diff1 = 0.0;
        double nearest = 0.0;
        int ii = 0;
        boolean test = true;
        double max = array[0];
        while (test) {
            if (array[ii] > max) {
                max = array[ii];
            }
            if (array[ii] - value >= 0.0) {
                diff0 = value - array[ii];
                nearest = array[ii];
                test = false;
                continue;
            }
            if (++ii <= array.length - 1) continue;
            nearest = max;
            diff0 = value - max;
            test = false;
        }
        for (int i = 0; i < array.length; ++i) {
            diff1 = array[i] - value;
            if (!(diff1 >= 0.0) || !(diff1 < diff0)) continue;
            diff0 = diff1;
            nearest = array[i];
        }
        return nearest;
    }

    public static int nearestHigherElementIndex(double[] array, double value) {
        double diff0 = 0.0;
        double diff1 = 0.0;
        int nearest = 0;
        int ii = 0;
        boolean test = true;
        double max = array[0];
        int maxI = 0;
        while (test) {
            if (array[ii] > max) {
                max = array[ii];
                maxI = ii;
            }
            if (array[ii] - value >= 0.0) {
                diff0 = value - array[ii];
                nearest = ii;
                test = false;
                continue;
            }
            if (++ii <= array.length - 1) continue;
            nearest = maxI;
            diff0 = value - max;
            test = false;
        }
        for (int i = 0; i < array.length; ++i) {
            diff1 = array[i] - value;
            if (!(diff1 >= 0.0) || !(diff1 < diff0)) continue;
            diff0 = diff1;
            nearest = i;
        }
        return nearest;
    }

    public static int nearestElementValue(int[] array, int value) {
        int diff = Math.abs(array[0] - value);
        int nearest = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (Math.abs(array[i] - value) >= diff) continue;
            diff = Math.abs(array[i] - value);
            nearest = array[i];
        }
        return nearest;
    }

    public static int nearestElementIndex(int[] array, int value) {
        int diff = Math.abs(array[0] - value);
        int nearest = 0;
        for (int i = 1; i < array.length; ++i) {
            if (Math.abs(array[i] - value) >= diff) continue;
            diff = Math.abs(array[i] - value);
            nearest = i;
        }
        return nearest;
    }

    public static int nearestLowerElementValue(int[] array, int value) {
        int diff0 = 0;
        int diff1 = 0;
        int nearest = 0;
        int ii = 0;
        boolean test = true;
        int min = array[0];
        while (test) {
            if (array[ii] < min) {
                min = array[ii];
            }
            if (value - array[ii] >= 0) {
                diff0 = value - array[ii];
                nearest = array[ii];
                test = false;
                continue;
            }
            if (++ii <= array.length - 1) continue;
            nearest = min;
            diff0 = min - value;
            test = false;
        }
        for (int i = 0; i < array.length; ++i) {
            diff1 = value - array[i];
            if (diff1 < 0 || diff1 >= diff0) continue;
            diff0 = diff1;
            nearest = array[i];
        }
        return nearest;
    }

    public static int nearestLowerElementIndex(int[] array, int value) {
        int diff0 = 0;
        int diff1 = 0;
        int nearest = 0;
        int ii = 0;
        boolean test = true;
        int min = array[0];
        int minI = 0;
        while (test) {
            if (array[ii] < min) {
                min = array[ii];
                minI = ii;
            }
            if (value - array[ii] >= 0) {
                diff0 = value - array[ii];
                nearest = ii;
                test = false;
                continue;
            }
            if (++ii <= array.length - 1) continue;
            nearest = minI;
            diff0 = min - value;
            test = false;
        }
        for (int i = 0; i < array.length; ++i) {
            diff1 = value - array[i];
            if (diff1 < 0 || diff1 >= diff0) continue;
            diff0 = diff1;
            nearest = i;
        }
        return nearest;
    }

    public static int nearestHigherElementValue(int[] array, int value) {
        int diff0 = 0;
        int diff1 = 0;
        int nearest = 0;
        int ii = 0;
        boolean test = true;
        int max = array[0];
        while (test) {
            if (array[ii] > max) {
                max = array[ii];
            }
            if (array[ii] - value >= 0) {
                diff0 = value - array[ii];
                nearest = array[ii];
                test = false;
                continue;
            }
            if (++ii <= array.length - 1) continue;
            nearest = max;
            diff0 = value - max;
            test = false;
        }
        for (int i = 0; i < array.length; ++i) {
            diff1 = array[i] - value;
            if (diff1 < 0 || diff1 >= diff0) continue;
            diff0 = diff1;
            nearest = array[i];
        }
        return nearest;
    }

    public static int nearestHigherElementIndex(int[] array, int value) {
        int diff0 = 0;
        int diff1 = 0;
        int nearest = 0;
        int ii = 0;
        boolean test = true;
        int max = array[0];
        int maxI = 0;
        while (test) {
            if (array[ii] > max) {
                max = array[ii];
                maxI = ii;
            }
            if (array[ii] - value >= 0) {
                diff0 = value - array[ii];
                nearest = ii;
                test = false;
                continue;
            }
            if (++ii <= array.length - 1) continue;
            nearest = maxI;
            diff0 = value - max;
            test = false;
        }
        for (int i = 0; i < array.length; ++i) {
            diff1 = array[i] - value;
            if (diff1 < 0 || diff1 >= diff0) continue;
            diff0 = diff1;
            nearest = i;
        }
        return nearest;
    }

    public static double[] floatTOdouble(float[] aa) {
        int n = aa.length;
        double[] bb = new double[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static double[] intTOdouble(int[] aa) {
        int n = aa.length;
        double[] bb = new double[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static float[] intTOfloat(int[] aa) {
        int n = aa.length;
        float[] bb = new float[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static long[] intTOlong(int[] aa) {
        int n = aa.length;
        long[] bb = new long[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static double[] longTOdouble(long[] aa) {
        int n = aa.length;
        double[] bb = new double[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static float[] longTOfloat(long[] aa) {
        int n = aa.length;
        float[] bb = new float[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static double[] shortTOdouble(short[] aa) {
        int n = aa.length;
        double[] bb = new double[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static float[] shortTOfloat(short[] aa) {
        int n = aa.length;
        float[] bb = new float[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static long[] shortTOlong(short[] aa) {
        int n = aa.length;
        long[] bb = new long[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static int[] shortTOint(short[] aa) {
        int n = aa.length;
        int[] bb = new int[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static double[] byteTOdouble(byte[] aa) {
        int n = aa.length;
        double[] bb = new double[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static float[] byteTOfloat(byte[] aa) {
        int n = aa.length;
        float[] bb = new float[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static long[] byteTOlong(byte[] aa) {
        int n = aa.length;
        long[] bb = new long[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static int[] byteTOint(byte[] aa) {
        int n = aa.length;
        int[] bb = new int[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static short[] byteTOshort(byte[] aa) {
        int n = aa.length;
        short[] bb = new short[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static int[] doubleTOint(double[] aa) {
        int n = aa.length;
        int[] bb = new int[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = (int)aa[i];
        }
        return bb;
    }

    public static void print(double[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.print(aa[i] + "   ");
        }
        System.out.println();
    }

    public static void println(double[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.println(aa[i] + "   ");
        }
    }

    public static void print(float[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.print(aa[i] + "   ");
        }
        System.out.println();
    }

    public static void println(float[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.println(aa[i] + "   ");
        }
    }

    public static void print(int[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.print(aa[i] + "   ");
        }
        System.out.println();
    }

    public static void println(int[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.println(aa[i] + "   ");
        }
    }

    public static void print(long[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.print(aa[i] + "   ");
        }
        System.out.println();
    }

    public static void println(long[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.println(aa[i] + "   ");
        }
    }

    public static void print(char[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.print(aa[i] + "   ");
        }
        System.out.println();
    }

    public static void println(char[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.println(aa[i] + "   ");
        }
    }

    public static void print(String[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.print(aa[i] + "   ");
        }
        System.out.println();
    }

    public static void println(String[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.println(aa[i] + "   ");
        }
    }

    public static Vector selectSortVector(double[] aa) {
        int i;
        int index = 0;
        int lastIndex = -1;
        int n = aa.length;
        double holdb = 0.0;
        int holdi = 0;
        double[] bb = new double[n];
        int[] indices = new int[n];
        for (i = 0; i < n; ++i) {
            bb[i] = aa[i];
            indices[i] = i;
        }
        while (lastIndex != n - 1) {
            index = lastIndex + 1;
            for (i = lastIndex + 2; i < n; ++i) {
                if (!(bb[i] < bb[index])) continue;
                index = i;
            }
            holdb = bb[index];
            bb[index] = bb[++lastIndex];
            bb[lastIndex] = holdb;
            holdi = indices[index];
            indices[index] = indices[lastIndex];
            indices[lastIndex] = holdi;
        }
        Vector<double[]> vec = new Vector<double[]>();
        vec.addElement(aa);
        vec.addElement(bb);
        vec.addElement(indices);
        return vec;
    }

    public static double[] selectionSort(double[] aa) {
        int i;
        int index = 0;
        int lastIndex = -1;
        int n = aa.length;
        double hold = 0.0;
        double[] bb = new double[n];
        for (i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        while (lastIndex != n - 1) {
            index = lastIndex + 1;
            for (i = lastIndex + 2; i < n; ++i) {
                if (!(bb[i] < bb[index])) continue;
                index = i;
            }
            hold = bb[index];
            bb[index] = bb[++lastIndex];
            bb[lastIndex] = hold;
        }
        return bb;
    }

    public static float[] selectionSort(float[] aa) {
        int i;
        int index = 0;
        int lastIndex = -1;
        int n = aa.length;
        float hold = 0.0f;
        float[] bb = new float[n];
        for (i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        while (lastIndex != n - 1) {
            index = lastIndex + 1;
            for (i = lastIndex + 2; i < n; ++i) {
                if (!(bb[i] < bb[index])) continue;
                index = i;
            }
            hold = bb[index];
            bb[index] = bb[++lastIndex];
            bb[lastIndex] = hold;
        }
        return bb;
    }

    public static int[] selectionSort(int[] aa) {
        int i;
        int index = 0;
        int lastIndex = -1;
        int n = aa.length;
        int hold = 0;
        int[] bb = new int[n];
        for (i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        while (lastIndex != n - 1) {
            index = lastIndex + 1;
            for (i = lastIndex + 2; i < n; ++i) {
                if (bb[i] >= bb[index]) continue;
                index = i;
            }
            hold = bb[index];
            bb[index] = bb[++lastIndex];
            bb[lastIndex] = hold;
        }
        return bb;
    }

    public static long[] selectionSort(long[] aa) {
        int i;
        int index = 0;
        int lastIndex = -1;
        int n = aa.length;
        long hold = 0L;
        long[] bb = new long[n];
        for (i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        while (lastIndex != n - 1) {
            index = lastIndex + 1;
            for (i = lastIndex + 2; i < n; ++i) {
                if (bb[i] >= bb[index]) continue;
                index = i;
            }
            hold = bb[index];
            bb[index] = bb[++lastIndex];
            bb[lastIndex] = hold;
        }
        return bb;
    }

    public static double sign(double x) {
        if (x < 0.0) {
            return -1.0;
        }
        return 1.0;
    }

    public static float sign(float x) {
        if (x < 0.0f) {
            return -1.0f;
        }
        return 1.0f;
    }

    public static int sign(int x) {
        if (x < 0) {
            return -1;
        }
        return 1;
    }

    public static long sign(long x) {
        if (x < 0L) {
            return -1L;
        }
        return 1L;
    }

    public static double radToDeg(double rad) {
        return rad * 180.0 / Math.PI;
    }

    public static double degToRad(double deg) {
        return deg * Math.PI / 180.0;
    }

    public static double evToNm(double ev) {
        return 2.99792458E17 / (-ev * -1.60217646263E-19 / 6.6260687652E-34);
    }

    public static double nmToEv(double nm) {
        return 2.99792458E8 / (-nm * 1.0E-9) * 6.6260687652E-34 / -1.60217646263E-19;
    }

    public static double molarToPercentWeightByVol(double molar, double molWeight) {
        return molar * molWeight / 10.0;
    }

    public static double percentWeightByVolToMolar(double perCent, double molWeight) {
        return perCent * 10.0 / molWeight;
    }

    public static double celsiusToKelvin(double cels) {
        return cels - -273.15;
    }

    public static double kelvinToCelsius(double kelv) {
        return kelv + -273.15;
    }

    public static double celsiusToFahren(double cels) {
        return cels * 1.8 + 32.0;
    }

    public static double fahrenToCelsius(double fahr) {
        return (fahr - 32.0) * 5.0 / 9.0;
    }

    public static double calorieToJoule(double cal) {
        return cal * 4.1868;
    }

    public static double jouleToCalorie(double joule) {
        return joule * 0.23884;
    }

    public static double gramToOunce(double gm) {
        return gm / 28.3459;
    }

    public static double ounceToGram(double oz) {
        return oz * 28.3459;
    }

    public static double kgToPound(double kg) {
        return kg / 0.4536;
    }

    public static double poundToKg(double pds) {
        return pds * 0.4536;
    }

    public static double kgToTon(double kg) {
        return kg / 1016.05;
    }

    public static double tonToKg(double tons) {
        return tons * 1016.05;
    }

    public static double millimetreToInch(double mm) {
        return mm / 25.4;
    }

    public static double inchToMillimetre(double in) {
        return in * 25.4;
    }

    public static double footToMetre(double ft) {
        return ft * 0.3048;
    }

    public static double metreToFoot(double metre) {
        return metre / 0.3048;
    }

    public static double yardToMetre(double yd) {
        return yd * 0.9144;
    }

    public static double metreToYard(double metre) {
        return metre / 0.9144;
    }

    public static double mileToKm(double mile) {
        return mile * 1.6093;
    }

    public static double kmToMile(double km) {
        return km / 1.6093;
    }

    public static double gallonToLitre(double gall) {
        return gall * 4.546;
    }

    public static double litreToGallon(double litre) {
        return litre / 4.546;
    }

    public static double quartToLitre(double quart) {
        return quart * 1.137;
    }

    public static double litreToQuart(double litre) {
        return litre / 1.137;
    }

    public static double pintToLitre(double pint) {
        return pint * 0.568;
    }

    public static double litreToPint(double litre) {
        return litre / 0.568;
    }

    public static double gallonPerMileToLitrePerKm(double gallPmile) {
        return gallPmile * 2.825;
    }

    public static double litrePerKmToGallonPerMile(double litrePkm) {
        return litrePkm / 2.825;
    }

    public static double milePerGallonToKmPerLitre(double milePgall) {
        return milePgall * 0.354;
    }

    public static double kmPerLitreToMilePerGallon(double kmPlitre) {
        return kmPlitre / 0.354;
    }

    public static double fluidOunceUKtoUS(double flOzUK) {
        return flOzUK * 0.961;
    }

    public static double fluidOunceUStoUK(double flOzUS) {
        return flOzUS * 1.041;
    }

    public static double pintUKtoUS(double pintUK) {
        return pintUK * 1.201;
    }

    public static double pintUStoUK(double pintUS) {
        return pintUS * 0.833;
    }

    public static double quartUKtoUS(double quartUK) {
        return quartUK * 1.201;
    }

    public static double quartUStoUK(double quartUS) {
        return quartUS * 0.833;
    }

    public static double gallonUKtoUS(double gallonUK) {
        return gallonUK * 1.201;
    }

    public static double gallonUStoUK(double gallonUS) {
        return gallonUS * 0.833;
    }

    public static double pintUKtoCupUS(double pintUK) {
        return pintUK / 0.417;
    }

    public static double cupUStoPintUK(double cupUS) {
        return cupUS * 0.417;
    }

    public static double calcBMImetric(double height, double weight) {
        return weight / (height * height);
    }

    public static double calcBMIimperial(double height, double weight) {
        height = Fmath.footToMetre(height);
        weight = Fmath.poundToKg(weight);
        return weight / (height * height);
    }

    public static double calcWeightFromBMImetric(double bmi, double height) {
        return bmi * height * height;
    }

    public static double calcWeightFromBMIimperial(double bmi, double height) {
        height = Fmath.footToMetre(height);
        double weight = bmi * height * height;
        weight = Fmath.kgToPound(weight);
        return weight;
    }

    public static double hypot(double aa, double bb) {
        double amod = Math.abs(aa);
        double bmod = Math.abs(bb);
        double cc = 0.0;
        double ratio = 0.0;
        if (amod == 0.0) {
            cc = bmod;
        } else if (bmod == 0.0) {
            cc = amod;
        } else if (amod >= bmod) {
            ratio = bmod / amod;
            cc = amod * Math.sqrt(1.0 + ratio * ratio);
        } else {
            ratio = amod / bmod;
            cc = bmod * Math.sqrt(1.0 + ratio * ratio);
        }
        return cc;
    }

    public static float hypot(float aa, float bb) {
        return (float)Fmath.hypot((double)aa, (double)bb);
    }

    public static double angle(double xAtA, double yAtA, double xAtB, double yAtB, double xAtC, double yAtC) {
        double ccos = Fmath.cos(xAtA, yAtA, xAtB, yAtB, xAtC, yAtC);
        return Math.acos(ccos);
    }

    public static double angle(double sideAC, double sideBC, double sideAB) {
        double ccos = Fmath.cos(sideAC, sideBC, sideAB);
        return Math.acos(ccos);
    }

    public static double sin(double xAtA, double yAtA, double xAtB, double yAtB, double xAtC, double yAtC) {
        double angle = Fmath.angle(xAtA, yAtA, xAtB, yAtB, xAtC, yAtC);
        return Math.sin(angle);
    }

    public static double sin(double sideAC, double sideBC, double sideAB) {
        double angle = Fmath.angle(sideAC, sideBC, sideAB);
        return Math.sin(angle);
    }

    public static double sin(double arg) {
        return Math.sin(arg);
    }

    public static double asin(double a) {
        if (a < -1.0 && a > 1.0) {
            throw new IllegalArgumentException("Fmath.asin argument (" + a + ") must be >= -1.0 and <= 1.0");
        }
        return Math.asin(a);
    }

    public static double cos(double xAtA, double yAtA, double xAtB, double yAtB, double xAtC, double yAtC) {
        double sideAC = Fmath.hypot(xAtA - xAtC, yAtA - yAtC);
        double sideBC = Fmath.hypot(xAtB - xAtC, yAtB - yAtC);
        double sideAB = Fmath.hypot(xAtA - xAtB, yAtA - yAtB);
        return Fmath.cos(sideAC, sideBC, sideAB);
    }

    public static double cos(double sideAC, double sideBC, double sideAB) {
        return 0.5 * (sideAC / sideBC + sideBC / sideAC - sideAB / sideAC * (sideAB / sideBC));
    }

    public static double cos(double arg) {
        return Math.cos(arg);
    }

    public static double acos(double a) {
        if (a < -1.0 || a > 1.0) {
            throw new IllegalArgumentException("Fmath.acos argument (" + a + ") must be >= -1.0 and <= 1.0");
        }
        return Math.acos(a);
    }

    public static double tan(double xAtA, double yAtA, double xAtB, double yAtB, double xAtC, double yAtC) {
        double angle = Fmath.angle(xAtA, yAtA, xAtB, yAtB, xAtC, yAtC);
        return Math.tan(angle);
    }

    public static double tan(double sideAC, double sideBC, double sideAB) {
        double angle = Fmath.angle(sideAC, sideBC, sideAB);
        return Math.tan(angle);
    }

    public static double tan(double arg) {
        return Math.tan(arg);
    }

    public static double atan(double a) {
        return Math.atan(a);
    }

    public static double atan2(double a, double b) {
        return Math.atan2(a, b);
    }

    public static double cot(double a) {
        return 1.0 / Math.tan(a);
    }

    public static double acot(double a) {
        return Math.atan(1.0 / a);
    }

    public static double acot2(double a, double b) {
        return Math.atan2(b, a);
    }

    public static double sec(double a) {
        return 1.0 / Math.cos(a);
    }

    public static double asec(double a) {
        if (a < 1.0 && a > -1.0) {
            throw new IllegalArgumentException("asec argument (" + a + ") must be >= 1 or <= -1");
        }
        return Math.acos(1.0 / a);
    }

    public static double csc(double a) {
        return 1.0 / Math.sin(a);
    }

    public static double acsc(double a) {
        if (a < 1.0 && a > -1.0) {
            throw new IllegalArgumentException("acsc argument (" + a + ") must be >= 1 or <= -1");
        }
        return Math.asin(1.0 / a);
    }

    public static double exsec(double a) {
        return 1.0 / Math.cos(a) - 1.0;
    }

    public static double aexsec(double a) {
        if (a < 0.0 && a > -2.0) {
            throw new IllegalArgumentException("aexsec argument (" + a + ") must be >= 0.0 and <= -2");
        }
        return Math.asin(1.0 / (1.0 + a));
    }

    public static double vers(double a) {
        return 1.0 - Math.cos(a);
    }

    public static double avers(double a) {
        if (a < 0.0 && a > 2.0) {
            throw new IllegalArgumentException("avers argument (" + a + ") must be <= 2 and >= 0");
        }
        return Math.acos(1.0 - a);
    }

    public static double covers(double a) {
        return 1.0 - Math.sin(a);
    }

    public static double acovers(double a) {
        if (a < 0.0 && a > 2.0) {
            throw new IllegalArgumentException("acovers argument (" + a + ") must be <= 2 and >= 0");
        }
        return Math.asin(1.0 - a);
    }

    public static double hav(double a) {
        return 0.5 * Fmath.vers(a);
    }

    public static double ahav(double a) {
        if (a < 0.0 && a > 1.0) {
            throw new IllegalArgumentException("ahav argument (" + a + ") must be >= 0 and <= 1");
        }
        return 0.5 * Fmath.vers(a);
    }

    public static double sinc(double a) {
        if (Math.abs(a) < 1.0E-40) {
            return 1.0;
        }
        return Math.sin(a) / a;
    }

    public static double sinh(double a) {
        return 0.5 * (Math.exp(a) - Math.exp(-a));
    }

    public static double asinh(double a) {
        double sgn = 1.0;
        if (a < 0.0) {
            sgn = -1.0;
            a = -a;
        }
        return sgn * Math.log(a + Math.sqrt(a * a + 1.0));
    }

    public static double cosh(double a) {
        return 0.5 * (Math.exp(a) + Math.exp(-a));
    }

    public static double acosh(double a) {
        if (a < 1.0) {
            throw new IllegalArgumentException("acosh real number argument (" + a + ") must be >= 1");
        }
        return Math.log(a + Math.sqrt(a * a - 1.0));
    }

    public static double tanh(double a) {
        return Fmath.sinh(a) / Fmath.cosh(a);
    }

    public static double atanh(double a) {
        double sgn = 1.0;
        if (a < 0.0) {
            sgn = -1.0;
            a = -a;
        }
        if (a > 1.0) {
            throw new IllegalArgumentException("atanh real number argument (" + sgn * a + ") must be >= -1 and <= 1");
        }
        return 0.5 * sgn * (Math.log(1.0 + a) - Math.log(1.0 - a));
    }

    public static double coth(double a) {
        return 1.0 / Fmath.tanh(a);
    }

    public static double acoth(double a) {
        double sgn = 1.0;
        if (a < 0.0) {
            sgn = -1.0;
            a = -a;
        }
        if (a < 1.0) {
            throw new IllegalArgumentException("acoth real number argument (" + sgn * a + ") must be <= -1 or >= 1");
        }
        return 0.5 * sgn * (Math.log(1.0 + a) - Math.log(a - 1.0));
    }

    public static double sech(double a) {
        return 1.0 / Fmath.cosh(a);
    }

    public static double asech(double a) {
        if (a > 1.0 || a < 0.0) {
            throw new IllegalArgumentException("asech real number argument (" + a + ") must be >= 0 and <= 1");
        }
        return 0.5 * Math.log(1.0 / a + Math.sqrt(1.0 / (a * a) - 1.0));
    }

    public static double csch(double a) {
        return 1.0 / Fmath.sinh(a);
    }

    public static double acsch(double a) {
        double sgn = 1.0;
        if (a < 0.0) {
            sgn = -1.0;
            a = -a;
        }
        return 0.5 * sgn * Math.log(1.0 / a + Math.sqrt(1.0 / (a * a) + 1.0));
    }

    public static double truncate(double x, int prec) {
        if (prec < 0) {
            return x;
        }
        if (x == 0.0) {
            return x;
        }
        if (Fmath.isNaN(x)) {
            return x;
        }
        if (Fmath.isPlusInfinity(x)) {
            return x;
        }
        if (Fmath.isMinusInfinity(x)) {
            return x;
        }
        if (x == Double.POSITIVE_INFINITY || x == Double.NEGATIVE_INFINITY) {
            return x;
        }
        String ss = "";
        String newss = "";
        Double xx = new Double(x);
        ss = xx.toString();
        newss = Fmath.ssround(ss, prec);
        return Double.parseDouble(newss);
    }

    public static float truncate(float x, int prec) {
        if (prec < 0) {
            return x;
        }
        if (x == 0.0f) {
            return x;
        }
        if (Fmath.isNaN(x)) {
            return x;
        }
        if (Fmath.isPlusInfinity(x)) {
            return x;
        }
        if (Fmath.isMinusInfinity(x)) {
            return x;
        }
        String ss = "";
        String newss = "";
        Float xx = new Float(x);
        ss = xx.toString();
        newss = Fmath.ssround(ss, prec);
        return Float.parseFloat(newss);
    }

    private static String ssround(String ss, int prec) {
        String newss1 = "";
        String newss2 = "";
        String newss3 = "";
        int posdot = 0;
        int pose = 0;
        int posf = 0;
        int posplace = 0;
        if (prec < 0) {
            throw new IllegalArgumentException("precision less than zero places");
        }
        posf = ss.length() - 1;
        pose = ss.indexOf(69);
        posdot = ss.indexOf(46);
        posplace = posdot + prec;
        if (pose > 0) {
            newss1 = posplace < pose ? (posplace + 1 < pose ? Fmath.subround(ss.substring(0, posplace + 2)) : ss.substring(0, posplace + 1)) : ss.substring(0, pose);
            newss2 = ss.substring(pose, posf + 1);
            newss3 = newss1.concat(newss2);
        } else {
            newss3 = posplace < posf ? (posplace + 1 <= posf ? Fmath.subround(ss.substring(0, posplace + 2)) : ss.substring(0, posplace + 1)) : ss;
        }
        return newss3;
    }

    private static String subround(String ss) {
        int ii = 0;
        int jj = 0;
        int posdot = 0;
        int n = ss.length();
        int[] iss = new int[n + 1];
        boolean finish = false;
        String newss = "";
        posdot = ss.indexOf(46);
        for (int i = 0; i < n; ++i) {
            iss[i] = ss.charAt(i);
        }
        if (iss[n - 1] < 52) {
            finish = true;
        }
        ii = n - 2;
        while (!finish) {
            jj = ii;
            if (jj == posdot) {
                // empty if block
            }
            int n2 = --jj;
            iss[n2] = iss[n2] + 1;
            if (iss[jj] < 58) {
                finish = true;
            } else if (jj + 1 == posdot) {
                for (int k = n - 1; k >= posdot; --k) {
                    iss[k + 1] = iss[k];
                }
                iss[posdot] = 48;
                iss[posdot - 1] = 49;
                ++n;
                finish = true;
            } else {
                iss[jj] = 48;
            }
            --ii;
        }
        StringBuffer strbuff = new StringBuffer();
        for (int k = 0; k < n - 1; ++k) {
            strbuff.append((char)iss[k]);
        }
        newss = strbuff.toString();
        return newss;
    }

    public static boolean isInfinity(double x) {
        boolean test = false;
        if (x == Double.POSITIVE_INFINITY || x == Double.NEGATIVE_INFINITY) {
            test = true;
        }
        return test;
    }

    public static boolean isInfinity(float x) {
        boolean test = false;
        if (x == Float.POSITIVE_INFINITY || x == Float.NEGATIVE_INFINITY) {
            test = true;
        }
        return test;
    }

    public static boolean isPlusInfinity(double x) {
        boolean test = false;
        if (x == Double.POSITIVE_INFINITY) {
            test = true;
        }
        return test;
    }

    public static boolean isPlusInfinity(float x) {
        boolean test = false;
        if (x == Float.POSITIVE_INFINITY) {
            test = true;
        }
        return test;
    }

    public static boolean isMinusInfinity(double x) {
        boolean test = false;
        if (x == Double.NEGATIVE_INFINITY) {
            test = true;
        }
        return test;
    }

    public static boolean isMinusInfinity(float x) {
        boolean test = false;
        if (x == Float.NEGATIVE_INFINITY) {
            test = true;
        }
        return test;
    }

    public static boolean isNaN(double x) {
        boolean test = false;
        if (x != x) {
            test = true;
        }
        return test;
    }

    public static boolean isNaN(float x) {
        boolean test = false;
        if (x != x) {
            test = true;
        }
        return test;
    }

    public static boolean isEqual(double x, double y) {
        boolean test = false;
        if (Fmath.isNaN(x)) {
            if (Fmath.isNaN(y)) {
                test = true;
            }
        } else if (Fmath.isPlusInfinity(x)) {
            if (Fmath.isPlusInfinity(y)) {
                test = true;
            }
        } else if (Fmath.isMinusInfinity(x)) {
            if (Fmath.isMinusInfinity(y)) {
                test = true;
            }
        } else if (x == y) {
            test = true;
        }
        return test;
    }

    public static boolean isEqual(float x, float y) {
        boolean test = false;
        if (Fmath.isNaN(x)) {
            if (Fmath.isNaN(y)) {
                test = true;
            }
        } else if (Fmath.isPlusInfinity(x)) {
            if (Fmath.isPlusInfinity(y)) {
                test = true;
            }
        } else if (Fmath.isMinusInfinity(x)) {
            if (Fmath.isMinusInfinity(y)) {
                test = true;
            }
        } else if (x == y) {
            test = true;
        }
        return test;
    }

    public static boolean isEqual(int x, int y) {
        boolean test = false;
        if (x == y) {
            test = true;
        }
        return test;
    }

    public static boolean isEqual(char x, char y) {
        boolean test = false;
        if (x == y) {
            test = true;
        }
        return test;
    }

    public static boolean isEqual(String x, String y) {
        boolean test = false;
        if (x.equals(y)) {
            test = true;
        }
        return test;
    }

    public static boolean isEven(int x) {
        boolean test = false;
        if ((double)(x % 2) == 0.0) {
            test = true;
        }
        return test;
    }

    public static int compare(double x, double y) {
        Double X = new Double(x);
        Double Y = new Double(y);
        return X.compareTo(Y);
    }

    public static int compare(int x, int y) {
        Integer X = new Integer(x);
        Integer Y = new Integer(y);
        return X.compareTo(Y);
    }

    public static int compare(long x, long y) {
        Long X = new Long(x);
        Long Y = new Long(y);
        return X.compareTo(Y);
    }

    public static int compare(float x, float y) {
        Float X = new Float(x);
        Float Y = new Float(y);
        return X.compareTo(Y);
    }

    public static int compare(byte x, byte y) {
        Byte X = new Byte(x);
        Byte Y = new Byte(y);
        return X.compareTo(Y);
    }

    public static int compare(short x, short y) {
        Short X = new Short(x);
        Short Y = new Short(y);
        return X.compareTo(Y);
    }

    public static boolean isEven(float x) {
        double y = Math.floor(x);
        if ((double)x - y != 0.0) {
            throw new IllegalArgumentException("the argument is not an integer");
        }
        boolean test = false;
        y = Math.floor(x / 2.0f);
        if ((double)(x / 2.0f) - y == 0.0) {
            test = true;
        }
        return test;
    }

    public static boolean isEven(double x) {
        double y = Math.floor(x);
        if (x - y != 0.0) {
            throw new IllegalArgumentException("the argument is not an integer");
        }
        boolean test = false;
        y = Math.floor(x / 2.0);
        if (x / 2.0 - y == 0.0) {
            test = true;
        }
        return test;
    }

    public static boolean isOdd(int x) {
        boolean test = true;
        if ((double)(x % 2) == 0.0) {
            test = false;
        }
        return test;
    }

    public static boolean isOdd(float x) {
        double y = Math.floor(x);
        if ((double)x - y != 0.0) {
            throw new IllegalArgumentException("the argument is not an integer");
        }
        boolean test = true;
        y = Math.floor(x / 2.0f);
        if ((double)(x / 2.0f) - y == 0.0) {
            test = false;
        }
        return test;
    }

    public static boolean isOdd(double x) {
        double y = Math.floor(x);
        if (x - y != 0.0) {
            throw new IllegalArgumentException("the argument is not an integer");
        }
        boolean test = true;
        y = Math.floor(x / 2.0);
        if (x / 2.0 - y == 0.0) {
            test = false;
        }
        return test;
    }

    public static boolean leapYear(int year) {
        boolean test = false;
        test = year % 4 != 0 ? false : (year % 400 == 0 ? true : year % 100 != 0);
        return test;
    }

    public static long dateToJavaMilliS(int year, int month, int day, int hour, int min, int sec) {
        long[] monthDays = new long[]{0L, 31L, 28L, 31L, 30L, 31L, 30L, 31L, 31L, 30L, 31L, 30L, 31L};
        long ms = 0L;
        long yearDiff = 0L;
        for (int yearTest = year - 1; yearTest >= 1970; --yearTest) {
            yearDiff += 365L;
            if (!Fmath.leapYear(yearTest)) continue;
            ++yearDiff;
        }
        yearDiff *= 86400000L;
        long monthDiff = 0L;
        for (int monthTest = month - 1; monthTest > 0; --monthTest) {
            monthDiff += monthDays[monthTest];
            if (!Fmath.leapYear(year)) continue;
            ++monthDiff;
        }
        ms = yearDiff + (monthDiff *= 86400000L) + (long)day * 24L * 60L * 60L * 1000L + (long)hour * 60L * 60L * 1000L + (long)min * 60L * 1000L + (long)sec * 1000L;
        return ms;
    }
}

