/*
 * Decompiled with CFR 0.152.
 */
package fmph.features.mitochondrion1;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.CacheStrategySpec;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerEdge;
import calhoun.analysis.crf.FeatureManagerNode;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExonerateMitochondrion1
extends AbstractFeatureManager<Integer>
implements FeatureManagerNode<Integer>,
FeatureManagerEdge<Integer> {
    private static final Log log = LogFactory.getLog(ExonerateMitochondrion1.class);
    boolean debug = log.isDebugEnabled();
    int startIx;
    ModelManager model;
    boolean[] intergenicState;
    boolean[] plusExonState;
    boolean[] minusExonState;
    boolean[] plusIntronState;
    boolean[] minusIntronState;

    @Override
    public int getNumFeatures() {
        return 10;
    }

    @Override
    public String getFeatureName(int featureIndex) {
        String[] types = new String[]{"exon plus", "exon minus", "intron plus", "intron minus", "Intergenic"};
        int raw = featureIndex - this.startIx;
        if (raw < 5) {
            return "Exonerate " + types[raw];
        }
        String[] edge = new String[]{"acc plus", "acc minus", "donor plus", "donor minus", "no edge"};
        return "Exonerate " + edge[raw - 5];
    }

    @Override
    public void evaluateNode(InputSequence<? extends Integer> seq, int pos, int state, FeatureList result) {
        int exState = seq.getX(pos);
        if (this.plusExonState[state] && exState == 1) {
            result.addFeature(this.startIx, 1.0);
        }
        if (this.minusExonState[state] && exState == 2) {
            result.addFeature(this.startIx + 1, 1.0);
        }
        if (this.plusIntronState[state] && exState == 3) {
            result.addFeature(this.startIx + 2, 1.0);
        }
        if (this.minusIntronState[state] && exState == 4) {
            result.addFeature(this.startIx + 3, 1.0);
        }
        if (this.intergenicState[state] && exState > 0) {
            result.addFeature(this.startIx + 4, 1.0);
        }
    }

    @Override
    public void evaluateEdge(InputSequence<? extends Integer> seq, int pos, int prevState, int state, FeatureList result) {
        if (pos == 0) {
            return;
        }
        int exState = seq.getX(pos);
        int exStateP = seq.getX(pos - 1);
        Boolean plusacc = exStateP == 3 && exState == 1;
        Boolean plusdon = exStateP == 1 && exState == 3;
        Boolean minusacc = exStateP == 4 && exState == 2;
        Boolean minusdon = exStateP == 2 && exState == 4;
        if (plusacc.booleanValue() && this.plusExonState[state] && this.plusIntronState[prevState]) {
            result.addFeature(this.startIx + 5, 1.0);
            return;
        }
        if (minusacc.booleanValue() && this.minusExonState[prevState] && this.minusIntronState[state]) {
            result.addFeature(this.startIx + 6, 1.0);
            return;
        }
        if (plusdon.booleanValue() && this.plusIntronState[state] && this.plusExonState[prevState]) {
            result.addFeature(this.startIx + 7, 1.0);
            return;
        }
        if (minusdon.booleanValue() && this.plusIntronState[prevState] && this.plusExonState[state]) {
            result.addFeature(this.startIx + 8, 1.0);
            return;
        }
        result.addFeature(this.startIx + 9, 1.0);
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List<? extends TrainingSequence<? extends Integer>> data) {
        this.startIx = startingIndex;
        this.model = modelInfo;
        int nStates = this.model.getNumStates();
        this.plusExonState = new boolean[nStates];
        this.plusExonState[this.model.getStateIndex((String)"exon0")] = true;
        this.plusExonState[this.model.getStateIndex((String)"exon1")] = true;
        this.plusExonState[this.model.getStateIndex((String)"exon2")] = true;
        this.minusExonState = new boolean[nStates];
        this.minusExonState[this.model.getStateIndex((String)"exon0m")] = true;
        this.minusExonState[this.model.getStateIndex((String)"exon1m")] = true;
        this.minusExonState[this.model.getStateIndex((String)"exon2m")] = true;
        this.plusIntronState = new boolean[nStates];
        this.plusIntronState[this.model.getStateIndex((String)"intron0")] = true;
        this.plusIntronState[this.model.getStateIndex((String)"intron1")] = true;
        this.plusIntronState[this.model.getStateIndex((String)"intron2")] = true;
        this.minusIntronState = new boolean[nStates];
        this.minusIntronState[this.model.getStateIndex((String)"intron0m")] = true;
        this.minusIntronState[this.model.getStateIndex((String)"intron1m")] = true;
        this.minusIntronState[this.model.getStateIndex((String)"intron2m")] = true;
        this.intergenicState = new boolean[nStates];
        this.intergenicState[this.model.getStateIndex((String)"intergenic")] = true;
    }

    @Override
    public CacheStrategySpec getCacheStrategy() {
        return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.DENSE);
    }
}

