/*
 * Decompiled with CFR 0.152.
 */
package fmph.features.mitochondrion1;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.CacheStrategySpec;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerNode;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IntronHitsMitochondrion1
extends AbstractFeatureManager<Integer>
implements FeatureManagerNode<Integer> {
    private static final Log log = LogFactory.getLog(IntronHitsMitochondrion1.class);
    boolean debug = log.isDebugEnabled();
    int startIx;
    ModelManager model;
    boolean[] intergenicState;
    boolean[] plusExonState;
    boolean[] minusExonState;
    boolean[] plusIntronState;
    boolean[] minusIntronState;

    @Override
    public int getNumFeatures() {
        return 3;
    }

    @Override
    public String getFeatureName(int featureIndex) {
        String[] types = new String[]{"exon", "intron", "Intergenic"};
        int raw = featureIndex - this.startIx;
        return "Intron hits " + types[raw];
    }

    @Override
    public void evaluateNode(InputSequence<? extends Integer> seq, int pos, int state, FeatureList result) {
        int intronState = seq.getX(pos);
        if (this.plusExonState[state] && intronState == 1 || this.minusExonState[state] && intronState == 2) {
            result.addFeature(this.startIx, 1.0);
        }
        if (this.plusIntronState[state] && intronState == 1 || this.minusIntronState[state] && intronState == 2) {
            result.addFeature(this.startIx + 1, 1.0);
        }
        if (this.intergenicState[state] && (intronState == 1 || intronState == 2)) {
            result.addFeature(this.startIx + 2, 1.0);
        }
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List<? extends TrainingSequence<? extends Integer>> data) {
        this.startIx = startingIndex;
        this.model = modelInfo;
        int nStates = this.model.getNumStates();
        this.plusExonState = new boolean[nStates];
        this.plusExonState[this.model.getStateIndex((String)"exon0")] = true;
        this.plusExonState[this.model.getStateIndex((String)"exon1")] = true;
        this.plusExonState[this.model.getStateIndex((String)"exon2")] = true;
        this.minusExonState = new boolean[nStates];
        this.minusExonState[this.model.getStateIndex((String)"exon0m")] = true;
        this.minusExonState[this.model.getStateIndex((String)"exon1m")] = true;
        this.minusExonState[this.model.getStateIndex((String)"exon2m")] = true;
        this.plusIntronState = new boolean[nStates];
        this.plusIntronState[this.model.getStateIndex((String)"intron0")] = true;
        this.plusIntronState[this.model.getStateIndex((String)"intron1")] = true;
        this.plusIntronState[this.model.getStateIndex((String)"intron2")] = true;
        this.minusIntronState = new boolean[nStates];
        this.minusIntronState[this.model.getStateIndex((String)"intron0m")] = true;
        this.minusIntronState[this.model.getStateIndex((String)"intron1m")] = true;
        this.minusIntronState[this.model.getStateIndex((String)"intron2m")] = true;
        this.intergenicState = new boolean[nStates];
        this.intergenicState[this.model.getStateIndex((String)"intergenic")] = true;
    }

    @Override
    public CacheStrategySpec getCacheStrategy() {
        return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.DENSE);
    }
}

